/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken;

import com.anf.pkcs10.PKCS10Request;
import com.anf.pkcs10.PKCS10RequestFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.util.encoders.Hex;

public class TestCSRExtensions {
    public static void main(String[] args) throws Throwable {
        File csrFile = new File("../ANFPKCS10/csr.txt");
        byte[] content = IOUtils.toByteArray((InputStream)new FileInputStream(csrFile));
        PKCS10Request request = PKCS10RequestFactory.createPKCS10((byte[])(content = Hex.decode((byte[])content)));
        Extensions csrExtensions = request.getExtensions();
        if (csrExtensions != null) {
            ASN1ObjectIdentifier[] extensionOIDs;
            for (ASN1ObjectIdentifier oid : extensionOIDs = csrExtensions.getExtensionOIDs()) {
                Extension ext = csrExtensions.getExtension(oid);
                ASN1OctetString extnValue = ext.getExtnValue();
                ASN1Primitive obj = ASN1Primitive.fromByteArray((byte[])extnValue.getOctets());
                System.out.println(obj.getClass() + " " + oid + " " + obj);
            }
        }
        System.out.println();
    }
}

