/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.cryptotoken.ANFCryptoToken;
import com.anf.cryptotoken.ANFCryptoTokenFactory;
import com.anf.cryptotoken.DeviceManager;
import com.anf.cryptotoken.api.tkmanager.AuthInfo;
import com.anf.cryptotoken.api.tkmanager.exception.NOPINException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.credentials.CredentialsControllerFactory;
import com.anf.cryptotoken.device.CertificateInfo;
import com.anf.cryptotoken.device.DeviceInfo;
import com.anf.cryptotoken.device.StoreInfo;
import com.anf.cryptotoken.device.impl.CertificateInfoImpl;
import com.anf.cryptotoken.device.impl.DeviceInfoImpl;
import com.anf.cryptotoken.device.impl.StoreInfoImpl;
import com.anf.cryptotoken.impl.ANFCryptoTokenFactoryImpl;
import com.anf.cryptotoken.impl.ANFCryptoTokenImpl;
import com.anf.cryptotoken.impl.DeviceManagerImpl;
import com.anf.cryptotoken.io.LockerImpl;
import com.anf.cryptotoken.json.TrayIconShowWindow;
import com.anf.cryptotoken.json.TrayIconUserLogin;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.server.CentralServerController;
import com.anf.cryptotoken.server.TrayIconClient;
import com.anf.cryptotoken.tkmanager.AuthInfoImpl;
import com.anf.cryptotoken.tkmanager.ManagerType;
import com.anf.cryptotoken.tkmanager.TKManagerPFXRemote;
import com.anf.cryptotoken.tkmanager.token.detect.TokenDetector;
import com.anf.cryptotoken.tkmanager.token.detect.TokenDetectorClient;
import com.anf.cryptotoken.tkmanager.token.detect.impl.TokenDetectorImpl;
import com.anf.cryptotoken.tsl.TSLController;
import com.anf.cryptotoken.ui.keyboard.handler.KeyBoardHandler;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.usb.impl.USBUnitImpl;
import com.anf.firmas.utils.Utilities;
import com.anf.oauth.json.JSONFactory;
import com.anf.utils.OSUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyPair;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.FailedLoginException;

public final class ANFControl {
    private static final Logger log = Logger.getLogger(ANFControl.class);
    private static boolean initialized = false;
    private static ANFControl control;
    private static boolean usingProxy;
    private TSLController tslControl;
    private CredentialsController credentialsController;
    private ANFCryptoTokenFactory tokenFactory;
    private DeviceManager deviceManager;
    private TokenDetector tokenDetector = new TokenDetectorImpl();
    private static final String[] libraries;

    public static void destroy() {
        control = null;
    }

    private static void loadP11Libs() {
        if (!OSUtils.isWindows() || new File("PKCS11Libs").exists()) {
            // empty if block
        }
    }

    private ANFControl() {
        this.tokenFactory = new ANFCryptoTokenFactoryImpl(this.tokenDetector);
        this.deviceManager = new DeviceManagerImpl(this.tokenFactory);
        this.credentialsController = CredentialsControllerFactory.buildDefault();
        OSUtils.getPID();
        if (OSUtils.isWindows()) {
            ANFControl.fixAdobeTSULimit();
        }
    }

    public void startTokenDetectorThreads(boolean constantDetect, boolean usbDetect, boolean cardDetect, boolean trayIconDetect) {
        this.tokenDetector.configure(constantDetect, usbDetect, cardDetect, trayIconDetect);
        this.tokenDetector.start();
    }

    public void startTokenDetectorThreads() {
        this.tokenDetector.start();
    }

    public static ANFControl get() {
        if (initialized) {
            return control;
        }
        LockerImpl locker = LockerImpl.get((String)"ANFControl");
        try {
            return (ANFControl)locker.lock(i -> {
                if (control == null) {
                    control = new ANFControl();
                }
                initialized = true;
                return control;
            }, null);
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    public ANFCryptoToken getInstance() {
        return this.tokenFactory.getInstance();
    }

    public ANFCryptoToken getInstancePFX(InputStream pfxStream, char[] pass) {
        return this.tokenFactory.getInstancePFX(pfxStream, pass);
    }

    public ANFCryptoToken getInstancePFX(File pfx, char[] pass) {
        return this.tokenFactory.getInstancePFX(pfx, pass);
    }

    public ANFCryptoToken getInstancePFXRemote(TKManagerPFXRemote pfx) {
        return this.tokenFactory.getInstancePFXRemote(pfx);
    }

    public ANFCryptoToken updateInstance(ManagerType type) {
        return this.tokenFactory.updateInstance(type);
    }

    public ANFCryptoToken getWindowsInstance() throws Throwable {
        return this.getInstance(ManagerType.WINDOWS);
    }

    public ANFCryptoToken getInstance(ManagerType type) {
        return this.tokenFactory.getInstance(type);
    }

    public ANFCryptoToken getServerDefault() {
        return this.tokenFactory.getServerDefault();
    }

    public ANFCryptoToken getServer(String user, String pass) {
        return this.tokenFactory.getServer(user, pass);
    }

    public ANFCryptoToken getServer(String user, String pass, boolean usePasswordAsPIN) {
        return this.tokenFactory.getServer(user, pass, usePasswordAsPIN);
    }

    public ANFCryptoToken getServer(String user, String pass, char[] pin) {
        return this.tokenFactory.getServer(user, pass, pin);
    }

    public void addUpdateClient(TokenDetectorClient client) {
        this.tokenDetector.addClient(client);
    }

    public void removeUpdateClient(TokenDetectorClient client) {
        this.tokenDetector.removeClient(client);
    }

    public static int terminateFirefox() {
        try {
            File firefox = ANFControl.getFirefoxInstalledFile();
            if (firefox.exists()) {
                String command = "TASKKILL /F /IM \"firefox.exe\"";
                Process kill = Runtime.getRuntime().exec(command);
                kill.waitFor();
                return kill != null ? kill.exitValue() : -1;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return -2;
        }
        return -3;
    }

    public static int startFirefox() {
        try {
            File firefox = ANFControl.getFirefoxInstalledFile();
            if (firefox.exists()) {
                Process p = Runtime.getRuntime().exec(firefox.getAbsolutePath());
                return p != null ? 0 : -1;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return -2;
        }
        return -3;
    }

    public static int restartFirefox() {
        int terminateFirefox = ANFControl.terminateFirefox();
        if (terminateFirefox >= 0) {
            return ANFControl.startFirefox();
        }
        return terminateFirefox;
    }

    public static File getFirefoxInstalledFile() {
        File[] dirs;
        String progFiles = System.getenv().get("PROGRAMFILES");
        if (progFiles == null) {
            progFiles = System.getenv().get("ProgramFiles");
        }
        log.info((Object)progFiles);
        File dir = new File(progFiles);
        if (dir.exists() && (dirs = dir.listFiles()) != null) {
            for (int i = 0; i < dirs.length; ++i) {
                File[] files;
                if (!dirs[i].isDirectory() || (files = dirs[i].listFiles()) == null) continue;
                for (int j = 0; j < files.length; ++j) {
                    if (!files[j].getName().equals("firefox.exe")) continue;
                    return files[j];
                }
            }
        }
        return null;
    }

    public static void printProperties() {
        Properties properties = System.getProperties();
        Set<Map.Entry<Object, Object>> props = properties.entrySet();
        for (Map.Entry<Object, Object> e : props) {
            log.info((Object)(e.getKey() + " | " + e.getValue()));
        }
    }

    public static void install() throws IOException {
        String os;
        Object root = System.getenv("SystemRoot");
        if (root == null) {
            root = System.getenv("SYSTEMROOT");
        }
        if (root != null && (os = System.getenv("os")) != null && os.toLowerCase().contains("windows")) {
            root = (String)root + File.separator + "System32";
            for (int i = 0; i < libraries.length; ++i) {
                File lib = new File(libraries[i]);
                if (!lib.exists()) continue;
                byte[] content = Utilities.readFile(lib.getAbsolutePath());
                File dest = new File((String)root, lib.getName());
                Utilities.writeFile(dest.getAbsolutePath(), content, true);
            }
        }
    }

    public static void printEnviroment() {
        Map<String, String> env = System.getenv();
        Set<Map.Entry<String, String>> envset = env.entrySet();
        for (Map.Entry<String, String> e : envset) {
            log.info((Object)(e.getKey() + " | " + e.getValue()));
        }
    }

    public boolean isUpdate() {
        return this.tokenDetector.isUpdating();
    }

    public void setUpdate(boolean u) {
        this.tokenFactory.setUpdate(u);
    }

    public static void setUsingProxy(boolean usingProxy) {
        ANFControl.usingProxy = usingProxy;
    }

    public static boolean isUsingProxy() {
        return usingProxy;
    }

    public static URLConnection connect(URL url) throws IOException {
        if (usingProxy) {
            Authenticator authenticator = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    String userName = "cearidriguezb";
                    char[] password = null;
                    try {
                        String id = "proxy";
                        password = KeyBoardHandler.getPassword(id, "Contrase\u00f1a del proxy de Internet para el usuario: cearidriguezb", false, false, null);
                    }
                    catch (NOPINException e) {
                        log.error((Object)e);
                    }
                    return new PasswordAuthentication("cearidriguezb", password);
                }
            };
            Authenticator.setDefault(authenticator);
            return url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("10.8.6.43", 3128)));
        }
        return url.openConnection();
    }

    public static void sendAuthURL(X509Certificate cert) throws FailedLoginException, CertificateEncodingException {
        ANFControl.get().sendAuthURLCert(cert);
    }

    public void sendAuthURLCert(X509Certificate cert) throws FailedLoginException, CertificateEncodingException {
        this.credentialsController.sendAuthURL(cert);
    }

    public static void setUrlAuthInfo(String url, String appName, String version, String ip) throws MalformedURLException {
        ANFControl.get().setCredentialUrlAuthInfo(url, appName, version, ip);
    }

    public void setCredentialUrlAuthInfo(String url, String appName, String version, String ip) throws MalformedURLException {
        this.credentialsController.setUrlAuthInfo(url, appName, version, ip);
    }

    public void setUrlAuthInfoClear() {
        this.credentialsController.setUrlAuthInfoClear();
    }

    public boolean login(ManagerType type, String serialNumber, String alias) {
        boolean login = false;
        ANFCryptoToken m = this.tokenFactory.getInstance(type);
        this.credentialsController.sendAuthURL(m.getCertificate(serialNumber, alias));
        login = m.login(serialNumber, alias);
        return login;
    }

    public boolean login(ANFCryptoToken m, String serialNumber, String alias) {
        boolean login = false;
        this.credentialsController.sendAuthURL(m.getCertificate(serialNumber, alias));
        login = m.login(serialNumber, alias);
        return login;
    }

    public KeyPair getKeyPair(ANFCryptoToken m, String serialNumber, String alias) {
        this.credentialsController.sendAuthURL(m.getCertificate(serialNumber, alias));
        return m.getKeyPair(serialNumber, alias);
    }

    public static String getCompany() {
        String comp = System.getProperty("anf.company");
        if (comp == null) {
            return "anf";
        }
        return comp;
    }

    public static String setCompany(String company) {
        if (company != null) {
            String comp = System.setProperty("anf.company", company);
            return comp;
        }
        throw new NullPointerException("company is null");
    }

    public static int fixAdobeTSULimit() {
        try {
            Process pn = Runtime.getRuntime().exec("reg add \"HKCU\\SOFTWARE\\Adobe\\Acrobat Reader\\DC\\Security\\cASPKI\\cAdobe_TSPProvider\" /v iSize /t REG_DWORD /d 10240 /f /reg:" + ANFControl.getArch() + " ");
            if (pn.waitFor(1L, TimeUnit.SECONDS)) {
                int exitValue = pn.exitValue();
                log.info((Object)("valor de salida de fixAdobeTSULimit " + exitValue));
                return exitValue;
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        log.info((Object)"valor de salida de fixAdobeTSULimit -1");
        return -1;
    }

    private static int getArch() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        return arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? 64 : 32;
    }

    public static boolean isTrayIconRunning() {
        TrayIconUserLogin result = null;
        try {
            result = TrayIconClient.loginToLocalAuthServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null;
    }

    public static boolean showTrayIcon() {
        TrayIconShowWindow result = null;
        try {
            result = TrayIconClient.openTrayIconWindows();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result != null && result.isResult();
    }

    @Deprecated
    public void configureServerManager(String url) {
        this.tokenFactory.configureServerManager(url);
    }

    public TSLController getTslControl() {
        if (this.tslControl == null) {
            this.tslControl = new TSLController();
        }
        return this.tslControl;
    }

    public CentralServerController getCentralServerController(String user, String pass) {
        return this.tokenFactory.getCentralServerController(user, pass);
    }

    public CentralServerController getCentralServerController() {
        return this.tokenFactory.getCentralServerController();
    }

    public CredentialsController getCredentialsController() {
        return this.credentialsController;
    }

    public boolean isActiveType(ManagerType type) {
        return this.tokenFactory.isActiveType(type);
    }

    public DeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    public ANFCryptoTokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    static {
        usingProxy = false;
        libraries = new String[]{"install/libeay32.dll", "install/msvcr71.dll", "install/ftd2xx.dll"};
        AgregarProveedor.agregarBouncyCastleProvider();
        ANFControl.loadP11Libs();
        JSONFactory.deserializeInterface(CertificateInfo.class, CertificateInfoImpl.class);
        JSONFactory.deserializeInterface(DeviceInfo.class, DeviceInfoImpl.class);
        JSONFactory.deserializeInterface(StoreInfo.class, StoreInfoImpl.class);
        JSONFactory.deserializeInterface(CertificateInfo.class, CertificateInfoImpl.class);
        JSONFactory.deserializeInterface(USB.class, USBUnitImpl.class);
        JSONFactory.deserializeInterface(AuthInfo.class, AuthInfoImpl.class);
        JSONFactory.deserializeInterface(ANFCryptoToken.class, ANFCryptoTokenImpl.class);
        JSONFactory.getMapper();
    }
}

