/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.download;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.download.exception.ANFCertDownloadException;
import com.anf.cryptotoken.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class IssuedCertDownloadClient {
    private static final Logger log = Logger.getLogger(IssuedCertDownloadClient.class);
    private String certDownloadServer = "http://www.anf.es/ra/issuedcertificateretrieve";

    public IssuedCertDownloadClient() {
        this.certDownloadServer = "https://gestiones.anf.es/download/issued-pkcs7";
    }

    public IssuedCertDownloadClient(String certDownloadServer) {
        this.certDownloadServer = certDownloadServer;
    }

    public X509Certificate[] downloadIssued(X509Certificate[] cert) {
        try {
            X509Certificate[] certs = null;
            if (cert.length >= 1) {
                log.info((Object)("Intentando descargar certificado " + cert[0].getSubjectX500Principal()));
                X509Certificate certificado = cert[0];
                byte[] digestion = this.getPublicKeyHash(certificado);
                certs = this.downloadIssuedFromPublicKeyHash(digestion);
            } else {
                log.warn((Object)"esta cadena de certificados tiene tamano 1");
            }
            return certs;
        }
        catch (IOException | CertificateException | CMSException e) {
            throw new ANFCertDownloadException(e);
        }
    }

    public X509Certificate[] downloadIssuedFromPublicKeyHash(byte[] publicKeyHash) throws MalformedURLException, UnsupportedEncodingException, IOException, CMSException, CertificateException {
        String error;
        X509Certificate[] certs = null;
        URL url = new URL(this.certDownloadServer + "?publickeyhash=" + URLEncoder.encode(new String(Base64.encode((byte[])publicKeyHash)), "UTF-8") + "&pkhash=" + new String(Hex.encode((byte[])publicKeyHash)));
        URLConnection httpCon = url.openConnection();
        httpCon.setDoInput(true);
        httpCon.setDoOutput(false);
        httpCon.connect();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)httpCon.getInputStream(), (OutputStream)bOut);
        String contentType = httpCon.getContentType();
        log.info((Object)("contentType recibido al descargar certificado: " + contentType));
        if (contentType.equals("application/pkcs7-mime")) {
            byte[] arr = bOut.toByteArray();
            ByteArrayInputStream pkcs7Response = new ByteArrayInputStream(arr);
            certs = CertUtils.getCertificates((InputStream)pkcs7Response);
        }
        if ((error = bOut.toString()).equals("<SERVERERROR/>")) {
            log.warn((Object)("No se pudo descargar el certificado emitido: " + error));
            return null;
        }
        return certs;
    }

    private byte[] getPublicKeyHash(X509Certificate certificado) {
        PublicKey publicKey = certificado.getPublicKey();
        return this.getPublicKeyHash(publicKey);
    }

    public byte[] getPublicKeyHash(PublicKey publicKey) {
        byte[] pubKey = publicKey.getEncoded();
        SHA1Digest sha1Digest = new SHA1Digest();
        byte[] digestion = new byte[sha1Digest.getDigestSize()];
        sha1Digest.update(pubKey, 0, pubKey.length);
        sha1Digest.doFinal(digestion, 0);
        System.out.println(new String(Hex.encode((byte[])digestion)));
        return digestion;
    }
}

