/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.xml;

import com.anf.cryptotoken.activation.exception.ParseXmlError;
import com.anf.ra.xml.ApplicationForm;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidAlgorithmParameterException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XmlParser {
    private static final Logger log = LogManager.getLogger(XmlParser.class);

    public ApplicationForm.Applicant parseXml(String xml) {
        ApplicationForm.Applicant app;
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{ApplicationForm.class}).createUnmarshaller();
            ApplicationForm xmlForm = (ApplicationForm)unmarshaller.unmarshal((Reader)new StringReader(xml));
            app = xmlForm.getApplicant();
            short keySize = app.getKey().getKeyLength();
            if (!this.validKeySize(keySize)) {
                app.getKey().setKeyLength((short)2048);
            }
            if (app.getKey().getAlgorithm() == null || app.getKey().getAlgorithm().isBlank() || app.getKey().getAlgorithm().contains("SHA1")) {
                throw new InvalidAlgorithmParameterException("algoritmo de firma no soportado: " + app.getKey().getAlgorithm());
            }
            log.debug("XML de solicitud:\n{}", (Object)xml);
        }
        catch (Exception e) {
            log.error("error al parsear XML de solicitud:\n{}", (Object)xml, (Object)e);
            throw new ParseXmlError(e);
        }
        return app;
    }

    public boolean validKeySize(int n) {
        if (n < 2048) {
            return false;
        }
        return n % 512 == 0;
    }
}

