/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.sig;

import com.anf.cryptotoken.activation.exception.SigDecodingError;
import com.anf.cryptotoken.activation.sig.SigFileDecodingResult;
import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.sign.validation.VerificationResult;
import com.anf.cryptotoken.sign.validation.validator.SMimeValidator;
import com.anf.cryptotoken.sign.validation.validator.factory.ValidatorFactory;
import com.anf.cryptotoken.sign.verifier.ANFCertificateSourceFactory;
import com.anf.cryptotoken.utils.CifradoXML;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SigFileDecoder {
    private static final Logger log = LogManager.getLogger(SigFileDecoder.class);
    private ValidatorFactory builder = new ValidatorFactory();
    private SMimeValidator arValidator = this.builder.setTrustSource((CertificateSource)ANFCertificateSourceFactory.getTrustedCertificateSource()).arValidator();

    public SigFileDecodingResult decodeSigFile(File sigFile, String password) {
        return this.decodeSigFile(sigFile, password, true);
    }

    public SigFileDecodingResult decodeSigFile(File sigFile, String sigPassword, boolean deleteDecodedFile) {
        SigFileDecodingResult decodingResult = new SigFileDecodingResult();
        VerificationResult sigResult = null;
        FileInputStream fileInput = null;
        try {
            String xml;
            sigFile = sigFile.getCanonicalFile();
            String user = FilenameUtils.getBaseName((String)sigFile.getName());
            String passwordDecrypt = "USR_" + user + "_PSW_" + sigPassword;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            fileInput = new FileInputStream(sigFile);
            String archivoDecodificado = new File(Files.anf(), "" + System.nanoTime()).getCanonicalPath();
            File decodedFile = new File(archivoDecodificado);
            try {
                if (CifradoXML.decrypt((String)passwordDecrypt, (InputStream)fileInput, (OutputStream)bout)) {
                    bout.flush();
                    SigFileDecoder.writeDecodedFile(bout, archivoDecodificado);
                    if (this.arValidator.isARSignature(decodedFile)) {
                        try {
                            sigResult = this.arValidator.verifySignatures(decodedFile);
                            xml = this.getSigXMLContent(bout);
                            decodingResult = new SigFileDecodingResult(true, decodedFile, sigResult, xml);
                        }
                        catch (Throwable e) {
                            log.error("error obteniendo xml del sig", e);
                        }
                    }
                }
            }
            catch (Throwable e1) {
                log.info("error decodificando el sig via 1", e1);
            }
            if (!decodingResult.isDecoded()) {
                fileInput.close();
                bout = new ByteArrayOutputStream();
                fileInput = new FileInputStream(sigFile);
                if (CifradoXML.decryptFile((FileInputStream)fileInput, (OutputStream)bout, (String)passwordDecrypt)) {
                    SigFileDecoder.writeDecodedFile(bout, archivoDecodificado);
                    if (this.arValidator.isARSignature(decodedFile)) {
                        try {
                            sigResult = this.arValidator.verifySignatures(new File(archivoDecodificado));
                            xml = this.getSigXMLContent(bout);
                            decodingResult = new SigFileDecodingResult(true, new File(archivoDecodificado), sigResult, xml);
                        }
                        catch (Throwable e) {
                            log.error((Object)e);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new SigDecodingError(e);
        }
        finally {
            if (fileInput != null) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            if (deleteDecodedFile && decodingResult.getDecodedFile() != null && decodingResult.getDecodedFile().exists()) {
                FileUtils.deleteQuietly((File)decodingResult.getDecodedFile());
                log.info("eliminado el decoded file: {}", (Object)decodingResult.getDecodedFile());
            }
        }
        return decodingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSigXMLContent(ByteArrayOutputStream bout) throws IOException {
        try {
            ByteArrayOutputStream signedContent = this.arValidator.getSignedContent(bout.toByteArray());
            return new String(signedContent.toByteArray());
        }
        catch (Exception e) {
            log.error("al parecer el xml del sig no esta firmado", (Throwable)e);
            ByteArrayInputStream xmlStream = new ByteArrayInputStream(bout.toByteArray());
            try (Scanner sc = new Scanner((InputStream)xmlStream, Charset.defaultCharset().toString());){
                while (true) {
                    if (sc.hasNextLine()) {
                        String l = sc.nextLine();
                        if (!l.startsWith("<ApplicationForm") || !l.endsWith("</ApplicationForm>")) continue;
                        String string = l;
                        return string;
                        continue;
                    }
                    break;
                }
            }
            finally {
                bout.close();
            }
            return null;
        }
    }

    public static void writeDecodedFile(ByteArrayOutputStream bout, String archivoDecodificado) throws FileNotFoundException, IOException {
        FileOutputStream fileOutPut = new FileOutputStream(archivoDecodificado);
        IOUtils.write((byte[])bout.toByteArray(), (OutputStream)fileOutPut);
        fileOutPut.flush();
        fileOutPut.close();
    }
}

