/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.csr.params;

import com.anf.cert.utils.CertType;
import com.anf.cryptotoken.activation.csr.mapper.QSCDProfileMapper;
import com.anf.cryptotoken.activation.csr.params.EncodableParams;
import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.ra.xml.ApplicationForm;
import java.util.List;
import java.util.function.UnaryOperator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class PoliciesParams
implements EncodableParams {
    private List<ApplicationForm.Applicant.Policyinfos.PolicyInfo> policies;
    private boolean qcCompliance;
    private ProfilePolicy profile;
    private ASN1ObjectIdentifier policyRoot;
    private CertType certType;
    ApplicationForm.Applicant.Policyinfos.PolicyInfo mainPolicy;
    private UnaryOperator<String> policyOidMapper = new QSCDProfileMapper();

    public PoliciesParams(List<ApplicationForm.Applicant.Policyinfos.PolicyInfo> policies, boolean qcCompliance) {
        this.policies = policies;
        this.qcCompliance = qcCompliance;
        for (ApplicationForm.Applicant.Policyinfos.PolicyInfo policy : policies) {
            CertType type;
            ProfilePolicy policyProfile = PolicyOID.getProfilePolicy((String)policy.getOid());
            if (policyProfile == null || (type = policyProfile.getCertType()) != CertType.signature && type != CertType.seal) continue;
            this.mainPolicy = policy;
            this.certType = type;
            this.profile = policyProfile;
            PolicyOID oid = PolicyOID.fromOid((String)policy.getOid());
            this.policyRoot = oid.policyRoot();
            break;
        }
    }

    public void setPolicyOidMapper(UnaryOperator<String> policyOidMapper) {
        this.policyOidMapper = policyOidMapper;
    }

    public UnaryOperator<String> getPolicyOidMapper() {
        return this.policyOidMapper;
    }

    public List<ApplicationForm.Applicant.Policyinfos.PolicyInfo> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<ApplicationForm.Applicant.Policyinfos.PolicyInfo> policies) {
        this.policies = policies;
    }

    public boolean isQcCompliance() {
        return this.qcCompliance;
    }

    public void setQcCompliance(boolean qcCompliance) {
        this.qcCompliance = qcCompliance;
    }

    public boolean isQscd() {
        return ProfilePolicy.isQSCD((ProfilePolicy)this.profile) || ProfilePolicy.isCentral((ProfilePolicy)this.profile);
    }

    public ASN1ObjectIdentifier getPolicyRoot() {
        return this.policyRoot;
    }

    public CertType getCertType() {
        return this.certType;
    }

    public ProfilePolicy getProfile() {
        return this.profile;
    }

    public ApplicationForm.Applicant.Policyinfos.PolicyInfo getMainPolicy() {
        return this.mainPolicy;
    }
}

