/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.csr.params;

import com.anf.cryptotoken.activation.ActivationResult;
import com.anf.cryptotoken.activation.client.CertRequestActivationClient;
import com.anf.cryptotoken.activation.csr.CsrGenerationParams;
import com.anf.cryptotoken.activation.csr.params.CSRBuildParams;
import com.anf.cryptotoken.activation.csr.params.DirectoriesParams;
import com.anf.cryptotoken.activation.csr.params.ExtKeyUsagesParams;
import com.anf.cryptotoken.activation.csr.params.ExtensionsParams;
import com.anf.cryptotoken.activation.csr.params.KeyUsageParams;
import com.anf.cryptotoken.activation.csr.params.PoliciesParams;
import com.anf.cryptotoken.activation.csr.params.QcStatementsParams;
import com.anf.cryptotoken.activation.csr.params.SubjAltNamesParams;
import com.anf.cryptotoken.activation.csr.params.SubjectParams;
import com.anf.cryptotoken.activation.exception.SigDecodingError;
import com.anf.cryptotoken.activation.params.ActivationParams;
import com.anf.cryptotoken.activation.sig.SigFileDecoder;
import com.anf.cryptotoken.activation.sig.SigFileDecodingResult;
import com.anf.cryptotoken.activation.xml.XmlParser;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.tkmanager.TKManager;
import com.anf.ra.xml.ApplicationForm;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSRParamsBuilder {
    private static final Logger log = LogManager.getLogger(CSRParamsBuilder.class);
    private XmlParser xmlParser = new XmlParser();
    private SigFileDecoder sigFileDecoder = new SigFileDecoder();

    public CSRBuildParams buildCsrParams(ActivationParams params, ActivationResult result) {
        SigFileDecodingResult decodeSigFileResult = params.getDecodeSigFileResult();
        if (decodeSigFileResult == null) {
            decodeSigFileResult = this.sigFileDecoder.decodeSigFile(params.commonParams().getSigFile(), params.commonParams().getSigPassword(), false);
            if (!decodeSigFileResult.isDecoded()) {
                throw new SigDecodingError();
            }
            result.setVerificationResult(decodeSigFileResult.getSignVerificationResult());
            params.setDecodeSigFileResult(decodeSigFileResult);
        } else {
            result.setVerificationResult(decodeSigFileResult.getSignVerificationResult());
        }
        String xml = decodeSigFileResult.getXml();
        result.setXml(xml);
        File signedXml = decodeSigFileResult.getDecodedFile();
        ApplicationForm.Applicant app = decodeSigFileResult.getXmlInfo();
        if (app == null) {
            app = this.xmlParser.parseXml(xml);
            decodeSigFileResult.setXmlInfo(app);
        }
        return this.buildCsrParams(params, app, signedXml);
    }

    public CSRBuildParams buildCsrParams(ActivationParams params, String xml, File signedXml) {
        ApplicationForm.Applicant app = this.xmlParser.parseXml(xml);
        return this.buildCsrParams(params, app, signedXml);
    }

    private CSRBuildParams buildCsrParams(ActivationParams params, ApplicationForm.Applicant app, File signedXml) {
        CertRequestActivationClient activationClient = new CertRequestActivationClient(params.isConnect(), signedXml);
        activationClient.setCsrStore(params.getCsrStore());
        if (params.getRequestURL() != null) {
            activationClient.setCertReqURL(params.getRequestURL());
        }
        List policyInfos = app.getPolicyinfos().getPolicyInfo();
        PoliciesParams policiesParams = params.getPoliciesParams();
        if (policiesParams == null) {
            boolean qcCompliance = app.getQcStatements() != null && Boolean.parseBoolean(app.getQcStatements().getQcCompliance());
            policiesParams = new PoliciesParams(policyInfos, qcCompliance);
        }
        if (params.commonParams().getPolicyOidMapper() != null) {
            policiesParams.setPolicyOidMapper(params.commonParams().getPolicyOidMapper());
        }
        boolean central = ProfilePolicy.isCentral((ProfilePolicy)policiesParams.getProfile());
        boolean qscd = params.isForcedQSCD() || policiesParams.isQscd();
        SubjectParams subjectParams = new SubjectParams(app.getAttributes());
        DirectoriesParams directoriesParams = new DirectoriesParams(app.getSubjectDirectoryAtributes(), policiesParams.getPolicyRoot(), central, qscd);
        TKManager token = params.token();
        ExtensionsParams extensionsParams = new ExtensionsParams(app.getExtensions(), token.getSerialNumberToken(), policiesParams.getProfile(), policiesParams.getPolicyRoot());
        KeyUsageParams keyUsageParams = new KeyUsageParams(app.getKeyusagesnode(), policiesParams.getMainPolicy().getTypecert());
        ExtKeyUsagesParams extKeyUsagesParams = new ExtKeyUsagesParams(app.getExtendedKeyUsagesnode(), policiesParams.getMainPolicy().getTypecert());
        SubjAltNamesParams subjAltNamesParams = new SubjAltNamesParams(policiesParams.getProfile(), app.getSubjectAlternateNames());
        CsrGenerationParams csrGenerationParams = new CsrGenerationParams(app.getKey().getAlgorithm(), token, app.getKey().getKeyLength());
        QcStatementsParams qcStatementsParams = new QcStatementsParams(policiesParams.getProfile(), app.getQcStatements(), central, qscd);
        CSRBuildParams csrParams = new CSRBuildParams();
        activationClient.setCsrStore(params.getCsrStore());
        csrParams.setActivationClient(activationClient);
        csrParams.setSubjectParams(subjectParams);
        csrParams.setPoliciesParams(policiesParams);
        csrParams.setDirectoriesParams(directoriesParams);
        csrParams.setExtensionsParams(extensionsParams);
        csrParams.setKeyUsageParams(keyUsageParams);
        csrParams.setExtKeyUsagesParams(extKeyUsagesParams);
        csrParams.setSubjAltNamesParams(subjAltNamesParams);
        csrParams.setCsrGenerationParams(csrGenerationParams);
        csrParams.setQcStatementsParams(qcStatementsParams);
        return csrParams;
    }
}

