/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.csr;

import com.anf.cryptotoken.activation.csr.EncodableBuilder;
import com.anf.cryptotoken.activation.csr.params.SubjectParams;
import com.anf.ra.xml.ApplicationForm;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class SubjectBuilder
implements EncodableBuilder<SubjectParams, X500Name> {
    @Override
    public X500Name build(SubjectParams params) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        List attributes = params.getAttributes().getAttribute();
        for (ApplicationForm.Applicant.Attributes.Attribute attribute : attributes) {
            String oid = attribute.getAttributeType();
            if (oid.equals(BCStyle.SERIALNUMBER.getId())) {
                builder.addRDN(new ASN1ObjectIdentifier(oid), (ASN1Encodable)new DERPrintableString(this.fixSerialNumber(attribute.getAttributeValue())));
                continue;
            }
            builder.addRDN(new ASN1ObjectIdentifier(oid), (ASN1Encodable)new DERUTF8String(attribute.getAttributeValue()));
        }
        return builder.build();
    }

    @Override
    public ASN1ObjectIdentifier oid() {
        return null;
    }

    private String fixSerialNumber(String serial) {
        return serial;
    }
}

