/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.csr;

import com.anf.cryptotoken.activation.csr.EncodableBuilder;
import com.anf.cryptotoken.activation.csr.params.SubjAltNamesParams;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.pkcs10.utils.ASN1Utils;
import com.anf.ra.xml.ApplicationForm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class SubjAltNameBuilder
implements EncodableBuilder<SubjAltNamesParams, GeneralNames> {
    @Override
    public GeneralNames build(SubjAltNamesParams params) {
        List<ApplicationForm.Applicant.SubjectAlternateNames.SubjectAlternateName> subjAltNames = params.getSubjectAlternateNames().getSubjectAlternateName();
        ArrayList<GeneralName> nombresAlternativos = new ArrayList<GeneralName>();
        X500NameBuilder nameBuilder = new X500NameBuilder();
        TreeSet<String> ignoreOids = new TreeSet<String>(Arrays.asList("1.3.6.1.4.1.18332.20.3", "1.3.6.1.4.1.18332.20.4", "1.3.6.1.4.1.18332.20.5", "1.3.6.1.4.1.18332.20.8"));
        ignoreOids.add("1.3.6.1.4.1.18332.11");
        ignoreOids.add("1.3.6.1.4.1.18332.12");
        ignoreOids.add("1.3.6.1.4.1.18332.13");
        ignoreOids.add("1.3.6.1.4.1.18332.14");
        ignoreOids.add("1.3.6.1.4.1.18332.20.13");
        ignoreOids.add(BCStyle.TELEPHONE_NUMBER.getId());
        ignoreOids.add("2.5.4.23");
        ignoreOids.add(BCStyle.STREET.getId());
        ignoreOids.add(BCStyle.POSTAL_ADDRESS.getId());
        ignoreOids.add(BCStyle.POSTAL_CODE.getId());
        subjAltNames = subjAltNames.stream().filter(name -> {
            if (name.getAlterNameOID() != null) {
                return !ignoreOids.contains(name.getAlterNameOID());
            }
            return true;
        }).toList();
        ProfilePolicy profile = params.getProfile();
        for (ApplicationForm.Applicant.SubjectAlternateNames.SubjectAlternateName name2 : subjAltNames) {
            if (name2.getRfc822Name() != null) {
                GeneralName generalName = new GeneralName(1, name2.getRfc822Name());
                nombresAlternativos.add(generalName);
            }
            if (name2.getDNSName() != null) {
                GeneralName generalNameItem = new GeneralName(2, name2.getDNSName());
                nombresAlternativos.add(generalNameItem);
            }
            if (ProfilePolicy.isQSeal((ProfilePolicy)profile) || name2.getAlterNameOID() == null || name2.getAlterNameOIDValue() == null) continue;
            nameBuilder.addRDN(new ASN1ObjectIdentifier(name2.getAlterNameOID()), (ASN1Encodable)new DERUTF8String(name2.getAlterNameOIDValue()));
        }
        if (!ProfilePolicy.isQSeal((ProfilePolicy)profile) && !this.ecuadorProfile(profile)) {
            String serial;
            X500Name x500Name = params.getX500Name();
            String cn = ASN1Utils.getValue((ASN1ObjectIdentifier)BCStyle.CN, (X500Name)x500Name);
            if (cn != null) {
                nameBuilder.addRDN(BCStyle.CN, cn);
            }
            if ((serial = ASN1Utils.getValue((ASN1ObjectIdentifier)BCStyle.SERIALNUMBER, (X500Name)x500Name)) != null) {
                nameBuilder.addRDN(BCStyle.SERIALNUMBER, serial);
            }
            GeneralName generalNameItem = new GeneralName(4, (ASN1Encodable)nameBuilder.build());
            nombresAlternativos.add(generalNameItem);
        }
        GeneralName[] gn = new GeneralName[nombresAlternativos.size()];
        nombresAlternativos.toArray(gn);
        return new GeneralNames(gn);
    }

    private boolean ecuadorProfile(ProfilePolicy profile) {
        return profile == ProfilePolicy.PN_Archivo || profile == ProfilePolicy.PN_DSCF || profile == ProfilePolicy.RL_Archivo || profile == ProfilePolicy.RL_DSCF || profile == ProfilePolicy.ME_ERD_Archivo || profile == ProfilePolicy.ME_ERD_DSCF || profile == ProfilePolicy.QSEAL_Archivo || profile == ProfilePolicy.QSEAL_DSCF;
    }

    @Override
    public ASN1ObjectIdentifier oid() {
        return Extension.subjectAlternativeName;
    }
}

