/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.csr;

import com.anf.utils.VersionControl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;

public class ElementBuilder {
    private static final Logger log = LogManager.getLogger(ElementBuilder.class);
    private String appVersion = VersionControl.version;

    public ASN1Sequence buildElement(ASN1ObjectIdentifier oid, ASN1Encodable value) {
        if (value != null) {
            if (oid.toString().endsWith("18332.600")) {
                String extValue = value.toString() + " ANFCT " + VersionControl.version;
                if (!extValue.isEmpty() && this.appVersion != null && this.appVersion.length() < 10) {
                    extValue = extValue + " CA " + this.appVersion;
                }
                value = new DERUTF8String(extValue.trim());
            }
            ASN1EncodableVector dataVector = new ASN1EncodableVector();
            dataVector.add((ASN1Encodable)oid);
            dataVector.add(value);
            log.info("OID: {} => \"{}\"", (Object)oid, (Object)value);
            return new DERSequence(dataVector);
        }
        return null;
    }
}

