/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.csr;

import com.anf.cryptotoken.activation.csr.EncodableBuilder;
import com.anf.cryptotoken.activation.csr.params.DirectoriesParams;
import com.anf.cryptotoken.oid.OIDUtils;
import com.anf.ra.xml.ApplicationForm;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;

public class DirectoriesBuilder
implements EncodableBuilder<DirectoriesParams, SubjectDirectoryAttributes> {
    @Override
    public SubjectDirectoryAttributes build(DirectoriesParams params) {
        if (params.getSubjectDirectoryAtributes() != null) {
            List directoryAtributes = params.getSubjectDirectoryAtributes().getSubjectDirectoryAtribute();
            ArrayList<Attribute> vector = new ArrayList<Attribute>();
            for (ApplicationForm.Applicant.SubjectDirectoryAtributes.SubjectDirectoryAtribute attr : directoryAtributes) {
                ASN1ObjectIdentifier attrType = new ASN1ObjectIdentifier(attr.getDirectoryOID());
                DERSet attrValues = new DERSet((ASN1Encodable)new DERPrintableString(attr.getDirectoryValue()));
                Attribute attrb = new Attribute(attrType, (ASN1Set)attrValues);
                vector.add(attrb);
            }
            if (params.isCentraliced() || params.isQscd()) {
                DERSet attrValues = new DERSet((ASN1Encodable)new DERUTF8String("1"));
                Attribute attrb = new Attribute(OIDUtils.getHSMOID((ASN1ObjectIdentifier)params.getPolicyRoot()), (ASN1Set)attrValues);
                vector.add(attrb);
            }
            if (!vector.isEmpty()) {
                return new SubjectDirectoryAttributes(new Vector(vector));
            }
        }
        return null;
    }

    @Override
    public ASN1ObjectIdentifier oid() {
        return Extension.subjectDirectoryAttributes;
    }
}

