/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.activation.csr;

import com.anf.cryptotoken.activation.client.ActivationRequestResult;
import com.anf.cryptotoken.activation.csr.CsrGenerationParams;
import com.anf.cryptotoken.activation.csr.DirectoriesBuilder;
import com.anf.cryptotoken.activation.csr.ElementBuilder;
import com.anf.cryptotoken.activation.csr.EncodableBuilder;
import com.anf.cryptotoken.activation.csr.ExtKeyUsagesBuilder;
import com.anf.cryptotoken.activation.csr.KeyUsagesBuilder;
import com.anf.cryptotoken.activation.csr.PoliciesBuilder;
import com.anf.cryptotoken.activation.csr.QcStatementsBuilder;
import com.anf.cryptotoken.activation.csr.SubjAltNameBuilder;
import com.anf.cryptotoken.activation.csr.SubjectBuilder;
import com.anf.cryptotoken.activation.csr.params.CSRBuildParams;
import com.anf.cryptotoken.activation.csr.params.EncodableParams;
import com.anf.cryptotoken.activation.csr.params.ExtensionsParams;
import com.anf.cryptotoken.activation.exception.XmlDataError;
import com.anf.cryptotoken.oid.OIDUtils;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.pkcs10.utils.ASN1Utils;
import java.math.BigInteger;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class CSRElementsBuilder {
    private static final Logger log = LogManager.getLogger(CSRElementsBuilder.class);
    private SubjectBuilder subjectBuilder = new SubjectBuilder();
    private ElementBuilder elementBuilder = new ElementBuilder();
    private PoliciesBuilder policiesBuilder = new PoliciesBuilder();
    private DirectoriesBuilder directoriesBuilder = new DirectoriesBuilder();
    private SubjAltNameBuilder subjAltNameBuilder = new SubjAltNameBuilder();
    private KeyUsagesBuilder keyUsagesBuilder = new KeyUsagesBuilder();
    private ExtKeyUsagesBuilder extKeyUsagesBuilder = new ExtKeyUsagesBuilder();
    private QcStatementsBuilder qcStatementsBuilder = new QcStatementsBuilder();

    public ActivationRequestResult build(String alias, CSRBuildParams params) {
        X500Name subject = this.subjectBuilder.build(params.getSubjectParams());
        String country = ASN1Utils.getValue((ASN1ObjectIdentifier)BCStyle.C, (X500Name)subject);
        if (country == null) {
            throw new XmlDataError("ERR_NO_COUNTRY_FIELD_XML");
        }
        params.getSubjAltNamesParams().setX500Name(subject);
        ASN1EncodableVector attribsVector = new ASN1EncodableVector();
        this.addElement(attribsVector, this.policiesBuilder, params.getPoliciesParams());
        this.addElement(attribsVector, this.directoriesBuilder, params.getDirectoriesParams());
        this.addElement(attribsVector, this.subjAltNameBuilder, params.getSubjAltNamesParams());
        this.addElement(attribsVector, this.keyUsagesBuilder, params.getKeyUsageParams());
        this.addElement(attribsVector, this.extKeyUsagesBuilder, params.getExtKeyUsagesParams());
        this.addElement(attribsVector, this.qcStatementsBuilder, params.getQcStatementsParams());
        AtomicBoolean serialOidAdded = new AtomicBoolean(false);
        ExtensionsParams extensionsParams = params.getExtensionsParams();
        extensionsParams.getExtensions().getExtension().forEach(ext -> {
            String extOID = ext.getExtensionOID();
            String extValue = ext.getExtensionValue();
            if (OIDUtils.isSerialNumerOID((String)extOID)) {
                this.addElement(attribsVector, new ASN1ObjectIdentifier(extOID), (ASN1Encodable)new DERUTF8String(extensionsParams.getSerialNumberToken()));
                serialOidAdded.set(true);
            } else {
                this.addElement(attribsVector, new ASN1ObjectIdentifier(extOID), (ASN1Encodable)new DERUTF8String(extValue));
            }
        });
        if (!serialOidAdded.get() && !ProfilePolicy.isQSeal((ProfilePolicy)extensionsParams.getProfile())) {
            log.info("el xml de .sig no puso el OID de numero de serie del dispositivo");
            ASN1ObjectIdentifier snOID = OIDUtils.getSerialNumberOID((ASN1ObjectIdentifier)extensionsParams.getPolicyRoot());
            log.info("poniendo como OID de numero de serie del dispositivo: {}", (Object)snOID);
            this.addElement(attribsVector, (ASN1Encodable)new DERUTF8String(extensionsParams.getSerialNumberToken()));
        }
        Date notBefore = new Date(System.currentTimeMillis() - 2592000000L);
        Date notAfter = new Date(System.currentTimeMillis() + 31536000000L);
        BigInteger serial = new BigInteger(20, new Random());
        DERSet csrElements = new DERSet(attribsVector);
        log.info("informacion de OID cargada, se va a generar el PKCS10 para enviarlo");
        CsrGenerationParams csrParams = params.getCsrGenerationParams();
        byte[] p10 = csrParams.getToken().generateRequest(alias, subject, serial, notBefore, notAfter, csrParams.getKeySize(), (ASN1Set)csrElements, csrParams.getSignAlg());
        return params.getActivationClient().sendCertificateRequest(extensionsParams.getLocalizator(), p10);
    }

    private <P extends EncodableParams, R extends ASN1Encodable> void addElement(ASN1EncodableVector attribsVector, EncodableBuilder<P, R> builder, P params) {
        this.addElement(attribsVector, builder.oid(), (ASN1Encodable)builder.build(params));
    }

    private void addElement(ASN1EncodableVector attribsVector, ASN1ObjectIdentifier oid, ASN1Encodable encodable) {
        if (encodable != null) {
            ASN1Sequence sequence = this.elementBuilder.buildElement(oid, encodable);
            this.addElement(attribsVector, (ASN1Encodable)sequence);
        }
    }

    private void addElement(ASN1EncodableVector attribsVector, ASN1Encodable sequence) {
        if (sequence != null) {
            attribsVector.add(sequence);
        }
    }
}

