/*
 * Decompiled with CFR 0.152.
 */
package anf.centralizados.client.client.impl.v2;

import anf.centralizados.client.client.CentralClientV2;
import anf.centralizados.client.client.error.CentralClientError;
import anf.centralizados.client.client.impl.CentralClientGenericImpl;
import anf.centralizados.core.json.response.Response;
import anf.centralizados.core.json.response.ResponseActivationResult;
import anf.centralizados.core.json.response.ResponseBoolean;
import anf.centralizados.core.json.response.ResponseByteArray;
import anf.centralizados.core.json.response.ResponseCreateVerificationCode;
import anf.centralizados.core.json.response.ResponseDownloadCert;
import anf.centralizados.core.json.response.ResponseGetAlias;
import anf.centralizados.core.json.response.ResponseGetCertificateChain;
import anf.centralizados.core.json.response.ResponseGetCountChangePassPin;
import anf.centralizados.core.json.response.ResponseGetCounterInfo;
import anf.centralizados.core.json.response.ResponseGetPersonalInformacion;
import anf.centralizados.core.json.response.ResponseGetPfx;
import anf.centralizados.core.json.response.ResponseGetSigs;
import anf.centralizados.core.json.response.ResponseInfoCert;
import anf.centralizados.core.json.response.ResponseInfoCertificate;
import anf.centralizados.core.json.response.impl.ResponseActivationResultImpl;
import anf.centralizados.core.json.response.impl.ResponseBooleanImpl;
import anf.centralizados.core.json.response.impl.ResponseByteArrayImpl;
import anf.centralizados.core.json.response.impl.ResponseCreateVerificationCodeImpl;
import anf.centralizados.core.json.response.impl.ResponseDownloadCertImpl;
import anf.centralizados.core.json.response.impl.ResponseGetAliasImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCertificateChainImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCountChangePassPinImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCounterInfoImpl;
import anf.centralizados.core.json.response.impl.ResponseGetPersonalInformacionImpl;
import anf.centralizados.core.json.response.impl.ResponseGetPfxImpl;
import anf.centralizados.core.json.response.impl.ResponseGetSigsImpl;
import anf.centralizados.core.json.response.impl.ResponseImpl;
import anf.centralizados.core.json.response.impl.ResponseInfoCertImpl;
import anf.centralizados.core.json.response.impl.ResponseInfoCertificateImpl;
import anf.centralizados.core.json.response.obj.impl.CertRequestInfoObjImpl;
import anf.centralizados.core.json.response.obj.impl.InfoCertificateObjImpl;
import anf.centralizados.core.json.response.obj.impl.InfoChangePinObjImpl;
import anf.centralizados.core.json.response.obj.impl.ResponseSigImpl;
import com.anf.centralizados.converters.CertConverter;
import com.anf.centralizados.error.NullResponseServerException;
import com.anf.centralizados.error.ParseClientSideException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeMap;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.X500Name;

public abstract class CentralClientGenericV2Impl
extends CentralClientGenericImpl
implements CentralClientV2 {
    protected static final String TOKEN_ERROR = "TOKEN_ERROR";
    protected static final String UNKNOW_ERROR = "UNKNOW_ERROR";

    public CentralClientGenericV2Impl(String userId, String url, int timeout) {
        super(userId, url, timeout);
    }

    public CentralClientGenericV2Impl(String userId, String url) {
        super(userId, url);
    }

    @Override
    public void login() {
        ResponseBoolean response = this.existeUsuario();
        if (!response.isSuccess()) {
            throw new CentralClientError("Ha ocurrido un error en la comunicaci\u00f3n con el servidor de certificados centralizados." + (response.getErrorId() != null ? response.getErrorId() : ""));
        }
        if (!response.isResult()) {
            throw new CentralClientError("No existe el usuario.");
        }
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/login/", null, headersIn, null, headersOut);
        response = responseCode == 200 ? new ResponseBooleanImpl(true, true, null) : new ResponseBooleanImpl(false, false, (String)headersOut.get("errorId"));
        if (!response.isSuccess() || !response.isResult()) {
            throw new CentralClientError("No se han podido verificar las credenciales del usuario.");
        }
    }

    @Override
    public ResponseBoolean existeUsuario() {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/existe-usuario/", null, headersIn, null, headersOut);
        if (responseCode == 200) {
            return new ResponseBooleanImpl(true, true, null);
        }
        return new ResponseBooleanImpl(false, false, (String)headersOut.get("errorId"));
    }

    @Override
    public Response loadPfx(byte[] data, String pin, String puk) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("pin", pin);
        headersIn.put("puk", puk);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));){
            out.writeInt(data.length);
            out.write(data);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int responseCode = this.executeDirect("/centralizados/v2/load-pfx/", stream.toByteArray(), headersIn, output, headersOut);
        ResponseImpl response = new ResponseImpl();
        if (responseCode == 200) {
            response.setSuccess(true);
        } else {
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseGetPfx getPfx(String pin, String alias) {
        ResponseGetPfxImpl response;
        block8: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("pin", pin);
            headersIn.put("alias", alias);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/get-pfx/", null, headersIn, output, headersOut);
            response = new ResponseGetPfxImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int size = in.readInt();
                    response.setResult(new byte[size]);
                    in.read(response.getResult());
                    break block8;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseGetSigs getSigs() {
        ResponseGetSigsImpl response;
        block9: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/get-sigs/", null, headersIn, output, headersOut);
            response = new ResponseGetSigsImpl();
            response.setResult(new ArrayList());
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int countSigs = in.readInt();
                    for (int i = 0; i < countSigs; ++i) {
                        String localizador = in.readUTF();
                        String status = in.readUTF();
                        String fechaCreacion = in.readUTF();
                        String fechaActivacion = in.readUTF();
                        response.getResult().add(new ResponseSigImpl(localizador, status, fechaCreacion, fechaActivacion));
                    }
                    break block9;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseActivationResult activateSig(String localizador, String passSig, String pin, String puk) {
        ResponseActivationResultImpl response;
        block11: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("pin", pin);
            headersIn.put("puk", puk);
            headersIn.put("localizador", localizador);
            headersIn.put("passSig", passSig);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/activate-sig/", null, headersIn, output, headersOut);
            response = new ResponseActivationResultImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int i;
                    response.setResult(in.readBoolean());
                    int count = in.readInt();
                    for (i = 0; i < count; ++i) {
                        response.getLogs().add(in.readUTF());
                    }
                    response.setCertsActivated(in.readInt());
                    response.setCertsToActivate(in.readInt());
                    response.setCertReqInfos(new ArrayList());
                    count = in.readInt();
                    for (i = 0; i < count; ++i) {
                        CertRequestInfoObjImpl obj = new CertRequestInfoObjImpl();
                        obj.setUrl(in.readUTF());
                        obj.setLocalizador(in.readUTF());
                        obj.setResponse(in.readUTF());
                        obj.setSubject(in.readUTF());
                        response.getCertReqInfos().add(obj);
                    }
                    response.setXml(in.readUTF());
                    response.setIntegrity(new ArrayList());
                    count = in.readInt();
                    for (i = 0; i < count; ++i) {
                        response.getIntegrity().add(in.readBoolean());
                    }
                    break block11;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseGetAlias getAlias() {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int responseCode = this.executeDirect("/centralizados/v2/get-alias/", null, headersIn, output, headersOut);
        ResponseGetAliasImpl response = new ResponseGetAliasImpl();
        response.setResult(new ArrayList());
        if (responseCode == 200) {
            response.setSuccess(true);
            try {
                HashSet<String> fromServer = new HashSet<String>();
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int countAliass = in.readInt();
                    for (int i = 0; i < countAliass; ++i) {
                        String alias = in.readUTF();
                        if (this.aliass != null) {
                            this.aliass.add(alias);
                            fromServer.add(alias);
                        }
                        response.getResult().add(alias);
                    }
                }
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String alias : this.aliass) {
                    if (fromServer.contains(alias)) continue;
                    toRemove.add(alias);
                }
                for (String alias : toRemove) {
                    this.aliass.remove(alias);
                }
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                throw new ParseClientSideException();
            }
        }
        response.setSuccess(false);
        response.setErrorId((String)headersOut.get("errorId"));
        return response;
    }

    @Override
    public ResponseDownloadCert downloadCert(String alias) {
        ResponseDownloadCertImpl response;
        block8: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("alias", alias);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/download-cert/", null, headersIn, output, headersOut);
            response = new ResponseDownloadCertImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    response.setResult(in.readBoolean());
                    response.setChanged(in.readBoolean());
                    break block8;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public Response notifyCertIssued(String localizador) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("localizador", localizador);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/notify-cert-issued/", null, headersIn, null, headersOut);
        ResponseImpl response = new ResponseImpl();
        if (responseCode == 200) {
            response.setSuccess(true);
        } else {
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseInfoCert getInfoCert(String alias) {
        ResponseInfoCertImpl response;
        block8: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("alias", alias);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/get-info-cert/", null, headersIn, output, headersOut);
            response = new ResponseInfoCertImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    InfoCertificateObjImpl obj = new InfoCertificateObjImpl();
                    obj.setAlias(in.readUTF());
                    obj.setDownloadType(in.readUTF());
                    obj.setEmitido(in.readBoolean());
                    obj.setSerialNumber(in.readUTF());
                    obj.setFechaExpiracion(in.readUTF());
                    obj.setFechaEmision(in.readUTF());
                    obj.setLocalizador(in.readUTF());
                    obj.setCommonName(in.readUTF());
                    obj.setCountry(in.readUTF());
                    obj.setName(in.readUTF());
                    obj.setLastName(in.readUTF());
                    obj.setNif(in.readUTF());
                    obj.setCif(in.readUTF());
                    obj.setOrganizacion(in.readUTF());
                    obj.setPerfil(in.readUTF());
                    obj.setCategoriaNegocio(in.readUTF());
                    obj.setDescripcion(in.readUTF());
                    obj.setCorreo(in.readUTF());
                    obj.setLocalidad(in.readUTF());
                    obj.setEstado(in.readUTF());
                    obj.setDNI(in.readUTF());
                    obj.setTratamiento(in.readUTF());
                    obj.setCodigoPostal(in.readUTF());
                    obj.setNumeroTelefono(in.readUTF());
                    obj.setDireccion(in.readUTF());
                    obj.setIdentificadorOperador(in.readUTF());
                    response.setResult(obj);
                    break block8;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseInfoCertificate getInfoCertificates() {
        ResponseInfoCertificateImpl response;
        block9: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/get-info-certificates/", null, headersIn, output, headersOut);
            response = new ResponseInfoCertificateImpl();
            response.setResult(new ArrayList());
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int count = in.readInt();
                    for (int i = 0; i < count; ++i) {
                        InfoCertificateObjImpl obj = new InfoCertificateObjImpl();
                        obj.setAlias(in.readUTF());
                        obj.setDownloadType(in.readUTF());
                        obj.setEmitido(in.readBoolean());
                        obj.setSerialNumber(in.readUTF());
                        obj.setFechaExpiracion(in.readUTF());
                        obj.setFechaEmision(in.readUTF());
                        obj.setLocalizador(in.readUTF());
                        obj.setCommonName(in.readUTF());
                        obj.setCountry(in.readUTF());
                        obj.setName(in.readUTF());
                        obj.setLastName(in.readUTF());
                        obj.setNif(in.readUTF());
                        obj.setCif(in.readUTF());
                        obj.setOrganizacion(in.readUTF());
                        obj.setPerfil(in.readUTF());
                        obj.setCategoriaNegocio(in.readUTF());
                        obj.setDescripcion(in.readUTF());
                        obj.setCorreo(in.readUTF());
                        obj.setLocalidad(in.readUTF());
                        obj.setEstado(in.readUTF());
                        obj.setDNI(in.readUTF());
                        obj.setTratamiento(in.readUTF());
                        obj.setCodigoPostal(in.readUTF());
                        obj.setNumeroTelefono(in.readUTF());
                        obj.setDireccion(in.readUTF());
                        obj.setIdentificadorOperador(in.readUTF());
                        response.getResult().add(obj);
                    }
                    break block9;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseGetCertificateChain getCertificateChain(String alias) {
        ResponseGetCertificateChainImpl response = new ResponseGetCertificateChainImpl();
        if (!this.aliass.contains(alias)) {
            response.setSuccess(false);
            response.setErrorId("PFX_NOT_EXISTS_ERROR");
            return response;
        }
        this.updateFullCertInfo(alias);
        response.setResult((X509Certificate[])this.certificates.get(alias));
        if (response.getResult() == null) {
            throw new NullResponseServerException();
        }
        response.setSuccess(true);
        return response;
    }

    @Override
    public Response importCertificate(String pin, String puk, String alias, X509Certificate[] certs) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("pin", pin);
        headersIn.put("puk", puk);
        headersIn.put("alias", alias);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));){
            out.writeInt(certs.length);
            for (X509Certificate cert : certs) {
                byte[] data = cert.getEncoded();
                out.writeInt(data.length);
                out.write(data);
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int responseCode = this.executeDirect("/centralizados/v2/import-certificate/", stream.toByteArray(), headersIn, output, headersOut);
        ResponseImpl response = new ResponseImpl();
        if (responseCode == 200) {
            response.setSuccess(true);
        } else {
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public Response removeCertificate(String alias) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("alias", alias);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/remove-certificate/", null, headersIn, null, headersOut);
        ResponseImpl response = new ResponseImpl();
        if (responseCode == 200) {
            response.setSuccess(true);
        } else {
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseByteArray generateRequest(String pin, String puk, String alias, X500Name x500Name, BigInteger serial, Date notBefore, Date notAfter, int keySize, ASN1Set attributes, String signAlias, String signAlg) {
        ResponseByteArrayImpl response;
        block16: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("pin", pin);
            headersIn.put("puk", puk);
            headersIn.put("alias", alias);
            headersIn.put("signAlias", signAlias);
            headersIn.put("signAlg", signAlg);
            headersIn.put("notBefore", "" + notBefore.getTime());
            headersIn.put("notAfter", "" + notAfter.getTime());
            headersIn.put("keySize", "" + keySize);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));){
                byte[] data = x500Name.getEncoded();
                out.writeInt(data.length);
                out.write(data);
                data = serial.toByteArray();
                out.writeInt(data.length);
                out.write(data);
                data = attributes.getEncoded();
                out.writeInt(data.length);
                out.write(data);
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                throw new ParseClientSideException();
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/generate-request/", stream.toByteArray(), headersIn, output, headersOut);
            response = new ResponseByteArrayImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int size = in.readInt();
                    response.setResult(new byte[size]);
                    in.read(response.getResult());
                    break block16;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseByteArray signData(String alias, byte[] data, String signAlgorithm, char[] pin) {
        ResponseByteArrayImpl response;
        block16: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("pin", new String(pin));
            headersIn.put("signAlgorithm", signAlgorithm);
            headersIn.put("alias", alias);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));){
                out.writeInt(data.length);
                out.write(data);
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                throw new ParseClientSideException();
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/sign-data/", stream.toByteArray(), headersIn, output, headersOut);
            response = new ResponseByteArrayImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int size = in.readInt();
                    response.setResult(new byte[size]);
                    in.read(response.getResult());
                    break block16;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseByteArray decryptData(String alias, byte[] encryptedData, String algorithm, char[] pin) {
        ResponseByteArrayImpl response;
        block16: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("pin", new String(pin));
            headersIn.put("algorithm", algorithm);
            headersIn.put("alias", alias);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));){
                out.writeInt(encryptedData.length);
                out.write(encryptedData);
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                throw new ParseClientSideException();
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/decrypt-data/", stream.toByteArray(), headersIn, output, headersOut);
            response = new ResponseByteArrayImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int size = in.readInt();
                    response.setResult(new byte[size]);
                    in.read(response.getResult());
                    break block16;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseGetCounterInfo getCounterInfo(String alias) {
        ResponseGetCounterInfoImpl response;
        block8: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("alias", alias);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/get-counter-info/", null, headersIn, output, headersOut);
            response = new ResponseGetCounterInfoImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    response.setPinCounter(in.readInt());
                    response.setPukCounter(in.readInt());
                    response.setPinEnc(in.readUTF());
                    break block8;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseBoolean unlockPIN(String alias, char[] puk, char[] newPin, String code) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("alias", alias);
        headersIn.put("puk", new String(puk));
        headersIn.put("newPin", new String(newPin));
        headersIn.put("code", code);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/unlock-pin/", null, headersIn, null, headersOut);
        if (responseCode == 200) {
            return new ResponseBooleanImpl(true, true, null);
        }
        return new ResponseBooleanImpl(false, false, (String)headersOut.get("errorId"));
    }

    @Override
    public ResponseBoolean initUserPIN(String alias, String certSerialNumber, char[] pukArray, char[] pinArray) {
        ResponseBooleanImpl response = new ResponseBooleanImpl();
        response.setSuccess(true);
        response.setResult(true);
        return response;
    }

    @Override
    public ResponseBoolean changePIN(String alias, char[] old, char[] newPIN, char[] puk, String code) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("alias", alias);
        headersIn.put("old", new String(old));
        headersIn.put("newPIN", new String(newPIN));
        headersIn.put("puk", new String(puk));
        headersIn.put("code", code);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/change-pin/", null, headersIn, null, headersOut);
        if (responseCode == 200) {
            return new ResponseBooleanImpl(true, true, null);
        }
        return new ResponseBooleanImpl(false, false, (String)headersOut.get("errorId"));
    }

    @Override
    public ResponseBoolean changePassword(String newPassword, String code) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("newPassword", newPassword);
        headersIn.put("code", code);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/change-password/", null, headersIn, null, headersOut);
        if (responseCode == 200) {
            return new ResponseBooleanImpl(true, true, null);
        }
        return new ResponseBooleanImpl(false, false, (String)headersOut.get("errorId"));
    }

    @Override
    public ResponseGetPersonalInformacion getPersonalInformacion() {
        ResponseGetPersonalInformacionImpl response;
        block8: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/get-personal-information/", null, headersIn, output, headersOut);
            response = new ResponseGetPersonalInformacionImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    response.setMail(in.readUTF());
                    response.setPhoneNumber(in.readUTF());
                    response.setAlias(in.readUTF());
                    break block8;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public Response updatePersonalInformation(String mail, String phoneNumber, String alias, String code) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("mail", mail);
        headersIn.put("phoneNumber", phoneNumber);
        headersIn.put("alias", alias);
        headersIn.put("code", code);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/update-personal-information/", null, headersIn, null, headersOut);
        ResponseImpl response = new ResponseImpl();
        if (responseCode == 200) {
            response.setSuccess(true);
        } else {
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseGetCountChangePassPin getCountChangePassPin() {
        ResponseGetCountChangePassPinImpl response;
        block9: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/get-count-change-pass-pin/", null, headersIn, output, headersOut);
            response = new ResponseGetCountChangePassPinImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    response.setCountPassChanges(in.readInt());
                    response.setLastDateChange(in.readUTF());
                    int count = in.readInt();
                    response.setCountChanges(new ArrayList());
                    for (int i = 0; i < count; ++i) {
                        InfoChangePinObjImpl obj = new InfoChangePinObjImpl();
                        obj.setAlias(in.readUTF());
                        obj.setCount(in.readInt());
                        obj.setLastDateChange(in.readUTF());
                        response.getCountChanges().add(obj);
                    }
                    break block9;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseBoolean decodeSig(String localizador, String passSig) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("localizador", localizador);
        headersIn.put("passSig", passSig);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/decode-sig/", null, headersIn, null, headersOut);
        if (responseCode == 200) {
            return new ResponseBooleanImpl(true, true, null);
        }
        return new ResponseBooleanImpl(false, false, (String)headersOut.get("errorId"));
    }

    @Override
    public ResponseCreateVerificationCode createVerificationCode(String mail, String phoneNumber) {
        ResponseCreateVerificationCodeImpl response;
        block8: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("mail", mail);
            headersIn.put("phoneNumber", phoneNumber);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/create-verification-code/", null, headersIn, output, headersOut);
            response = new ResponseCreateVerificationCodeImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    response.setWay(in.readUTF());
                    break block8;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseBoolean validateToken() {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/validate-token/", null, headersIn, null, headersOut);
        if (responseCode == 200) {
            return new ResponseBooleanImpl(true, true, null);
        }
        return new ResponseBooleanImpl(false, false, (String)headersOut.get("errorId"));
    }

    @Override
    public ResponseByteArray validateSmsCredential(String code, String alias, String pin, String retoFirma) {
        ResponseByteArrayImpl response;
        block8: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("code", code);
            headersIn.put("alias", alias);
            headersIn.put("pin", pin);
            headersIn.put("retoFirma", retoFirma);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/validate-sms-credential/", null, headersIn, output, headersOut);
            response = new ResponseByteArrayImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int size = in.readInt();
                    response.setResult(new byte[size]);
                    in.read(response.getResult());
                    break block8;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseByteArray autenticateCert(String alias, String pin, String retoFirma, String url, String appName, String appVersion, String ip, String computerSerialNumber) {
        ResponseByteArrayImpl response;
        block8: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            headersIn.put("alias", alias);
            headersIn.put("pin", pin);
            headersIn.put("retoFirma", retoFirma);
            headersIn.put("url", url);
            headersIn.put("appName", appName);
            headersIn.put("appVersion", appVersion);
            headersIn.put("ip", ip);
            headersIn.put("computerSerialNumber", computerSerialNumber);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/autenticate-cert/", null, headersIn, output, headersOut);
            response = new ResponseByteArrayImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int size = in.readInt();
                    response.setResult(new byte[size]);
                    in.read(response.getResult());
                    break block8;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        return response;
    }

    @Override
    public ResponseBoolean validatePin(String alias, String pin) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("alias", alias);
        headersIn.put("pin", pin);
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        int responseCode = this.executeDirect("/centralizados/v2/validate-pin/", null, headersIn, null, headersOut);
        if (responseCode == 200) {
            return new ResponseBooleanImpl(true, true, null);
        }
        return new ResponseBooleanImpl(false, false, (String)headersOut.get("errorId"));
    }

    @Override
    public final void initCache() {
        this.getFullCertInfo();
    }

    private void getFullCertInfo() {
        block10: {
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("userId", this.userId);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", UNKNOW_ERROR);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/get-full-cert-info/", null, headersIn, output, headersOut);
            if (responseCode == 200) {
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    int countAliass = in.readInt();
                    for (int i = 0; i < countAliass; ++i) {
                        String alias = in.readUTF();
                        String hash = in.readUTF();
                        int countCerts = in.readInt();
                        X509Certificate[] certs = new X509Certificate[countCerts];
                        for (int j = 0; j < countCerts; ++j) {
                            int size = in.readInt();
                            byte[] buffer = new byte[size];
                            in.read(buffer);
                            certs[j] = CertConverter.fromPEM((byte[])buffer);
                        }
                        this.aliass.add(alias);
                        this.certificates.put(alias, certs);
                        this.certificatesHash.put(alias, hash);
                    }
                    break block10;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            log.error("Error desde getFullCertInfo => " + (String)headersOut.get("errorId"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFullCertInfo(String alias) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("alias", alias);
        headersIn.put("hash", (String)this.certificatesHash.get(alias));
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        headersOut.put("errorId", UNKNOW_ERROR);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int responseCode = this.executeDirect("/centralizados/v2/update-full-cert-info/", null, headersIn, output, headersOut);
        if (responseCode == 200) {
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                boolean needUpdate = in.readBoolean();
                if (!needUpdate) return;
                String hash = in.readUTF();
                int countCerts = in.readInt();
                X509Certificate[] certs = new X509Certificate[countCerts];
                for (int j = 0; j < countCerts; ++j) {
                    int size = in.readInt();
                    byte[] buffer = new byte[size];
                    in.read(buffer);
                    certs[j] = CertConverter.fromPEM((byte[])buffer);
                }
                this.certificates.put(alias, certs);
                this.certificatesHash.put(alias, hash);
                return;
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                throw new ParseClientSideException();
            }
        } else {
            log.error("Error desde updateFullCertInfo => " + (String)headersOut.get("errorId"));
        }
    }
}

