/*
 * Decompiled with CFR 0.152.
 */
package anf.centralizados.client.client.impl.v2;

import anf.centralizados.client.client.impl.v2.CentralClientGenericV2Impl;
import anf.centralizados.core.json.request.v2.RequestSessionCertificateV2;
import anf.centralizados.core.json.response.impl.ResponseRequestSessionCertificateImpl;
import com.anf.centralizados.error.NullRequestSessionCertificate;
import com.anf.centralizados.error.NullTokenException;
import com.anf.centralizados.error.ParseClientSideException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.security.cert.X509Certificate;
import java.util.TreeMap;

public class CentralClientCertificateV2Impl
extends CentralClientGenericV2Impl {
    private RequestSessionCertificateV2 requestSessionCertificate;

    public CentralClientCertificateV2Impl(String host, int port) {
        super(null, host, port);
        this.initCache();
    }

    public CentralClientCertificateV2Impl(String url) {
        super(null, url);
        this.initCache();
    }

    public void buildRequestSessionCertificate(X509Certificate certificate, String url, String appName, String appVersion, String ip, String computerSerialNumber) throws Exception {
        this.requestSessionCertificate = new RequestSessionCertificateV2(certificate, url, appName, appVersion, ip, computerSerialNumber);
    }

    @Override
    protected void requestToken(boolean force) {
        ResponseRequestSessionCertificateImpl response;
        block19: {
            if (this.requestSessionCertificate == null) {
                throw new NullRequestSessionCertificate();
            }
            if (this.token != null && !force) {
                return;
            }
            TreeMap<String, String> headersIn = new TreeMap<String, String>();
            headersIn.put("url", this.requestSessionCertificate.url);
            headersIn.put("appName", this.requestSessionCertificate.appName);
            headersIn.put("appVersion", this.requestSessionCertificate.appVersion);
            headersIn.put("ip", this.requestSessionCertificate.ip);
            headersIn.put("computerSerialNumber", this.requestSessionCertificate.computerSerialNumber);
            TreeMap<String, String> headersOut = new TreeMap<String, String>();
            headersOut.put("errorId", "UNKNOW_ERROR");
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));){
                byte[] data = this.requestSessionCertificate.cert.getEncoded();
                out.writeInt(data.length);
                out.write(data);
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                throw new ParseClientSideException();
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int responseCode = this.executeDirect("/centralizados/v2/request-session-certificate/", stream.toByteArray(), headersIn, output, headersOut);
            response = new ResponseRequestSessionCertificateImpl();
            if (responseCode == 200) {
                response.setSuccess(true);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(output.toByteArray())));){
                    response.setUserId(in.readUTF());
                    response.setResult(in.readUTF());
                    break block19;
                }
                catch (Exception e) {
                    log.catching((Throwable)e);
                    throw new ParseClientSideException();
                }
            }
            response.setSuccess(false);
            response.setErrorId((String)headersOut.get("errorId"));
        }
        if (!response.isSuccess() || response.getResult() == null) {
            throw new NullTokenException();
        }
        this.userId = response.getUserId();
        this.token = response.getResult();
    }
}

