/*
 * Decompiled with CFR 0.152.
 */
package anf.centralizados.client.client.impl;

import anf.centralizados.client.client.error.CentralClientError;
import anf.centralizados.client.client.impl.CentralClientGenericImpl;
import anf.centralizados.core.json.request.SimpleRequest;
import anf.centralizados.core.json.request.VerifyQRCodeRequest;
import anf.centralizados.core.json.response.ResponseBoolean;
import anf.centralizados.core.json.response.ResponseRequestSession;
import anf.centralizados.core.json.response.StringResponse;
import anf.centralizados.core.json.response.impl.MFATypeResponse;
import anf.centralizados.core.json.response.impl.ResponseBooleanImpl;
import anf.centralizados.core.json.response.impl.ResponseRequestSessionImpl;
import com.anf.centralizados.error.NullTokenException;
import java.util.Base64;

public class CentralClientPassImpl
extends CentralClientGenericImpl {
    private String pass;

    public CentralClientPassImpl(String userId, String pass, String host, int port) {
        super(userId, host, port);
        this.pass = pass;
    }

    public CentralClientPassImpl(String userId, String pass, String url) {
        super(userId, url);
        this.pass = pass;
    }

    @Override
    public byte[] createQr() {
        StringResponse response = this.execute("/centralizados/api/totp/qrcode", new SimpleRequest(this.userId, this.pass), StringResponse.class);
        if (!response.isSuccess()) {
            throw new CentralClientError(response.getErrorId());
        }
        return Base64.getDecoder().decode(response.getResult());
    }

    @Override
    public boolean verifyTOTP(String code) {
        ResponseBoolean response = (ResponseBoolean)this.execute("/centralizados/api/totp/verify", new VerifyQRCodeRequest(this.userId, this.pass, code), ResponseBooleanImpl.class);
        if (!response.isSuccess()) {
            throw new CentralClientError(response.getErrorId());
        }
        return response.isResult();
    }

    @Override
    public MFATypeResponse checkMFA() {
        MFATypeResponse response = this.execute("/centralizados/api/mfa-type", new SimpleRequest(this.userId, this.pass), MFATypeResponse.class);
        if (!response.isSuccess()) {
            throw new CentralClientError(response.getErrorId());
        }
        return response;
    }

    @Override
    public void login() {
        ResponseBoolean response = (ResponseBoolean)this.execute("/centralizados/api/login/", new SimpleRequest(this.userId, this.pass), ResponseBooleanImpl.class);
        if (!response.isSuccess() || !response.isResult()) {
            throw new CentralClientError("No se han podido verificar las credenciales del usuario." + (String)(response.getErrorId() != null ? "El error es: " + response.getErrorId() : ""));
        }
    }

    @Override
    public ResponseBoolean changePassword(String newPassword, String code) {
        ResponseBoolean resp = super.changePassword(newPassword, code);
        if (resp.isSuccess() && resp.isResult()) {
            this.setPass(newPassword);
        }
        return resp;
    }

    @Override
    protected void requestToken(boolean force) {
        if (this.token != null && !force) {
            return;
        }
        if (this.token == null && this.pass != null && this.pass.length() == 64) {
            this.token = this.pass;
            return;
        }
        SimpleRequest request = new SimpleRequest(this.userId, this.pass);
        ResponseRequestSession response = (ResponseRequestSession)this.execute("/centralizados/api/request-session/", request, ResponseRequestSessionImpl.class, false);
        if (!response.isSuccess() || response.getResult() == null) {
            throw new NullTokenException();
        }
        this.token = response.getResult();
    }

    protected void setPass(String pass) {
        this.pass = pass;
    }
}

