/*
 * Decompiled with CFR 0.152.
 */
package anf.centralizados.client.client.impl;

import anf.centralizados.client.client.CentralClient;
import anf.centralizados.client.client.error.CentralClientError;
import anf.centralizados.core.gson.CloseSession.RequestCloseSesison;
import anf.centralizados.core.gson.CloseSession.ResponseCloseSession;
import anf.centralizados.core.gson.DownloadCertsZip.RequestDownloadCertsZip;
import anf.centralizados.core.gson.DownloadCertsZip.ResponseDownloadCertsZip;
import anf.centralizados.core.gson.GetAllCounterInfo.RequestGetAllCounterInfo;
import anf.centralizados.core.gson.GetAllCounterInfo.ResponseGetAllCounterInfo;
import anf.centralizados.core.json.request.RequestActivateSig;
import anf.centralizados.core.json.request.RequestAutenticateCert;
import anf.centralizados.core.json.request.RequestChangePassword;
import anf.centralizados.core.json.request.RequestChangePin;
import anf.centralizados.core.json.request.RequestCreateVerificationCode;
import anf.centralizados.core.json.request.RequestDecodeSig;
import anf.centralizados.core.json.request.RequestDecryptData;
import anf.centralizados.core.json.request.RequestDownloadCert;
import anf.centralizados.core.json.request.RequestGenerateRequest;
import anf.centralizados.core.json.request.RequestGetCertificate;
import anf.centralizados.core.json.request.RequestGetCertificateChain;
import anf.centralizados.core.json.request.RequestGetCertificates;
import anf.centralizados.core.json.request.RequestGetCounterInfo;
import anf.centralizados.core.json.request.RequestGetInfoCert;
import anf.centralizados.core.json.request.RequestGetPersonalInformation;
import anf.centralizados.core.json.request.RequestGetPfx;
import anf.centralizados.core.json.request.RequestGetSigStatus;
import anf.centralizados.core.json.request.RequestImportCertificate;
import anf.centralizados.core.json.request.RequestLoadPfx;
import anf.centralizados.core.json.request.RequestNotifyCertIssued;
import anf.centralizados.core.json.request.RequestRemoveCertificate;
import anf.centralizados.core.json.request.RequestSignData;
import anf.centralizados.core.json.request.RequestUnlockPin;
import anf.centralizados.core.json.request.RequestUpdatePersonalInformationUser;
import anf.centralizados.core.json.request.RequestValidatePin;
import anf.centralizados.core.json.request.RequestValidateSmsCredential;
import anf.centralizados.core.json.request.RequestValidateToken;
import anf.centralizados.core.json.request.SimpleRequest;
import anf.centralizados.core.json.request.VerifyQRCodeRequest;
import anf.centralizados.core.json.response.Response;
import anf.centralizados.core.json.response.ResponseActivationResult;
import anf.centralizados.core.json.response.ResponseBoolean;
import anf.centralizados.core.json.response.ResponseByteArray;
import anf.centralizados.core.json.response.ResponseByteArrayTmp;
import anf.centralizados.core.json.response.ResponseCreateVerificationCode;
import anf.centralizados.core.json.response.ResponseDownloadCert;
import anf.centralizados.core.json.response.ResponseGetAlias;
import anf.centralizados.core.json.response.ResponseGetCertificate;
import anf.centralizados.core.json.response.ResponseGetCertificateChain;
import anf.centralizados.core.json.response.ResponseGetCertificateChainTmp;
import anf.centralizados.core.json.response.ResponseGetCertificateTmp;
import anf.centralizados.core.json.response.ResponseGetCertificates;
import anf.centralizados.core.json.response.ResponseGetCertificatesTmp;
import anf.centralizados.core.json.response.ResponseGetCountChangePassPin;
import anf.centralizados.core.json.response.ResponseGetCounterInfo;
import anf.centralizados.core.json.response.ResponseGetPersonalInformacion;
import anf.centralizados.core.json.response.ResponseGetPfx;
import anf.centralizados.core.json.response.ResponseGetPfxTmp;
import anf.centralizados.core.json.response.ResponseGetSigStatus;
import anf.centralizados.core.json.response.ResponseGetSigs;
import anf.centralizados.core.json.response.ResponseInfoCert;
import anf.centralizados.core.json.response.ResponseInfoCertificate;
import anf.centralizados.core.json.response.StringResponse;
import anf.centralizados.core.json.response.impl.MFATypeResponse;
import anf.centralizados.core.json.response.impl.ResponseActivationResultImpl;
import anf.centralizados.core.json.response.impl.ResponseBooleanImpl;
import anf.centralizados.core.json.response.impl.ResponseByteArrayImpl;
import anf.centralizados.core.json.response.impl.ResponseByteArrayTmpImpl;
import anf.centralizados.core.json.response.impl.ResponseCreateVerificationCodeImpl;
import anf.centralizados.core.json.response.impl.ResponseDownloadCertImpl;
import anf.centralizados.core.json.response.impl.ResponseGetAliasImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCertificateChainImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCertificateChainTmpImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCertificateImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCertificateTmpImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCertificatesImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCertificatesTmpImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCountChangePassPinImpl;
import anf.centralizados.core.json.response.impl.ResponseGetCounterInfoImpl;
import anf.centralizados.core.json.response.impl.ResponseGetPersonalInformacionImpl;
import anf.centralizados.core.json.response.impl.ResponseGetPfxImpl;
import anf.centralizados.core.json.response.impl.ResponseGetPfxTmpImpl;
import anf.centralizados.core.json.response.impl.ResponseGetSigStatusImpl;
import anf.centralizados.core.json.response.impl.ResponseGetSigsImpl;
import anf.centralizados.core.json.response.impl.ResponseImpl;
import anf.centralizados.core.json.response.impl.ResponseInfoCertImpl;
import anf.centralizados.core.json.response.impl.ResponseInfoCertificateImpl;
import anf.centralizados.core.json.response.obj.CertRequestInfoObj;
import anf.centralizados.core.json.response.obj.FullCertInfoObj;
import anf.centralizados.core.json.response.obj.InfoCertificateObj;
import anf.centralizados.core.json.response.obj.InfoChangePinObj;
import anf.centralizados.core.json.response.obj.ResponseSig;
import anf.centralizados.core.json.response.obj.impl.CertRequestInfoObjImpl;
import anf.centralizados.core.json.response.obj.impl.FullCertInfoObjImpl;
import anf.centralizados.core.json.response.obj.impl.InfoCertificateObjImpl;
import anf.centralizados.core.json.response.obj.impl.InfoChangePinObjImpl;
import anf.centralizados.core.json.response.obj.impl.ResponseSigImpl;
import com.anf.centralizados.converters.CertConverter;
import com.anf.centralizados.encoders.Encoder;
import com.anf.centralizados.encoders.X509CertificateEncoder;
import com.anf.centralizados.enums.CertChainFormat;
import com.anf.centralizados.enums.CertFormat;
import com.anf.centralizados.enums.EncodeType;
import com.anf.centralizados.error.NullResponseServerException;
import com.anf.centralizados.error.NullTokenException;
import com.anf.centralizados.error.ParseClientSideException;
import com.anf.centralizados.error.ServerErrorException;
import com.anf.oauth.client.AbstractClient;
import com.anf.oauth.json.JSONFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class CentralClientGenericImpl
extends AbstractClient
implements CentralClient {
    public static final Logger log = LogManager.getLogger(CentralClientGenericImpl.class);
    public static EncodeType ENCODE = EncodeType.BASE64;
    protected static final String TOKEN_ERROR = "TOKEN_ERROR";
    protected static final String UNKNOW_ERROR = "UNKNOW_ERROR";
    protected String userId;
    protected String token;
    protected HashSet<String> aliass;
    protected HashMap<String, X509Certificate[]> certificates;
    protected HashMap<String, String> certificatesHash;

    protected CentralClientGenericImpl(String userId, String url) {
        this(userId, url, 60000);
    }

    protected CentralClientGenericImpl(String userId, String url, int timeout) {
        super(url, (long)timeout);
        this.userId = userId;
        JSONFactory.deserializeInterface(CertRequestInfoObj.class, CertRequestInfoObjImpl.class);
        JSONFactory.deserializeInterface(FullCertInfoObj.class, FullCertInfoObjImpl.class);
        JSONFactory.deserializeInterface(InfoCertificateObj.class, InfoCertificateObjImpl.class);
        JSONFactory.deserializeInterface(InfoChangePinObj.class, InfoChangePinObjImpl.class);
        JSONFactory.deserializeInterface(ResponseSig.class, ResponseSigImpl.class);
        this.initFields();
    }

    protected void initFields() {
        this.aliass = new HashSet();
        this.certificates = new HashMap();
        this.certificatesHash = new HashMap();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    protected <R extends SimpleRequest, T extends Response> T execute(String endpoint, R request, Class<T> type) {
        return this.execute(endpoint, request, type, true);
    }

    protected <R extends SimpleRequest, T extends Response> T execute(String endpoint, R request, Class<T> type, boolean requestToken) {
        AtomicReference error = new AtomicReference();
        if (requestToken) {
            this.requestToken(false);
        }
        if (request.userId == null) {
            request.userId = this.userId;
        }
        if (request.pass == null) {
            request.pass = this.token;
        }
        Response resp = this.execute(request, () -> {
            try {
                return (Response)this.handleRequest(endpoint, request, type, null, "POST", null);
            }
            catch (Exception e) {
                log.error("error endpoint " + endpoint, (Throwable)e);
                error.set(e);
                return null;
            }
        });
        if (error.get() != null) {
            throw new NullResponseServerException((Throwable)error.get());
        }
        return (T)resp;
    }

    private <R extends SimpleRequest, T extends Response> T execute(R request, Supplier<T> consumer) {
        Response response = (Response)consumer.get();
        if (response == null) {
            throw new NullResponseServerException();
        }
        if (!response.isSuccess() && response.getErrorId() != null && response.getErrorId().equals(TOKEN_ERROR)) {
            if (this.token != null && this.token.length() == 64) {
                return (T)response;
            }
            this.requestToken(true);
            request.pass = this.token;
            response = (Response)consumer.get();
        }
        return (T)response;
    }

    protected abstract void requestToken(boolean var1);

    @Override
    public MFATypeResponse checkMFA() {
        MFATypeResponse response = this.execute("/centralizados/api/mfa-type", new SimpleRequest(this.userId, null), MFATypeResponse.class);
        if (!response.isSuccess()) {
            throw new CentralClientError(response.getErrorId());
        }
        return response;
    }

    @Override
    public byte[] createQr() {
        StringResponse response = this.execute("/centralizados/api/totp/qrcode", new SimpleRequest(this.userId, null), StringResponse.class);
        if (!response.isSuccess()) {
            throw new CentralClientError(response.getErrorId());
        }
        return Base64.getDecoder().decode(response.getResult());
    }

    @Override
    public boolean verifyTOTP(String code) {
        ResponseBoolean response = (ResponseBoolean)this.execute("/centralizados/api/totp/verify", new VerifyQRCodeRequest(this.userId, null, code), ResponseBooleanImpl.class);
        if (!response.isSuccess()) {
            throw new CentralClientError(response.getErrorId());
        }
        return response.isResult();
    }

    @Override
    public void login() {
        SimpleRequest request = new SimpleRequest(this.userId, null);
        ResponseBoolean response = (ResponseBoolean)this.execute("/centralizados/api/login", request, ResponseBooleanImpl.class);
        if (!response.isSuccess() || !response.isResult()) {
            throw new CentralClientError("No se han podido verificar las credenciales del usuario.");
        }
    }

    @Override
    public Response loadPfx(byte[] data, String pin, String puk) {
        String encoded;
        if (data == null) {
            throw new ParseClientSideException();
        }
        try {
            encoded = Encoder.encode((byte[])data, (EncodeType)ENCODE);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        RequestLoadPfx request = new RequestLoadPfx(this.userId, null, pin, puk, encoded, ENCODE);
        return this.execute("/centralizados/api/load-pfx/", request, ResponseImpl.class);
    }

    @Override
    public ResponseGetPfx getPfx(String pin, String alias) {
        RequestGetPfx request = new RequestGetPfx(this.userId, null, pin, alias, ENCODE);
        ResponseGetPfxTmp tmp = (ResponseGetPfxTmp)this.execute("/centralizados/api/get-pfx/", request, ResponseGetPfxTmpImpl.class);
        ResponseGetPfxImpl res = new ResponseGetPfxImpl();
        res.setSuccess(tmp.isSuccess());
        if (!tmp.isSuccess()) {
            res.setErrorId(tmp.getErrorId());
            return res;
        }
        try {
            res.setResult(Encoder.decode((String)tmp.getResult(), (EncodeType)ENCODE));
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        return res;
    }

    @Override
    public ResponseGetSigs getSigs() {
        SimpleRequest request = new SimpleRequest(this.userId, null);
        return (ResponseGetSigs)this.execute("/centralizados/api/get-sigs/", request, ResponseGetSigsImpl.class);
    }

    @Override
    public ResponseGetSigStatus getSigStatus(String localizador) {
        RequestGetSigStatus request = new RequestGetSigStatus(this.userId, null, localizador);
        return (ResponseGetSigStatus)this.execute("/centralizados/api/get-sig-status/", request, ResponseGetSigStatusImpl.class);
    }

    @Override
    public ResponseActivationResult activateSig(String localizador, String passSig, String pin, String puk) {
        RequestActivateSig request = new RequestActivateSig(this.userId, null, pin, puk, localizador, passSig);
        return (ResponseActivationResult)this.execute("/centralizados/api/activate-sig/", request, ResponseActivationResultImpl.class);
    }

    @Override
    public ResponseDownloadCert downloadCert(String alias) {
        RequestDownloadCert request = new RequestDownloadCert(this.userId, null, alias);
        return (ResponseDownloadCert)this.execute("/centralizados/api/download-cert/", request, ResponseDownloadCertImpl.class);
    }

    @Override
    public Response notifyCertIssued(String localizador) {
        RequestNotifyCertIssued request = new RequestNotifyCertIssued(this.userId, localizador);
        return this.execute("/centralizados/api/notify-cert-issued/", request, ResponseImpl.class);
    }

    @Override
    public ResponseInfoCert getInfoCert(String alias) {
        RequestGetInfoCert request = new RequestGetInfoCert(this.userId, null, alias);
        return (ResponseInfoCert)this.execute("/centralizados/api/get-info-cert/", request, ResponseInfoCertImpl.class);
    }

    @Override
    public ResponseInfoCertificate getInfoCertificates() {
        SimpleRequest request = new SimpleRequest(this.userId, null);
        return (ResponseInfoCertificate)this.execute("/centralizados/api/get-info-certificates/", request, ResponseInfoCertificateImpl.class);
    }

    @Override
    public ResponseGetCertificateChain getCertificateChain(String alias, CertChainFormat certFormat) {
        RequestGetCertificateChain request = new RequestGetCertificateChain(this.userId, null, alias, ENCODE, certFormat);
        ResponseGetCertificateChainTmp tmp = (ResponseGetCertificateChainTmp)this.execute("/centralizados/api/get-certificate-chain/", request, ResponseGetCertificateChainTmpImpl.class);
        ResponseGetCertificateChainImpl res = new ResponseGetCertificateChainImpl();
        res.setSuccess(tmp.isSuccess());
        if (!tmp.isSuccess()) {
            res.setErrorId(tmp.getErrorId());
            return res;
        }
        try {
            if (certFormat == CertChainFormat.PEM) {
                X509Certificate[] certs = new X509Certificate[tmp.getResult().length];
                for (int i = 0; i < certs.length; ++i) {
                    certs[i] = CertConverter.fromPEM((byte[])Encoder.decode((String)tmp.getResult()[i], (EncodeType)ENCODE));
                }
                res.setResult(certs);
            } else if (certFormat == CertChainFormat.DER) {
                X509Certificate[] certs = new X509Certificate[tmp.getResult().length];
                for (int i = 0; i < certs.length; ++i) {
                    certs[i] = CertConverter.fromDER((byte[])Encoder.decode((String)tmp.getResult()[i], (EncodeType)ENCODE));
                }
                res.setResult(certs);
            } else {
                res.setResult(CertConverter.fromPKCS7((byte[])Encoder.decode((String)tmp.getResult()[0], (EncodeType)ENCODE)));
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        return res;
    }

    @Override
    public ResponseGetCertificateChain getCertificateChain(String alias) {
        return this.getCertificateChain(alias, CertChainFormat.PKCS7);
    }

    @Override
    public ResponseGetCertificates getCertificates(CertFormat certFormat) {
        RequestGetCertificates request = new RequestGetCertificates(this.userId, null, ENCODE, certFormat);
        ResponseGetCertificatesTmp tmp = (ResponseGetCertificatesTmp)this.execute("/centralizados/api/get-certificates/", request, ResponseGetCertificatesTmpImpl.class);
        ResponseGetCertificatesImpl res = new ResponseGetCertificatesImpl();
        res.setSuccess(tmp.isSuccess());
        if (!tmp.isSuccess()) {
            res.setErrorId(tmp.getErrorId());
            return res;
        }
        res.setSuccess(tmp.isSuccess());
        res.setResult(new LinkedList());
        try {
            for (int i = 0; i < tmp.getResult().size(); ++i) {
                byte[] data = Encoder.decode((String)((String)tmp.getResult().get(i)), (EncodeType)ENCODE);
                if (certFormat == CertFormat.PEM) {
                    res.getResult().add(CertConverter.fromPEM((byte[])data));
                    continue;
                }
                res.getResult().add(CertConverter.fromDER((byte[])data));
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        return res;
    }

    @Override
    public ResponseGetCertificates getCertificates() {
        return this.getCertificates(CertFormat.DER);
    }

    @Override
    public Response importCertificate(String pin, String puk, String alias, X509Certificate[] certs) {
        String[] res;
        if (certs != null) {
            throw new ParseClientSideException();
        }
        try {
            res = X509CertificateEncoder.encode((X509Certificate[])certs, (EncodeType)ENCODE);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        RequestImportCertificate request = new RequestImportCertificate(this.userId, null, pin, puk, alias, res, ENCODE);
        return this.execute("/centralizados/api/import-certificate/", request, ResponseImpl.class);
    }

    @Override
    public Response removeCertificate(String alias) {
        RequestRemoveCertificate request = new RequestRemoveCertificate(this.userId, null, alias);
        return this.execute("/centralizados/api/remove-certificate/", request, ResponseImpl.class);
    }

    @Override
    public ResponseByteArray generateRequest(String pin, String puk, String alias, X500Name x500Name, BigInteger serial, Date notBefore, Date notAfter, int keySize, ASN1Set attributes, String signAlias, String signAlg) {
        String notAfterL;
        String notBeforeL;
        String serialS;
        String attributesS;
        String x500NameS;
        if (serial == null) {
            throw new ParseClientSideException();
        }
        if (x500Name == null) {
            throw new ParseClientSideException();
        }
        if (attributes == null) {
            throw new ParseClientSideException();
        }
        if (notBefore == null) {
            throw new ParseClientSideException();
        }
        if (notAfter == null) {
            throw new ParseClientSideException();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            x500NameS = Encoder.encode((byte[])x500Name.getEncoded(), (EncodeType)ENCODE);
            attributesS = Encoder.encode((byte[])attributes.getEncoded(), (EncodeType)ENCODE);
            serialS = Encoder.encode((byte[])serial.toByteArray(), (EncodeType)ENCODE);
            notBeforeL = format.format(notBefore);
            notAfterL = format.format(notAfter);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        RequestGenerateRequest request = new RequestGenerateRequest(this.userId, null, pin, puk, alias, signAlias, signAlg, x500NameS, serialS, notBeforeL, notAfterL, keySize, attributesS, ENCODE);
        ResponseByteArrayTmp tmp = (ResponseByteArrayTmp)this.execute("/centralizados/api/generate-request/", request, ResponseByteArrayTmpImpl.class);
        ResponseByteArrayImpl res = new ResponseByteArrayImpl();
        res.setSuccess(tmp.isSuccess());
        if (!tmp.isSuccess()) {
            res.setErrorId(tmp.getErrorId());
            return res;
        }
        try {
            res.setResult(Encoder.decode((String)tmp.getResult(), (EncodeType)ENCODE));
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        return res;
    }

    @Override
    public ResponseGetCounterInfo getCounterInfo(String alias) {
        RequestGetCounterInfo request = new RequestGetCounterInfo(this.userId, null, alias);
        return (ResponseGetCounterInfo)this.execute("/centralizados/api/get-counter-info/", request, ResponseGetCounterInfoImpl.class);
    }

    @Override
    public ResponseBoolean unlockPIN(String alias, char[] puk, char[] newPin, String code) {
        RequestUnlockPin request = new RequestUnlockPin(this.userId, null, alias, new String(puk), new String(newPin), code);
        return (ResponseBoolean)this.execute("/centralizados/api/unlock-pin/", request, ResponseBooleanImpl.class);
    }

    @Override
    public ResponseBoolean changePIN(String alias, char[] old, char[] newPIN, char[] puk, String code) {
        RequestChangePin request = new RequestChangePin(this.userId, null, alias, new String(old), new String(newPIN), new String(puk), code);
        return (ResponseBoolean)this.execute("/centralizados/api/change-pin/", request, ResponseBooleanImpl.class);
    }

    @Override
    public ResponseBoolean changePassword(String newPassword, String code) {
        RequestChangePassword request = new RequestChangePassword(this.userId, null, newPassword, code);
        return (ResponseBoolean)this.execute("/centralizados/api/change-password/", request, ResponseBooleanImpl.class);
    }

    @Override
    public ResponseBoolean initUserPIN(String alias, String certSerialNumber, char[] pukArray, char[] pinArray) {
        ResponseBooleanImpl response = new ResponseBooleanImpl();
        response.setSuccess(true);
        response.setResult(true);
        return response;
    }

    @Override
    public ResponseGetPersonalInformacion getPersonalInformacion() {
        RequestGetPersonalInformation request = new RequestGetPersonalInformation(this.userId, null);
        return (ResponseGetPersonalInformacion)this.execute("/centralizados/api/get-personal-information/", request, ResponseGetPersonalInformacionImpl.class);
    }

    @Override
    public Response updatePersonalInformation(String mail, String phoneNumber, String idioma, String nombre, String apellidos, String alias, String code) {
        RequestUpdatePersonalInformationUser request = new RequestUpdatePersonalInformationUser(this.userId, null, mail, phoneNumber, alias, idioma, nombre, apellidos, code);
        return this.execute("/centralizados/api/update-personal-information/", request, ResponseImpl.class);
    }

    @Override
    public ResponseGetCountChangePassPin getCountChangePassPin() {
        SimpleRequest request = new SimpleRequest(this.userId, null);
        return (ResponseGetCountChangePassPin)this.execute("/centralizados/api/get-count-change-pass-pin/", request, ResponseGetCountChangePassPinImpl.class);
    }

    @Override
    public ResponseBoolean decodeSig(String localizador, String passSig) {
        RequestDecodeSig request = new RequestDecodeSig(this.userId, null, localizador, passSig);
        return (ResponseBoolean)this.execute("/centralizados/api/decode-sig/", request, ResponseBooleanImpl.class);
    }

    @Override
    public ResponseCreateVerificationCode createVerificationCode(String mail, String phoneNumber) {
        RequestCreateVerificationCode request = new RequestCreateVerificationCode(this.userId, null, mail, phoneNumber);
        return (ResponseCreateVerificationCode)this.execute("/centralizados/api/create-verification-code/", request, ResponseCreateVerificationCodeImpl.class);
    }

    @Override
    public ResponseByteArray validateSmsCredential(String code, String alias, String pin, String retoFirma) {
        RequestValidateSmsCredential request = new RequestValidateSmsCredential(this.userId, null, code, alias, pin, retoFirma, ENCODE);
        ResponseByteArrayTmp tmp = (ResponseByteArrayTmp)this.execute("/centralizados/api/validate-sms-credential/", request, ResponseByteArrayTmpImpl.class);
        ResponseByteArrayImpl res = new ResponseByteArrayImpl();
        res.setSuccess(tmp.isSuccess());
        if (!tmp.isSuccess()) {
            res.setErrorId(tmp.getErrorId());
            return res;
        }
        try {
            res.setResult(Encoder.decode((String)tmp.getResult(), (EncodeType)ENCODE));
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        return res;
    }

    @Override
    public ResponseByteArray autenticateCert(String alias, String pin, String retoFirma, String url, String appName, String appVersion, String ip, String computerSerialNumber) {
        RequestAutenticateCert request = new RequestAutenticateCert(this.userId, null, alias, pin, retoFirma, url, appName, appVersion, ip, computerSerialNumber, ENCODE);
        ResponseByteArrayTmp tmp = (ResponseByteArrayTmp)this.execute("/centralizados/api/autenticate-cert/", request, ResponseByteArrayTmpImpl.class);
        ResponseByteArrayImpl res = new ResponseByteArrayImpl();
        res.setSuccess(tmp.isSuccess());
        if (!tmp.isSuccess()) {
            res.setErrorId(tmp.getErrorId());
            return res;
        }
        try {
            res.setResult(Encoder.decode((String)tmp.getResult(), (EncodeType)ENCODE));
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        return res;
    }

    @Override
    public ResponseBoolean validatePin(String alias, String pin) {
        RequestValidatePin request = new RequestValidatePin(this.userId, null, alias, pin);
        return (ResponseBoolean)this.execute("/centralizados/api/validate-pin/", request, ResponseBooleanImpl.class);
    }

    @Override
    public ResponseGetAlias getAliasV2() {
        ArrayList<String> result = new ArrayList<String>();
        for (String alias : this.aliass) {
            result.add(alias);
        }
        return new ResponseGetAliasImpl(result, true, null);
    }

    private byte[] execute(String endpoint, byte[] requestContent, Map<String, String> headers) {
        this.requestToken(false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TreeMap<String, String> headersOut = new TreeMap<String, String>();
        int code = this.executeDirect(endpoint, requestContent, headers, out, headersOut);
        if (code != 200) {
            throw new ServerErrorException(code);
        }
        String error = (String)headersOut.get("errorId");
        if (error != null && error.equals(TOKEN_ERROR)) {
            this.requestToken(true);
            code = this.executeDirect(endpoint, requestContent, headers, out, headersOut);
            if (code != 200) {
                throw new ServerErrorException(code);
            }
            error = (String)headersOut.get("errorId");
        }
        if (error != null) {
            throw new RuntimeException(error);
        }
        byte[] resp = out.toByteArray();
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeDirect(String endpoint, byte[] input, Map<String, String> headersIn, OutputStream output, Map<String, String> headersOut) {
        headersOut.clear();
        HttpURLConnection conn = null;
        headersIn.put("pass", this.token);
        int responseCode = -1;
        try {
            conn = (HttpURLConnection)new URL(this.url + endpoint).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout((int)this.timeout);
            conn.setReadTimeout((int)this.timeout);
            conn.setDoOutput(true);
            for (Map.Entry<String, String> entry : headersIn.entrySet()) {
                conn.addRequestProperty(entry.getKey(), entry.getValue());
            }
            if (input != null) {
                IOUtils.write((byte[])input, (OutputStream)conn.getOutputStream());
            }
            responseCode = conn.getResponseCode();
            for (Map.Entry<String, String> entry : headersOut.entrySet()) {
                entry.setValue(conn.getHeaderField(entry.getKey()));
            }
            if (responseCode == 200 && output != null) {
                IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)output);
            }
        }
        catch (RuntimeException e) {
            log.catching((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return responseCode;
    }

    @Override
    public ResponseGetCertificateChain getCertificateChainV2(String alias) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        headersIn.put("alias", alias);
        ResponseGetCertificateChainImpl response = new ResponseGetCertificateChainImpl();
        try {
            byte[] resp = this.execute("/centralizados/v2/get-certificate-chain/", null, headersIn);
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(resp)));){
                int countCerts = in.readInt();
                X509Certificate[] certs = new X509Certificate[countCerts];
                for (int i = 0; i < countCerts; ++i) {
                    int size = in.readInt();
                    byte[] buffer = new byte[size];
                    in.read(buffer);
                    certs[i] = CertConverter.fromPEM((byte[])buffer);
                }
                response.setResult(certs);
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                throw new ParseClientSideException();
            }
        }
        catch (Exception e1) {
            response.setErrorId(e1.getMessage());
        }
        return response;
    }

    @Override
    public void initCache() {
        this.initCache(null);
    }

    @Override
    public void initCache(String[] aliases) {
        this.getFullCertInfo(aliases);
    }

    private void getFullCertInfo(String ... aliases) {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));){
            if (aliases == null || aliases.length == 0) {
                out.writeInt(0);
            } else {
                out.writeInt(aliases.length);
                for (String alias : aliases) {
                    out.writeUTF(alias);
                }
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        try {
            byte[] resp = this.execute("/centralizados/v2/get-full-cert-info/", stream.toByteArray(), headersIn);
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(resp)));){
                int countAliass = in.readInt();
                for (int i = 0; i < countAliass; ++i) {
                    String alias;
                    alias = in.readUTF();
                    String hash = in.readUTF();
                    int countCerts = in.readInt();
                    X509Certificate[] certs = new X509Certificate[countCerts];
                    for (int j = 0; j < countCerts; ++j) {
                        int size = in.readInt();
                        byte[] buffer = new byte[size];
                        in.read(buffer);
                        certs[j] = CertConverter.fromPEM((byte[])buffer);
                    }
                    this.aliass.add(alias);
                    this.certificates.put(alias, certs);
                    this.certificatesHash.put(alias, hash);
                }
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                throw new ParseClientSideException();
            }
        }
        catch (Exception e1) {
            log.catching((Throwable)e1);
        }
    }

    @Override
    public void updateCache() {
        TreeMap<String, String> headersIn = new TreeMap<String, String>();
        headersIn.put("userId", this.userId);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));){
            if (this.aliass == null || this.aliass.isEmpty()) {
                out.writeInt(0);
            } else {
                out.writeInt(this.aliass.size());
                for (String alias : this.aliass) {
                    out.writeUTF(alias);
                    out.writeUTF(this.certificatesHash.get(alias));
                }
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        try {
            byte[] resp = this.execute("/centralizados/v2/update-full-cert-info/", stream.toByteArray(), headersIn);
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(resp)));){
                int countAliass = in.readInt();
                for (int i = 0; i < countAliass; ++i) {
                    String alias = in.readUTF();
                    String hash = in.readUTF();
                    int countCerts = in.readInt();
                    X509Certificate[] certs = new X509Certificate[countCerts];
                    for (int j = 0; j < countCerts; ++j) {
                        int size = in.readInt();
                        byte[] buffer = new byte[size];
                        in.read(buffer);
                        certs[j] = CertConverter.fromPEM((byte[])buffer);
                    }
                    this.certificates.put(alias, certs);
                    this.certificatesHash.put(alias, hash);
                }
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                throw new ParseClientSideException();
            }
        }
        catch (Exception e1) {
            log.catching((Throwable)e1);
        }
    }

    @Override
    public ResponseGetCertificateChain getCertificateChainV2Cache(String alias) {
        ResponseGetCertificateChainImpl response = new ResponseGetCertificateChainImpl();
        if (!this.aliass.contains(alias)) {
            response.setSuccess(false);
            response.setErrorId("PFX_NOT_EXISTS_ERROR");
            return response;
        }
        response.setResult(this.certificates.get(alias));
        if (response.getResult() == null) {
            throw new NullResponseServerException();
        }
        response.setSuccess(true);
        return response;
    }

    @Override
    public ResponseCloseSession closeSession(String pass) {
        RequestCloseSesison request = new RequestCloseSesison(this.userId);
        if (pass == null) {
            request.token = this.token;
        } else {
            request.pass = pass;
        }
        return this.execute("/centralizados/api/close-session/", request, ResponseCloseSession.class);
    }

    @Override
    public ResponseGetAlias getAlias() {
        SimpleRequest request = new SimpleRequest(this.userId, this.token);
        return (ResponseGetAlias)this.execute("/centralizados/api/get-alias/", request, ResponseGetAliasImpl.class);
    }

    @Override
    public ResponseByteArray signData(String alias, byte[] data, String signAlgorithm, char[] pin) {
        String dataS;
        if (data == null) {
            throw new ParseClientSideException();
        }
        try {
            dataS = Encoder.encode((byte[])data, (EncodeType)ENCODE);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        String pinS = pin != null ? new String(pin) : null;
        RequestSignData request = new RequestSignData(this.userId, this.token, dataS, pinS, alias, signAlgorithm, ENCODE);
        ResponseByteArrayTmp tmp = (ResponseByteArrayTmp)this.execute("/centralizados/api/sign-data/", request, ResponseByteArrayTmpImpl.class);
        ResponseByteArrayImpl res = new ResponseByteArrayImpl();
        res.setSuccess(tmp.isSuccess());
        if (!tmp.isSuccess()) {
            res.setErrorId(tmp.getErrorId());
            return res;
        }
        try {
            res.setResult(Encoder.decode((String)tmp.getResult(), (EncodeType)ENCODE));
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        return res;
    }

    @Override
    public ResponseByteArray decryptData(String alias, byte[] encryptedData, String algorithm, char[] pin) {
        String encryptedDataS;
        if (encryptedData == null) {
            throw new ParseClientSideException();
        }
        try {
            encryptedDataS = Encoder.encode((byte[])encryptedData, (EncodeType)ENCODE);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        String pinS = new String(pin);
        RequestDecryptData request = new RequestDecryptData(this.userId, null, encryptedDataS, pinS, alias, algorithm, ENCODE);
        ResponseByteArrayTmp tmp = (ResponseByteArrayTmp)this.execute("/centralizados/api/decrypt-data/", request, ResponseByteArrayTmpImpl.class);
        ResponseByteArrayImpl res = new ResponseByteArrayImpl();
        res.setSuccess(tmp.isSuccess());
        if (!tmp.isSuccess()) {
            res.setErrorId(tmp.getErrorId());
            return res;
        }
        try {
            res.setResult(Encoder.decode((String)tmp.getResult(), (EncodeType)ENCODE));
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        return res;
    }

    @Override
    public ResponseDownloadCertsZip downloadCertsZip(Boolean chain) {
        RequestDownloadCertsZip request = new RequestDownloadCertsZip(this.userId, this.token, chain);
        return this.execute("/centralizados/api/download-certs-zip/", request, ResponseDownloadCertsZip.class);
    }

    @Override
    public ResponseBoolean validateToken() {
        if (this.token == null) {
            throw new NullTokenException();
        }
        RequestValidateToken request = new RequestValidateToken(this.userId, this.token);
        return (ResponseBoolean)this.execute("/centralizados/api/validate-token/", request, ResponseBooleanImpl.class);
    }

    @Override
    public ResponseGetCertificate getCertificate(String alias, CertFormat certFormat) {
        RequestGetCertificate request = new RequestGetCertificate(this.userId, this.token, alias, ENCODE, certFormat);
        ResponseGetCertificateTmp tmp = (ResponseGetCertificateTmp)this.execute("/centralizados/api/get-certificate/", request, ResponseGetCertificateTmpImpl.class);
        ResponseGetCertificateImpl res = new ResponseGetCertificateImpl();
        res.setSuccess(tmp.isSuccess());
        if (!tmp.isSuccess()) {
            res.setErrorId(tmp.getErrorId());
            return res;
        }
        try {
            byte[] data = Encoder.decode((String)tmp.getResult(), (EncodeType)ENCODE);
            if (certFormat == CertFormat.PEM) {
                res.setResult(CertConverter.fromPEM((byte[])data));
            } else {
                res.setResult(CertConverter.fromDER((byte[])data));
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            throw new ParseClientSideException();
        }
        return res;
    }

    @Override
    public ResponseGetCertificate getCertificate(String alias) {
        return this.getCertificate(alias, CertFormat.DER);
    }

    @Override
    public ResponseGetAllCounterInfo getAllCounterInfo() {
        RequestGetAllCounterInfo request = new RequestGetAllCounterInfo(this.userId, this.token);
        return this.execute("/centralizados/api/get-all-counter-info/", request, ResponseGetAllCounterInfo.class);
    }
}

