/*
 * Decompiled with CFR 0.152.
 */
package anf.centralizados.client.client.impl;

import anf.centralizados.client.client.impl.CentralClientGenericImpl;
import anf.centralizados.core.json.request.RequestSessionCertificate;
import anf.centralizados.core.json.response.ResponseRequestSessionCertificate;
import anf.centralizados.core.json.response.impl.ResponseRequestSessionCertificateImpl;
import com.anf.centralizados.converters.CertificateConverter;
import com.anf.centralizados.enums.CertFormat;
import com.anf.centralizados.error.NullRequestSessionCertificate;
import com.anf.centralizados.error.NullTokenException;
import java.security.cert.X509Certificate;

public class CentralClientCertificateImpl
extends CentralClientGenericImpl {
    private RequestSessionCertificate requestSessionCertificate;

    public CentralClientCertificateImpl(String url, int timeout) {
        super(null, url, timeout);
    }

    public CentralClientCertificateImpl(String url) {
        super(null, url);
    }

    public void buildRequestSessionCertificate(X509Certificate certificate, String url, String appName, String appVersion, String ip, String computerSerialNumber) throws Exception {
        this.buildRequestSessionCertificate(certificate, url, appName, appVersion, ip, computerSerialNumber, CertFormat.PEM);
    }

    public void buildRequestSessionCertificate(X509Certificate certificate, String url, String appName, String appVersion, String ip, String computerSerialNumber, CertFormat certFormat) throws Exception {
        String certData = CertificateConverter.to((X509Certificate)certificate, (String)ENCODE.name(), (String)certFormat.name());
        this.requestSessionCertificate = new RequestSessionCertificate(certData, url, appName, appVersion, ip, computerSerialNumber, ENCODE, certFormat);
        this.token = null;
    }

    @Override
    protected void requestToken(boolean force) {
        if (this.requestSessionCertificate == null) {
            throw new NullRequestSessionCertificate();
        }
        if (this.token != null && !force) {
            return;
        }
        ResponseRequestSessionCertificate response = (ResponseRequestSessionCertificate)this.execute("/centralizados/api/request-session-certificate/", this.requestSessionCertificate, ResponseRequestSessionCertificateImpl.class);
        if (!response.isSuccess() || response.getResult() == null) {
            throw new NullTokenException();
        }
        this.userId = response.getUserId();
        this.token = response.getResult();
    }
}

