/*
 * Decompiled with CFR 0.152.
 */
package com.anf.javafx.wrapper;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;

public class JavaFxFacade {
    private static Stage thePrimaryStage = null;
    private static Stage secondStage;
    private static Object lock;

    public static void setThePrimaryStage(Stage thePrimaryStage) {
        JavaFxFacade.thePrimaryStage = thePrimaryStage;
        secondStage = new Stage();
        secondStage.initOwner((Window)thePrimaryStage);
        secondStage.initStyle(StageStyle.UTILITY);
        secondStage.setOpacity(0.0);
        secondStage.setAlwaysOnTop(true);
        secondStage.initModality(Modality.WINDOW_MODAL);
        secondStage.setWidth(1.0);
        secondStage.setHeight(1.0);
        secondStage.sizeToScene();
        secondStage.centerOnScreen();
        secondStage.setMaximized(false);
        JavaFxFacade.notifyStage();
    }

    private static void ensureOneThread() {
        if (thePrimaryStage == null) {
            JavaFxFacade.startJavaFxThread();
            JavaFxFacade.waitForStage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForStage() {
        while (thePrimaryStage == null) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait();
                }
                System.out.println("stage created");
            }
            catch (InterruptedException ex) {
                LogManager.getLogger((String)JavaFxFacade.class.getName()).error((Object)ex);
            }
        }
    }

    private static void startJavaFxThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JavaFxContainer.launch(JavaFxContainer.class, (String[])new String[0]);
                }
                catch (Throwable ex) {
                    LogManager.getLogger((String)JavaFxFacade.class.getName()).catching(ex);
                }
            }
        }).start();
    }

    public static <T> T execute(Function<Stage, T> f) {
        return JavaFxFacade.execute(true, f);
    }

    public static <T> T execute(final boolean show, final Function<Stage, T> f) {
        JavaFxFacade.ensureOneThread();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (show) {
                    secondStage.show();
                }
                try {
                    result.set(f.apply(secondStage));
                }
                finally {
                    if (show) {
                        secondStage.close();
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    latch.countDown();
                }
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return (T)result.get();
    }

    public static void exit() {
        Platform.exit();
    }

    public static Stage getPrimaryStage() {
        return thePrimaryStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyStage() {
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    static {
        lock = new Object();
        Platform.setImplicitExit((boolean)false);
    }

    public static class JavaFxContainer
    extends Application {
        public void start(Stage primaryStage) throws Exception {
            JavaFxFacade.setThePrimaryStage(primaryStage);
        }
    }
}

