/*
 * Decompiled with CFR 0.152.
 */
package com.anf.utils;

import com.anf.cryptotoken.log.Logger;
import com.anf.utils.OSUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;

public class SerialUtils {
    private static final Logger log = Logger.getLogger(SerialUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getComputerSerialNumber() throws RuntimeException {
        String sn = null;
        if (OSUtils.isWindows()) {
            try {
                InputStream is = null;
                Process process = null;
                File wmic = new File(System.getenv("systemroot"), "system32" + File.separator + "wbem" + File.separator + "wmic.exe");
                if (!wmic.exists()) {
                    throw new FileNotFoundException(wmic + " no existe");
                }
                process = Runtime.getRuntime().exec(new String[]{wmic.getCanonicalPath(), "bios", "get", "serialnumber"});
                process.getOutputStream().close();
                is = process.getInputStream();
                try (Scanner sc = new Scanner(is);){
                    while (sc.hasNext()) {
                        String next = sc.next();
                        if (!"SerialNumber".toLowerCase().equals(next.toLowerCase()) || !sc.hasNext()) continue;
                        sn = sc.next().trim();
                        break;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Throwable e) {
                log.error("error obteniendo el numero de serie de la maquina", e);
            }
        }
        if (sn == null) {
            sn = "0000000000";
        }
        return sn;
    }

    public static String getSerialNumber(String unit) throws IOException {
        if (unit == null) {
            return null;
        }
        String serial = SerialUtils.getUSBSerialNumber(unit);
        if (serial != null) {
            return SerialUtils.buildPassword(serial);
        }
        return null;
    }

    public static String getUSBSerialNumber(String unit) throws IOException {
        String s = null;
        s = SerialUtils.getSerialFileStore(unit);
        if (s == null) {
            s = SerialUtils.getSerialCommandWindows(unit);
        }
        if (s != null) {
            return s;
        }
        throw new IOException("ERR_DEVICE_SERIAL_NUMBER");
    }

    public static String getSerialFileStore(String unit) {
        log.info((Object)("getSerialFileStore(" + unit + ")"));
        if (unit == null) {
            return null;
        }
        if (unit.endsWith(File.separator)) {
            unit = unit.replace(File.separator, "");
        }
        for (FileStore store : FileSystems.getDefault().getFileStores()) {
            try {
                if (store.hashCode() != (unit + File.separator).hashCode() || !store.toString().contains(unit)) continue;
                String serial = store.getAttribute("volume:vsn").toString();
                try {
                    Integer valueOf = Integer.valueOf(serial, 10);
                    Object hexString = Integer.toHexString(valueOf);
                    if (((String)(hexString = ((String)hexString).toUpperCase())).length() != 8) continue;
                    hexString = ((String)hexString).substring(0, 4) + "-" + ((String)hexString).substring(4, 8);
                    return hexString;
                }
                catch (NumberFormatException e) {
                    log.error(e);
                }
            }
            catch (IOException | NumberFormatException e) {
                log.error(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSerialCommandWindows(String unit) throws IOException {
        int indexOf;
        log.info((Object)("getSerialCommandWindows(" + unit + ")"));
        String s = null;
        PrintStream out = System.out;
        int t = 3;
        while (t-- > 0) {
            PrintStream printStream = out;
            synchronized (printStream) {
                ByteArrayOutputStream out1 = new ByteArrayOutputStream();
                System.setOut(new PrintStream(out1, true));
                String command = "cmd /c dir " + unit + ":";
                log.info((Object)("obteniendo numero de serie de USB con comando: " + command));
                Process process = Runtime.getRuntime().exec(command);
                try {
                    log.info((Object)"esperando por ejecucion de numero de serie de USB");
                    process.waitFor(1L, TimeUnit.MINUTES);
                    log.info((Object)"termino de ejecutar numero de serie de USB");
                    BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
                    System.setOut(out);
                    int n = 0;
                    while ((s = stdInput.readLine()) != null) {
                        if (n == 1 && s.contains("-")) {
                            t = 0;
                            break;
                        }
                        ++n;
                    }
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
        }
        if (s != null && (indexOf = s.indexOf("-")) != -1) {
            String serial = s.substring(indexOf - 4);
            return serial;
        }
        return s;
    }

    public static String buildPassword(String serial) {
        String substring;
        String replace;
        int indexOf = serial.indexOf("-");
        if (indexOf != -1 && (replace = (substring = serial.substring(indexOf - 4).trim()).replace("-", "")).length() == 8) {
            try {
                long parseLong = Long.parseLong(replace, 16);
                String hexSerial = Long.toString(parseLong);
                return hexSerial;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

