/*
 * Decompiled with CFR 0.152.
 */
package com.anf.utils;

import com.anf.cryptotoken.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ProxyUtils {
    private static final Logger log = Logger.getLogger(ProxyUtils.class);
    static String authUser = "";
    static String authPassword = "";
    static String proxyFile = "proxy.properties";

    public static void setProxyFromFile() {
        File proxy = null;
        try {
            proxy = new File(new File(proxyFile).getCanonicalPath());
            log.info((Object)("try to set proxy from file: " + proxy.getCanonicalPath()));
        }
        catch (IOException e1) {
            log.error(e1);
        }
        if (proxy != null && proxy.exists()) {
            Properties props = new Properties();
            try {
                try (FileInputStream in = new FileInputStream(proxy);){
                    props.load(in);
                }
                Set<Map.Entry<Object, Object>> set = props.entrySet();
                for (Map.Entry<Object, Object> e : set) {
                    log.info((Object)("proxy set: " + e.getKey().toString() + "=" + e.getValue().toString()));
                    System.setProperty(e.getKey().toString(), e.getValue().toString());
                }
                String user = props.getProperty("http.proxyUser");
                String pass = props.getProperty("http.proxyPassword");
                if (user != null) {
                    authUser = user;
                }
                if (pass != null) {
                    authPassword = pass;
                }
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(authUser, authPassword.toCharArray());
                    }
                });
            }
            catch (Throwable e) {
                log.error(e);
            }
        }
    }
}

