/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.tsp.TSPAlgorithms;

public class TSPAlgoritmos {
    public static final String SHA1 = "SHA-1";
    public static final String SHA2 = "SHA-2";
    public static final String SHA224 = "SHA-224";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public static final String MD5 = "MD5";
    private static HashMap<String, String> algoritmosVSoids = null;

    public static Set<String> getPermitidos() {
        HashSet<String> permitidos = new HashSet<String>(Arrays.asList(TSPAlgoritmos.getValoresPermitidos()));
        return permitidos;
    }

    public static String getAlgName(String oid) {
        if (TSPAlgorithms.SHA1.equals((Object)oid)) {
            return SHA1;
        }
        if (TSPAlgorithms.SHA256.getId().equals(oid)) {
            return SHA256;
        }
        if (TSPAlgorithms.SHA256.getId().equals(oid)) {
            return SHA2;
        }
        if (TSPAlgorithms.SHA224.getId().equals(oid)) {
            return SHA224;
        }
        if (TSPAlgorithms.SHA384.getId().equals(oid)) {
            return SHA384;
        }
        if (TSPAlgorithms.SHA512.getId().equals(oid)) {
            return SHA512;
        }
        return oid;
    }

    public static ASN1ObjectIdentifier getOID(String algoritmo) {
        HashSet<String> permitidos = new HashSet<String>(Arrays.asList(TSPAlgoritmos.getValoresPermitidos()));
        if (permitidos.contains(algoritmo)) {
            if (SHA1.equals(algoritmo)) {
                return TSPAlgorithms.SHA1;
            }
            if (SHA2.equals(algoritmo)) {
                return TSPAlgorithms.SHA256;
            }
            if (SHA224.equals(algoritmo)) {
                return TSPAlgorithms.SHA224;
            }
            if (SHA256.equals(algoritmo)) {
                return TSPAlgorithms.SHA256;
            }
            if (SHA384.equals(algoritmo)) {
                return TSPAlgorithms.SHA384;
            }
            if (SHA512.equals(algoritmo)) {
                return TSPAlgorithms.SHA512;
            }
        }
        return null;
    }

    public static MessageDigest getDigest(String oid) {
        String algName = algoritmosVSoids.get(oid);
        if (algName == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algName);
            return md;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String[] getValoresPermitidos() {
        String[] valoresPermitidos = new String[]{SHA1, SHA2, SHA224, SHA256, SHA384, SHA512};
        return valoresPermitidos;
    }

    static {
        algoritmosVSoids = new HashMap();
        algoritmosVSoids.put(TSPAlgorithms.SHA1.getId(), SHA1);
        algoritmosVSoids.put(TSPAlgorithms.SHA224.getId(), SHA224);
        algoritmosVSoids.put(TSPAlgorithms.SHA256.getId(), SHA256);
        algoritmosVSoids.put(TSPAlgorithms.SHA384.getId(), SHA384);
        algoritmosVSoids.put(TSPAlgorithms.SHA512.getId(), SHA512);
        algoritmosVSoids.put(TSPAlgorithms.MD5.getId(), MD5);
    }
}

