/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.oid;

import com.anf.cert.utils.CertType;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.cryptotoken.oid.QcStatementsInfo;
import com.anf.cryptotoken.oid.QcpPolicy;
import com.anf.cryptotoken.qc.QcStatementsOID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.RFC3739QCObjectIdentifiers;

public class QcStatementsUtils {
    private static boolean qcNaturalRepresentanteSoftware = false;
    private static boolean qcNaturalRepresentanteQscd = true;
    public static final Predicate<QCStatement> isQcSSCD = qc -> qc.getStatementId().equals((ASN1Primitive)QcStatementsOID.qcp_public_with_sscd) || qc.getStatementId().equals((ASN1Primitive)ETSIQCObjectIdentifiers.id_etsi_qcs_QcSSCD);
    public static final Predicate<QCStatement> isQcType = qc -> qc.getStatementId().equals((ASN1Primitive)QcStatementsOID.id_etsi_qcs_QcType) && QcStatementsUtils.validateQcType(qc);
    public static final Predicate<QCStatement> isQcCompliance = qc -> qc.getStatementId().equals((ASN1Primitive)ETSIQCObjectIdentifiers.id_etsi_qcs_QcCompliance);

    public static List<QCStatement> listQcStatements(ASN1Sequence qcStatementsValue) {
        return QcStatementsUtils.listQcStatements(qcStatementsValue, null);
    }

    public static List<QCStatement> listQcStatements(ASN1Sequence qcStatementsValue, Predicate<QCStatement> checkFunction) {
        ArrayList<QCStatement> qcs = new ArrayList<QCStatement>();
        Enumeration objects = qcStatementsValue.getObjects();
        while (objects.hasMoreElements()) {
            ASN1Object obj = (ASN1Object)objects.nextElement();
            if (obj instanceof ASN1Sequence) {
                obj = QCStatement.getInstance((Object)obj);
            }
            if (!(obj instanceof QCStatement)) continue;
            QCStatement qc = (QCStatement)obj;
            if (checkFunction != null && !checkFunction.test(qc)) continue;
            qcs.add(qc);
        }
        return qcs;
    }

    public static List<QCStatement> transformQcStatements(ASN1Sequence qcStatementsValue, UnaryOperator<QCStatement> transformFunction) {
        ArrayList<QCStatement> qcs = new ArrayList<QCStatement>();
        Enumeration objects = qcStatementsValue.getObjects();
        while (objects.hasMoreElements()) {
            ASN1Object obj = (ASN1Object)objects.nextElement();
            if (obj instanceof ASN1Sequence) {
                obj = QCStatement.getInstance((Object)obj);
            }
            if (!(obj instanceof QCStatement)) continue;
            QCStatement qc = (QCStatement)obj;
            if (transformFunction != null) {
                qc = (QCStatement)transformFunction.apply(qc);
            }
            qcs.add(qc);
        }
        return qcs;
    }

    public static ASN1Sequence getQcStatementsValue(ProfilePolicy profile, boolean hsm, QcStatementsInfo qcInfo, boolean isCentralized) {
        List<QCStatement> qcs = QcStatementsUtils.getQcStatements(profile, hsm, qcInfo, isCentralized);
        return QcStatementsUtils.getQcStatementValue(qcs);
    }

    public static ASN1Sequence getQcStatementValue(List<QCStatement> qcs) {
        if (!qcs.isEmpty()) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            qcs.forEach(arg_0 -> ((ASN1EncodableVector)vec).add(arg_0));
            return new DERSequence(vec);
        }
        return null;
    }

    public static List<QCStatement> getQcStatements(ProfilePolicy profile, boolean hsm, QcStatementsInfo qcInfo, boolean isCentralized) {
        QCStatement qc;
        CertType certType;
        ArrayList<QCStatement> qcs = new ArrayList<QCStatement>();
        ASN1ObjectIdentifier pkixQcSyntax = RFC3739QCObjectIdentifiers.id_qcs_pkixQCSyntax_v2;
        QCStatement syntax = new QCStatement(pkixQcSyntax);
        qcs.add(syntax);
        if ((isCentralized || hsm) && (ProfilePolicy.isQSCD(profile) || ProfilePolicy.isCentral(profile))) {
            QCStatement qc2 = new QCStatement(ETSIQCObjectIdentifiers.id_etsi_qcs_QcSSCD);
            qcs.add(qc2);
        }
        if ((certType = profile.getCertType()) == CertType.signature) {
            qc = QcStatementsUtils.buildQcTypeStruct(QcStatementsOID.id_etsi_qct_esign);
            qcs.add(qc);
        } else if (certType == CertType.seal) {
            qc = QcStatementsUtils.buildQcTypeStruct(QcStatementsOID.id_etsi_qct_eseal);
            qcs.add(qc);
        }
        if (isCentralized || qcInfo.isQcCompliance() && (certType == CertType.signature || certType == CertType.seal)) {
            qc = new QCStatement(ETSIQCObjectIdentifiers.id_etsi_qcs_QcCompliance);
            qcs.add(qc);
        }
        if (qcInfo.getQcRetentionPeriod() != null) {
            ASN1Integer years = new ASN1Integer((long)Integer.parseInt(qcInfo.getQcRetentionPeriod()));
            QCStatement qc3 = new QCStatement(ETSIQCObjectIdentifiers.id_etsi_qcs_RetentionPeriod, (ASN1Encodable)years);
            qcs.add(qc3);
        }
        if (certType == CertType.signature) {
            if (qcInfo.getMoney() != null && qcInfo.getQcBase() != null && qcInfo.getQcExp() != null) {
                int limit = Integer.parseInt(qcInfo.getQcBase());
                int exponent = Integer.parseInt(qcInfo.getQcExp());
                MonetaryValue value = new MonetaryValue(new Iso4217CurrencyCode(qcInfo.getMoney()), limit, exponent);
                QCStatement qc4 = new QCStatement(ETSIQCObjectIdentifiers.id_etsi_qcs_LimiteValue, (ASN1Encodable)value);
                qcs.add(qc4);
            }
            qc = new QCStatement(QcStatementsOID.semanticsIdNatural);
            qcs.add(qc);
        } else if (ProfilePolicy.isQSealAP(profile)) {
            qc = QcStatementsUtils.getQcPDS();
            qcs.add(qc);
        }
        if (ProfilePolicy.isQSealPSD2(profile) && qcInfo.getPsd2Info() != null) {
            QCStatement psd2 = QcStatementsUtils.getQcPSD2(qcInfo.getPsd2Info().getRolesMap(), qcInfo.getPsd2Info().getNameNCA(), qcInfo.getPsd2Info().getCountryCode(), qcInfo.getPsd2Info().getIdNCA());
            qcs.add(psd2);
        }
        Collections.sort(qcs, (o1, o2) -> o1.getStatementId().getId().compareTo(o2.getStatementId().getId()));
        return qcs;
    }

    private static QCStatement buildQcTypeStruct(ASN1ObjectIdentifier id_etsi_qct) {
        DERSequence seq = new DERSequence((ASN1Encodable)id_etsi_qct);
        return new QCStatement(QcStatementsOID.id_etsi_qcs_QcType, (ASN1Encodable)seq);
    }

    public static ASN1Sequence fixQcStatements(ASN1Sequence qcStatementsValue) {
        List<QCStatement> listQcStatements = QcStatementsUtils.transformQcStatements(qcStatementsValue, qc -> {
            String id = qc.getStatementId().getId();
            if (id.equals(QcStatementsOID.id_etsi_qct_eseal.getId()) || id.equals(QcStatementsOID.id_etsi_qct_web.getId()) || id.equals(QcStatementsOID.id_etsi_qct_esign.getId())) {
                return QcStatementsUtils.buildQcTypeStruct(new ASN1ObjectIdentifier(id));
            }
            if (id.equals(QcStatementsOID.QcPDS.getId())) {
                return QcStatementsUtils.getQcPDS();
            }
            return qc;
        });
        return QcStatementsUtils.getQcStatementValue(listQcStatements);
    }

    private static boolean validateQcType(QCStatement qc) {
        ASN1ObjectIdentifier oid;
        ASN1Sequence seq;
        Object object = qc.getStatementInfo();
        return object instanceof ASN1Sequence && (seq = (ASN1Sequence)object).getObjects().hasMoreElements() && Collections.list(seq.getObjects()).size() == 1 && (object = seq.getObjects().nextElement()) instanceof ASN1ObjectIdentifier && ((oid = (ASN1ObjectIdentifier)object).getId().equals(QcStatementsOID.id_etsi_qct_eseal.getId()) || oid.getId().equals(QcStatementsOID.id_etsi_qct_web.getId()) || oid.getId().equals(QcStatementsOID.id_etsi_qct_esign.getId()));
    }

    public static ASN1ObjectIdentifier checkQcCompliance(X509Certificate cert) throws IOException {
        return QcStatementsUtils.checkQc(cert, isQcCompliance);
    }

    public static ASN1ObjectIdentifier checkQcSSCD(X509Certificate cert) throws IOException {
        return QcStatementsUtils.checkQcOid(cert, QcStatementsUtils::checkQcSSCD);
    }

    public static ASN1ObjectIdentifier checkQcType(X509Certificate cert) throws IOException {
        return QcStatementsUtils.checkQcOid(cert, seq -> {
            ASN1ObjectIdentifier qcTypeOid;
            ASN1Encodable patt8762$temp;
            ASN1Sequence qcTypeSequence;
            List<QCStatement> listQcStatements = QcStatementsUtils.listQcStatements(seq, isQcType);
            if (listQcStatements.isEmpty()) {
                return null;
            }
            QCStatement qcType = listQcStatements.get(0);
            ASN1Encodable statementInfo = qcType.getStatementInfo();
            if (statementInfo instanceof ASN1Sequence && (qcTypeSequence = (ASN1Sequence)statementInfo).size() > 0 && (patt8762$temp = qcTypeSequence.getObjectAt(0)) instanceof ASN1ObjectIdentifier && (qcTypeOid = (ASN1ObjectIdentifier)patt8762$temp).getId().startsWith(qcType.getStatementId().getId())) {
                return qcTypeOid;
            }
            return qcType.getStatementId();
        });
    }

    public static ASN1ObjectIdentifier checkQc(X509Certificate cert, Predicate<QCStatement> qcMatcher) throws IOException {
        return QcStatementsUtils.checkQcOid(cert, seq -> QcStatementsUtils.qcMatch(seq, qcMatcher));
    }

    public static ASN1ObjectIdentifier checkQcOid(X509Certificate cert, Function<ASN1Sequence, ASN1ObjectIdentifier> oidMatcher) throws IOException {
        byte[] extensionValue = cert.getExtensionValue(Extension.qCStatements.getId());
        if (extensionValue != null) {
            try (ASN1InputStream extOSInput = new ASN1InputStream((InputStream)new ByteArrayInputStream(extensionValue));){
                ASN1Primitive derObj = extOSInput.readObject();
                ASN1OctetString derOctet = ASN1OctetString.getInstance((Object)derObj);
                try (ASN1InputStream extValueInput = new ASN1InputStream((InputStream)new ByteArrayInputStream(derOctet.getOctets()));){
                    ASN1Primitive obj = extValueInput.readObject();
                    if (obj instanceof ASN1Sequence) {
                        ASN1Sequence seq = (ASN1Sequence)obj;
                        ASN1ObjectIdentifier aSN1ObjectIdentifier = oidMatcher.apply(seq);
                        return aSN1ObjectIdentifier;
                    }
                }
            }
        }
        return null;
    }

    public static ASN1ObjectIdentifier qcMatch(ASN1Sequence qcStatementsValue, Predicate<QCStatement> qcMatcher) {
        List<QCStatement> listQcStatements = QcStatementsUtils.listQcStatements(qcStatementsValue, qcMatcher::test);
        return !listQcStatements.isEmpty() ? listQcStatements.get(0).getStatementId() : null;
    }

    public static ASN1ObjectIdentifier checkQcSSCD(ASN1Sequence qcStatementsValue) {
        if (QcStatementsUtils.qcMatch(qcStatementsValue, isQcType) != null) {
            return QcStatementsUtils.qcMatch(qcStatementsValue, isQcSSCD);
        }
        return null;
    }

    private static QCStatement getQcPDS() {
        DERSequence pdsLocation = new DERSequence(new ASN1Encodable[]{new DERIA5String("https://anf.es/en/"), new DERPrintableString("en")});
        DERSequence pdsLocations = new DERSequence(new ASN1Encodable[]{pdsLocation});
        return new QCStatement(QcStatementsOID.QcPDS, (ASN1Encodable)pdsLocations);
    }

    public static QCStatement getQcPSD2(Map<String, String> rolesMap, String nameNCA, String contryCodeNCA, String idNCA) {
        ArrayList rolesPSPList = new ArrayList();
        rolesMap.forEach((id, name) -> {
            ASN1ObjectIdentifier oid = null;
            switch (id) {
                case "AS": {
                    oid = QcStatementsOID.id_etsi_psd2_role_psp_as;
                    break;
                }
                case "AI": {
                    oid = QcStatementsOID.id_etsi_psd2_role_psp_ai;
                    break;
                }
                case "IC": {
                    oid = QcStatementsOID.id_etsi_psd2_role_psp_ic;
                    break;
                }
                case "PI": {
                    oid = QcStatementsOID.id_etsi_psd2_role_psp_pi;
                    break;
                }
            }
            if (oid != null) {
                rolesPSPList.add(new DERSequence(new ASN1Encodable[]{oid, new DERUTF8String(name)}));
            }
        });
        ASN1Encodable[] rolesPSPSequenceContent = new ASN1Encodable[rolesPSPList.size()];
        rolesPSPList.toArray(rolesPSPSequenceContent);
        DERSequence rolesPSP = new DERSequence(rolesPSPSequenceContent);
        DERSequence sequencePSD2QcType = new DERSequence(new ASN1Encodable[]{rolesPSP, new DERUTF8String(nameNCA), new DERUTF8String(contryCodeNCA + "-" + idNCA)});
        return new QCStatement(QcStatementsOID.id_etsi_psd2_qcStatement, (ASN1Encodable)sequencePSD2QcType);
    }

    public static String getQcpOid(String policyOID) {
        QcpPolicy qcpPolicy = new QcpPolicy(policyOID, qcNaturalRepresentanteSoftware, qcNaturalRepresentanteQscd);
        return qcpPolicy.getQcpOId();
    }

    public static void setQcNaturalRepresentanteSoftware(boolean qcNaturalRepresentanteSoftware) {
        QcStatementsUtils.qcNaturalRepresentanteSoftware = qcNaturalRepresentanteSoftware;
    }

    public static void setQcNaturalRepresentanteQscd(boolean qcNaturalRepresentanteQscd) {
        QcStatementsUtils.qcNaturalRepresentanteQscd = qcNaturalRepresentanteQscd;
    }
}

