/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.oid;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class ExtendedKeyUsagesUtils {
    public static final String ANY_EXT_KEY_USAGE_LITERAL = "cualquiera";
    public static final String SERVER_AUTH_EXT_KEY_USAGE_LITERAL = "autentificacion servidor";
    public static final String CLIENT_EXT_KEY_USAGE_LITERAL = "autentificacion cliente";
    public static final String CODE_SIGN_EXT_KEY_USAGE_LITERAL = "firma codigo";
    public static final String EMAIL_EXT_KEY_USAGE_LITERAL = "cifrado correo";
    public static final String IPSEC_END_EXT_KEY_USAGE_LITERAL = "ipsec sistema final";
    public static final String IPSEC_TUNNEL_EXT_KEY_USAGE_LITERAL = "ipsec tunel";
    public static final String IPSEC_USER_EXT_KEY_USAGE_LITERAL = "ipsec usuario";
    public static final String TIME_STAMP_EXT_KEY_USAGE_LITERAL = "sello tiempo";
    public static final String OCSP_EXT_KEY_USAGE_LITERAL = "ocsp";
    public static final int ANY_EXT_KEY_USAGE = 0;
    public static final int SERVER_AUTH_EXT_KEY_USAGE = 1;
    public static final int CLIENT_EXT_KEY_USAGE = 2;
    public static final int CODE_SIGN_EXT_KEY_USAGE = 3;
    public static final int EMAIL_EXT_KEY_USAGE = 4;
    public static final int IPSEC_END_EXT_KEY_USAGE = 5;
    public static final int IPSEC_TUNNEL_EXT_KEY_USAGE = 6;
    public static final int IPSEC_USER_EXT_KEY_USAGE = 7;
    public static final int TIME_STAMP_EXT_KEY_USAGE = 8;
    public static final int OCSP_EXT_KEY_USAGE = 9;

    public static Set<Integer> getExtendedKeyUsagesValues(Set<String> literalValues) {
        HashSet<Integer> intValues = new HashSet<Integer>();
        for (String value : literalValues) {
            int currentIntValue = 0;
            if (ANY_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 0;
            }
            if (SERVER_AUTH_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 1;
            }
            if (CLIENT_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 2;
            }
            if (CODE_SIGN_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 3;
            }
            if (EMAIL_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 4;
            }
            if (IPSEC_END_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 5;
            }
            if (IPSEC_TUNNEL_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 6;
            }
            if (IPSEC_USER_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 7;
            }
            if (TIME_STAMP_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 8;
            }
            if (OCSP_EXT_KEY_USAGE_LITERAL.equals(value)) {
                currentIntValue = 9;
            }
            intValues.add(currentIntValue);
        }
        return intValues;
    }

    public static KeyPurposeId[] getExtendedKeyUsageIDs(Set<Integer> profileUsages) {
        Vector<KeyPurposeId> purposes = new Vector<KeyPurposeId>(profileUsages.size());
        for (Integer usage : profileUsages) {
            KeyPurposeId purposeID = null;
            switch (usage) {
                case 0: {
                    purposeID = KeyPurposeId.anyExtendedKeyUsage;
                    break;
                }
                case 1: {
                    purposeID = KeyPurposeId.id_kp_serverAuth;
                    break;
                }
                case 2: {
                    purposeID = KeyPurposeId.id_kp_clientAuth;
                    break;
                }
                case 3: {
                    purposeID = KeyPurposeId.id_kp_codeSigning;
                    break;
                }
                case 4: {
                    purposeID = KeyPurposeId.id_kp_emailProtection;
                    break;
                }
                case 5: {
                    purposeID = KeyPurposeId.id_kp_ipsecEndSystem;
                    break;
                }
                case 6: {
                    purposeID = KeyPurposeId.id_kp_ipsecTunnel;
                    break;
                }
                case 7: {
                    purposeID = KeyPurposeId.id_kp_ipsecUser;
                    break;
                }
                case 8: {
                    purposeID = KeyPurposeId.id_kp_timeStamping;
                    break;
                }
                case 9: {
                    purposeID = KeyPurposeId.id_kp_OCSPSigning;
                }
            }
            purposes.add(purposeID);
        }
        KeyPurposeId[] array = new KeyPurposeId[purposes.size()];
        return purposes.toArray(array);
    }
}

