/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.log;

import com.anf.cryptotoken.api.thread.AsyncExecutor;
import com.anf.utils.OSUtils;
import com.anf.utils.VersionControl;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;

public final class Logger {
    private org.apache.logging.log4j.Logger log;
    private static Consumer<Throwable> errorHandler;

    public static void setErrorHandler(Consumer<Throwable> errorHandler) {
        Logger.errorHandler = errorHandler;
    }

    public <T> Logger(Class<T> clazz) {
        this.log = LogManager.getLogger(clazz);
    }

    public static <T> Logger getLogger(Class<T> clazz) {
        return new Logger(clazz);
    }

    public void info(Object ... message) {
        StringBuffer sb = this.buildString(message);
        this.log.info(sb.toString());
    }

    private StringBuffer buildString(Object ... message) {
        StringBuffer sb = new StringBuffer();
        if (message != null && message.length > 0) {
            for (Object msg : message) {
                sb.append(msg.toString());
            }
        }
        return sb;
    }

    public void info(Object message) {
        this.log.info(message);
    }

    public void debug(Object message) {
        if (message instanceof Throwable) {
            this.log.debug("DEBUG-INFO", (Throwable)message);
        } else {
            this.log.debug(message);
        }
    }

    public void info(Object message, Throwable e) {
        this.log.info(message, e);
    }

    public void error(Object message) {
        if (message instanceof Throwable) {
            this.log.error("error at " + new Date() + ":", (Throwable)message);
            this.handleError("error at " + new Date() + ":", (Throwable)message);
        } else {
            this.log.error(message, null);
            this.handleError(message, null);
        }
    }

    public void error(Object message, Throwable e) {
        this.log.error(message, e);
        this.handleError(message, e);
    }

    public void warn(Object ... message) {
        this.log.warn(this.buildString(message).toString());
    }

    public void warn(Object message) {
        this.log.warn(message);
    }

    public void warn(Object message, Throwable e) {
        this.log.warn(message, e);
    }

    private void handleError(Object message, Throwable throwable) {
        if (errorHandler != null) {
            AsyncExecutor.executorService.execute(() -> errorHandler.accept(throwable));
        }
    }

    public org.apache.logging.log4j.Logger getLog() {
        return this.log;
    }

    private static void initializeLoggerProperties() {
        String minLevel = null;
        String consoleLevel = null;
        Properties anfctProperties = Logger.loadAnfctConfigProperties();
        boolean logsEnabled = false;
        boolean consoleOutput = false;
        try {
            logsEnabled = Boolean.valueOf(anfctProperties.getProperty("log-enabled", "true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            consoleOutput = Boolean.valueOf(anfctProperties.getProperty("console-output", "true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        minLevel = anfctProperties.getProperty("anfct-log-level-file", anfctProperties.getProperty("min-level", "INFO"));
        consoleLevel = anfctProperties.getProperty("anfct-log-level-console");
        if (consoleLevel == null || consoleLevel.isEmpty()) {
            consoleLevel = consoleOutput ? "INFO" : "OFF";
        }
        if (minLevel == null || minLevel.isEmpty()) {
            minLevel = "OFF";
        }
        if (!logsEnabled) {
            minLevel = "OFF";
            consoleLevel = "OFF";
        }
        System.setProperty("anfct-log-level-console", consoleLevel);
        System.setProperty("anfct-log-level-file", minLevel);
        System.setProperty("anfct-filename", "ANFCT");
        System.setProperty("anfct-version", VersionControl.version);
    }

    private static Properties loadAnfctConfigProperties() {
        Properties config = new Properties();
        File file = null;
        try {
            String name = "ANFCT-LOG.cfg";
            file = new File(new File(System.getenv("PUBLIC"), "ANF"), name);
            if (!file.exists() && !(file = new File(System.getProperty("user.home"), name)).exists()) {
                file = new File(name);
            }
            if (file.exists()) {
                try (FileInputStream in = new FileInputStream(file);){
                    config.load(in);
                }
            }
            OSUtils.getPID();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return config;
    }

    static {
        Logger.initializeLoggerProperties();
    }
}

