/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.io;

import com.anf.cryptotoken.io.FilePercentListener;
import com.anf.cryptotoken.log.Logger;
import com.anf.utils.ProgressListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;

public class Files {
    private static final Logger log = Logger.getLogger(Files.class);
    public static File temp = new File(System.getProperty("java.io.tmpdir"));
    public static final File root = new File(".");
    private static File anf = new File(temp, "ANFCT");
    public static File logDir = root;

    public static void setTempFile(File tmp, String name) throws FileNotFoundException {
        temp = tmp;
        anf = new File(temp, name);
        anf.mkdirs();
    }

    public static File anf() {
        if (!anf.exists()) {
            anf.mkdirs();
        }
        return anf;
    }

    public static File getRootFile(File f) throws IOException {
        return new File(f.getCanonicalPath().substring(0, 3));
    }

    public static long getSize(File appDir) {
        long size = 0L;
        if (appDir.isDirectory()) {
            File[] files = appDir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    size += Files.getSize(files[i]);
                }
            }
        } else if (appDir.isFile()) {
            size = appDir.length();
        }
        return size;
    }

    public static void deleteFolder(File src) {
        File[] files = src.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Files.deleteFolder(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        src.delete();
    }

    public static void copyFolder(File src, File dest, FilePercentListener listener) throws IOException {
        File[] files = src.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File srcf = files[i];
            if (srcf.isDirectory() && srcf.list() != null) {
                File dir = new File(dest, srcf.getName());
                dir.mkdirs();
                CopyFileVisitor visitor = new CopyFileVisitor(dir.toPath(), listener);
                java.nio.file.Files.walkFileTree(srcf.toPath(), visitor);
                continue;
            }
            if (!srcf.isFile() || !srcf.canRead()) continue;
            try {
                FileUtils.copyFile((File)srcf, (File)new File(dest, srcf.getName()));
                if (listener == null) continue;
                try {
                    listener.updatePercent(srcf.length());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (Throwable e) {
                log.error(e.getMessage());
            }
        }
    }

    static {
        if (!anf.exists()) {
            anf.mkdirs();
        }
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if (!temp.exists()) {
            temp.mkdirs();
        }
        if (!root.exists()) {
            root.mkdirs();
        }
        if (!temp.canWrite() || !anf.canWrite()) {
            try {
                Files.setTempFile(new File(System.getProperty("user.home"), "temp"), "ANFCT");
            }
            catch (FileNotFoundException e) {
                try {
                    Files.setTempFile(new File(System.getProperty("user.dir"), "temp"), "ANFCT");
                }
                catch (FileNotFoundException e1) {
                    log.error(e1);
                }
            }
        }
    }

    static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;
        ProgressListener listener;

        public CopyFileVisitor(Path targetPath, FilePercentListener listener) {
            this.targetPath = targetPath;
            this.listener = listener;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            try {
                if (this.sourcePath == null) {
                    this.sourcePath = dir;
                } else {
                    java.nio.file.Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
                }
            }
            catch (Throwable e) {
                log.error(e);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            try {
                try {
                    java.nio.file.Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), new CopyOption[0]);
                    if (this.listener != null) {
                        this.listener.updatePercent(file.toFile().length());
                    }
                }
                catch (FileAlreadyExistsException e) {
                    log.warn((Object)(e.getFile() + " ya existe en el directorio"));
                    log.info((Object)("eliminando archivo " + e.getFile()));
                    new File(e.getFile()).delete();
                    log.info((Object)("copiando archivo " + file + " a " + this.targetPath.resolve(this.sourcePath.relativize(file))));
                    java.nio.file.Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), new CopyOption[0]);
                    if (this.listener != null) {
                        this.listener.updatePercent(file.toFile().length());
                    }
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

