/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.io;

import com.anf.cryptotoken.io.Files;
import com.anf.utils.ProgressListener;
import java.io.File;

public class FilePercentListener
implements ProgressListener {
    private long total;
    private long done;
    private File src;

    public FilePercentListener() {
    }

    public FilePercentListener(File src) {
        this.src = src;
        this.total = Files.getSize(src);
    }

    public void setSrc(File src) throws InterruptedException {
        this.src = src;
        this.done = 0L;
        this.updatePercent(this.done);
        this.total = Files.getSize(src);
    }

    @Override
    public Object updatePercent(Object obj) throws InterruptedException {
        if (obj instanceof Long) {
            Long l = (Long)obj;
            this.done += l.longValue();
        } else if (obj instanceof Integer) {
            Integer l = (Integer)obj;
            this.done += l.longValue();
        }
        return this.done;
    }

    @Override
    public Object update() {
        return null;
    }

    @Override
    public Object updatePercent(int p, Object obj) throws InterruptedException {
        return null;
    }

    @Override
    public boolean completed() {
        return this.done < this.total;
    }

    @Override
    public boolean canceled() {
        return false;
    }

    public double getPercent() {
        return this.total > 0L ? (double)this.done / (double)this.total : 0.0;
    }
}

