/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.timestamp;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESTimestampParameters;
import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESASiCContentBuilder;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.timestamp.ASiCWithCAdESTimestampDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.util.List;

public class ASiCWithCAdESTimestampService {
    private final TSPSource tspSource;
    private final ASiCWithCAdESFilenameFactory asicFilenameFactory;

    public ASiCWithCAdESTimestampService(TSPSource tspSource) {
        this(tspSource, new DefaultASiCWithCAdESFilenameFactory());
    }

    public ASiCWithCAdESTimestampService(TSPSource tspSource, ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        this.tspSource = tspSource;
        this.asicFilenameFactory = asicFilenameFactory;
    }

    public DSSDocument timestamp(List<DSSDocument> documents, ASiCWithCAdESTimestampParameters parameters) {
        ASiCContent asicContent = new ASiCWithCAdESASiCContentBuilder().build(documents, parameters.aSiC().getContainerType());
        asicContent = this.timestamp(asicContent, parameters);
        return ZipUtils.getInstance().createZipArchive(asicContent, parameters.getZipCreationDate());
    }

    public ASiCContent timestamp(ASiCContent asicContent, ASiCWithCAdESTimestampParameters parameters) {
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESTimestampDataToSignHelperBuilder(this.asicFilenameFactory).build(asicContent, parameters);
        DSSDocument toBeTimestamped = dataToSignHelper.getToBeSigned();
        if (ASiCContainerType.ASiC_E == parameters.aSiC().getContainerType()) {
            asicContent.getManifestDocuments().add(toBeTimestamped);
        }
        DigestAlgorithm digestAlgorithm = parameters.getDigestAlgorithm();
        TimestampBinary timestampBinary = this.tspSource.getTimeStampResponse(digestAlgorithm, toBeTimestamped.getDigestValue(digestAlgorithm));
        InMemoryDocument timestampToken = new InMemoryDocument(DSSASN1Utils.getDEREncoded((TimestampBinary)timestampBinary), this.asicFilenameFactory.getTimestampFilename(asicContent), (MimeType)MimeTypeEnum.TST);
        ASiCUtils.addOrReplaceDocument((List)asicContent.getTimestampDocuments(), (DSSDocument)timestampToken);
        return asicContent;
    }
}

