/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESTimestampParameters;
import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.extract.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESASiCContentBuilder;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESCounterSignatureHelper;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESLevelBaselineLTA;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESSignatureDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESSignatureExtension;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.timestamp.ASiCWithCAdESTimestampService;
import eu.europa.esig.dss.asic.cades.validation.ASiCContainerWithCAdESAnalyzer;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESUtils;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureBuilder;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableCounterSignatureParameters;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCWithCAdESService
extends AbstractASiCSignatureService<ASiCWithCAdESSignatureParameters, ASiCWithCAdESTimestampParameters, CAdESCounterSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithCAdESService.class);
    private ASiCWithCAdESFilenameFactory asicFilenameFactory = new DefaultASiCWithCAdESFilenameFactory();

    public ASiCWithCAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with CAdES created");
    }

    public void setAsicFilenameFactory(ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        Objects.requireNonNull(asicFilenameFactory, "ASiCWithCAdESFilenameFactory cannot be null!");
        this.asicFilenameFactory = asicFilenameFactory;
    }

    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocuments);
        ASiCContent asicContent = new ASiCWithCAdESASiCContentBuilder().build(toSignDocuments, parameters.aSiC().getContainerType());
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESSignatureDataToSignHelperBuilder(this.asicFilenameFactory).build(asicContent, parameters);
        DSSDocument toBeSigned = dataToSignHelper.getToBeSigned();
        return this.getCAdESService().getContentTimestamp(toBeSigned, (CAdESSignatureParameters)parameters);
    }

    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSignaturePossible(toSignDocuments);
        this.assertSigningCertificateValid((AbstractSignatureParameters)parameters);
        ASiCContent asicContent = new ASiCWithCAdESASiCContentBuilder().build(toSignDocuments, parameters.aSiC().getContainerType());
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESSignatureDataToSignHelperBuilder(this.asicFilenameFactory).build(asicContent, parameters);
        this.assertSignaturePossible(asicContent.getTimestampDocuments(), parameters.aSiC());
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters, dataToSignHelper);
        DSSDocument toBeSigned = dataToSignHelper.getToBeSigned();
        return this.getCAdESService().getDataToSign(toBeSigned, cadesParameters);
    }

    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocuments, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertSignaturePossible(toSignDocuments);
        this.assertSigningCertificateValid((AbstractSignatureParameters)parameters);
        ASiCContent asicContent = new ASiCWithCAdESASiCContentBuilder().build(toSignDocuments, parameters.aSiC().getContainerType());
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESSignatureDataToSignHelperBuilder(this.asicFilenameFactory).build(asicContent, parameters);
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertSignaturePossible(asicContent.getTimestampDocuments(), asicParameters);
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters, dataToSignHelper);
        boolean addASiCArchiveManifest = this.isAddASiCEArchiveManifest(parameters.getSignatureLevel(), parameters.aSiC().getContainerType());
        if (addASiCArchiveManifest) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        }
        DSSDocument toBeSigned = dataToSignHelper.getToBeSigned();
        if (ASiCContainerType.ASiC_E == asicParameters.getContainerType()) {
            asicContent.getManifestDocuments().add(toBeSigned);
        }
        DSSDocument signature = this.getCAdESService().signDocument(toBeSigned, cadesParameters, signatureValue);
        signature.setName(this.asicFilenameFactory.getSignatureFilename(asicContent));
        ASiCUtils.addOrReplaceDocument((List)asicContent.getSignatureDocuments(), (DSSDocument)signature);
        if (addASiCArchiveManifest) {
            ASiCWithCAdESLevelBaselineLTA extensionProfile = new ASiCWithCAdESLevelBaselineLTA(this.certificateVerifier, this.tspSource, this.asicFilenameFactory);
            asicContent = ((ASiCWithCAdESSignatureExtension)extensionProfile).extend(asicContent, parameters);
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
        }
        DSSDocument asicContainer = this.buildASiCContainer(asicContent, parameters.getZipCreationDate());
        asicContainer.setName(this.getFinalDocumentName(asicContainer, SigningOperation.SIGN, parameters.getSignatureLevel(), asicContainer.getMimeType()));
        parameters.reinit();
        return asicContainer;
    }

    public DSSDocument timestamp(List<DSSDocument> toTimestampDocuments, ASiCWithCAdESTimestampParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        if (Utils.isCollectionEmpty(toTimestampDocuments)) {
            throw new IllegalArgumentException("List of documents to be timestamped cannot be empty!");
        }
        ASiCContent asicContent = new ASiCWithCAdESASiCContentBuilder().build(toTimestampDocuments, parameters.aSiC().getContainerType());
        ASiCParameters asicParameters = parameters.aSiC();
        List signatureDocuments = asicContent.getSignatureDocuments();
        this.assertTimestampPossible(signatureDocuments, asicParameters);
        List signatures = asicContent.getSignatureDocuments();
        List timestampDocuments = asicContent.getTimestampDocuments();
        if ((Utils.isCollectionNotEmpty((Collection)signatures) || Utils.isCollectionNotEmpty((Collection)timestampDocuments)) && this.isLtaExtensionPossible(asicContent)) {
            DSSDocument toTimestampDocument = toTimestampDocuments.get(0);
            ASiCWithCAdESLevelBaselineLTA extensionProfile = new ASiCWithCAdESLevelBaselineLTA(this.certificateVerifier, this.tspSource, this.asicFilenameFactory);
            asicContent = extensionProfile.extend(asicContent, parameters.getDigestAlgorithm());
            DSSDocument extensionResult = this.buildASiCContainer(asicContent, parameters.getZipCreationDate());
            extensionResult.setName(this.getFinalDocumentName(toTimestampDocument, SigningOperation.TIMESTAMP, null, toTimestampDocument.getMimeType()));
            return extensionResult;
        }
        ASiCWithCAdESTimestampService timestampService = new ASiCWithCAdESTimestampService(this.tspSource, this.asicFilenameFactory);
        asicContent = timestampService.timestamp(asicContent, parameters);
        DSSDocument asicContainer = this.buildASiCContainer(asicContent, parameters.getZipCreationDate());
        asicContainer.setName(this.getFinalDocumentName(asicContainer, SigningOperation.TIMESTAMP, null, asicContainer.getMimeType()));
        return asicContainer;
    }

    private boolean isLtaExtensionPossible(ASiCContent asicContent) {
        ASiCContainerWithCAdESAnalyzer validator = new ASiCContainerWithCAdESAnalyzer(asicContent);
        validator.setCertificateVerifier(this.certificateVerifier);
        List signatures = validator.getSignatures();
        for (AdvancedSignature signature : signatures) {
            if (!Utils.isCollectionEmpty((Collection)signature.getSignatureTimestamps())) continue;
            LOG.warn("Extension with an ArchiveManifest is not possible, because a signature with Id '{}' does not have a signature-time-stamp attribute!Add a simple timestamp on signed data.", (Object)signature.getId());
            return false;
        }
        return true;
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithCAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        this.assertExtensionSupported(toExtendDocument);
        ASiCContent asicContent = this.extractCurrentArchive(toExtendDocument);
        this.assertValidSignaturesToExtendFound(asicContent.getSignatureDocuments());
        ASiCContainerType containerType = asicContent.getContainerType();
        if (containerType == null) {
            throw new IllegalInputException("The container type of the provided document is not supported or cannot be extracted!");
        }
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        boolean addASiCEArchiveManifest = this.isAddASiCEArchiveManifest(parameters.getSignatureLevel(), containerType);
        ASiCWithCAdESSignatureExtension extensionProfile = this.getExtensionProfile(parameters.getSignatureLevel(), containerType);
        if (addASiCEArchiveManifest) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        }
        asicContent = extensionProfile.extend(asicContent, parameters);
        if (addASiCEArchiveManifest) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
        }
        DSSDocument extensionResult = this.buildASiCContainer(asicContent, parameters.getZipCreationDate());
        extensionResult.setName(this.getFinalDocumentName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel(), toExtendDocument.getMimeType()));
        return extensionResult;
    }

    private void assertExtensionSupported(DSSDocument toExtendDocument) {
        if (!ASiCUtils.isZip((DSSDocument)toExtendDocument)) {
            throw new IllegalInputException("Unsupported file type");
        }
    }

    private void assertValidSignaturesToExtendFound(List<DSSDocument> signatureDocuments) {
        if (Utils.isCollectionEmpty(signatureDocuments)) {
            throw new IllegalInputException("No supported signature documents found! Unable to extend the container.");
        }
    }

    protected DefaultASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithCAdESContainerExtractor(archive);
    }

    protected CAdESService getCAdESService() {
        CAdESService cadesService = new CAdESService(this.certificateVerifier);
        cadesService.setTspSource(this.tspSource);
        return cadesService;
    }

    protected CAdESSignatureParameters getCAdESParameters(ASiCWithCAdESSignatureParameters parameters) {
        parameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        parameters.getContext().setDetachedContents(null);
        return parameters;
    }

    protected CAdESSignatureParameters getCAdESParameters(ASiCWithCAdESSignatureParameters parameters, GetDataToSignASiCWithCAdESHelper dataToSignHelper) {
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        cadesParameters.getContext().setDetachedContents(dataToSignHelper.getDetachedContents());
        cadesParameters.setParallelSignature(Utils.isCollectionNotEmpty(dataToSignHelper.getDetachedContents()));
        return cadesParameters;
    }

    private boolean isAddASiCEArchiveManifest(SignatureLevel signatureLevel, ASiCContainerType containerType) {
        return SignatureLevel.CAdES_BASELINE_LTA == signatureLevel && ASiCContainerType.ASiC_E == containerType;
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument asicContainer, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(asicContainer, "The asicContainer cannot be null");
        Objects.requireNonNull(signaturePolicyStore, "The signaturePolicyStore cannot be null");
        ASiCContent asicContent = this.extractCurrentArchive(asicContainer);
        this.assertAddSignaturePolicyStorePossible(asicContent);
        CAdESService cadesService = this.getCAdESService();
        List signatureDocuments = asicContent.getSignatureDocuments();
        for (DSSDocument signature : new ArrayList(signatureDocuments)) {
            DSSDocument signatureWithPolicyStore = cadesService.addSignaturePolicyStore(signature, signaturePolicyStore);
            signatureWithPolicyStore.setName(signature.getName());
            ASiCUtils.addOrReplaceDocument((List)signatureDocuments, (DSSDocument)signatureWithPolicyStore);
        }
        DSSDocument resultArchive = this.buildASiCContainer(asicContent, null);
        resultArchive.setName(this.getFinalArchiveName(asicContainer, SigningOperation.ADD_SIG_POLICY_STORE, asicContainer.getMimeType()));
        return resultArchive;
    }

    protected void assertAddSignaturePolicyStorePossible(ASiCContent asicContent) {
        super.assertAddSignaturePolicyStorePossible(asicContent);
        List signatureDocuments = asicContent.getSignatureDocuments();
        for (DSSDocument signature : signatureDocuments) {
            if (!ASiCWithCAdESUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), signature.getName())) continue;
            throw new IllegalInputException(String.format("Not possible to add a signature policy store! Reason : a signature with a filename '%s' is covered by another manifest.", signature.getName()));
        }
    }

    public ToBeSigned getDataToBeCounterSigned(DSSDocument asicContainer, CAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSigningCertificateValid((AbstractSignatureParameters)parameters);
        this.assertCounterSignatureParametersValid(parameters);
        ASiCWithCAdESCounterSignatureHelper counterSignatureHelper = new ASiCWithCAdESCounterSignatureHelper(asicContainer);
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        CAdESCounterSignatureBuilder counterSignatureBuilder = new CAdESCounterSignatureBuilder(this.certificateVerifier);
        counterSignatureBuilder.setManifestFile(counterSignatureHelper.getManifestFile(signatureDocument.getName()));
        SignerInformation signerInfoToCounterSign = counterSignatureBuilder.getSignerInformationToBeCounterSigned(signatureDocument, parameters);
        CAdESService cadesService = this.getCAdESService();
        return cadesService.getDataToBeCounterSigned(signerInfoToCounterSign, (CAdESSignatureParameters)parameters);
    }

    public DSSDocument counterSignSignature(DSSDocument asicContainer, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        this.assertCounterSignatureParametersValid(parameters);
        ASiCWithCAdESCounterSignatureHelper counterSignatureHelper = new ASiCWithCAdESCounterSignatureHelper(asicContainer);
        ASiCContent asicContent = counterSignatureHelper.getAsicContent();
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        CMSSignedData originalCMSSignedData = DSSUtils.toCMSSignedData((DSSDocument)signatureDocument);
        CAdESCounterSignatureBuilder counterSignatureBuilder = new CAdESCounterSignatureBuilder(this.certificateVerifier);
        counterSignatureBuilder.setManifestFile(counterSignatureHelper.getManifestFile(signatureDocument.getName()));
        CMSSignedDocument counterSignedSignature = counterSignatureBuilder.addCounterSignature(originalCMSSignedData, parameters, signatureValue);
        counterSignedSignature.setName(signatureDocument.getName());
        ASiCUtils.addOrReplaceDocument((List)asicContent.getSignatureDocuments(), (DSSDocument)counterSignedSignature);
        DSSDocument resultArchive = this.buildASiCContainer(asicContent, parameters.bLevel().getSigningDate());
        resultArchive.setName(this.getFinalDocumentName(asicContainer, SigningOperation.COUNTER_SIGN, parameters.getSignatureLevel(), asicContainer.getMimeType()));
        return resultArchive;
    }

    protected ASiCWithCAdESSignatureExtension getExtensionProfile(SignatureLevel signatureLevel, ASiCContainerType containerType) {
        Objects.requireNonNull(signatureLevel, "SignatureLevel must be defined!");
        switch (signatureLevel) {
            case CAdES_BASELINE_T: 
            case CAdES_BASELINE_LT: {
                return new ASiCWithCAdESSignatureExtension(this.certificateVerifier, this.tspSource);
            }
            case CAdES_BASELINE_LTA: {
                return ASiCContainerType.ASiC_E.equals((Object)containerType) ? new ASiCWithCAdESLevelBaselineLTA(this.certificateVerifier, this.tspSource, this.asicFilenameFactory) : new ASiCWithCAdESSignatureExtension(this.certificateVerifier, this.tspSource);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", signatureLevel));
    }

    protected void assertCounterSignatureParametersValid(CAdESCounterSignatureParameters parameters) {
        super.assertCounterSignatureParametersValid((SerializableCounterSignatureParameters)parameters);
        if (!SignatureLevel.CAdES_BASELINE_B.equals((Object)parameters.getSignatureLevel())) {
            throw new UnsupportedOperationException(String.format("A counter signature with a level '%s' is not supported! Please, use CAdES-BASELINE-B", parameters.getSignatureLevel()));
        }
    }

    private void assertSignaturePossible(List<DSSDocument> timestampDocuments, ASiCParameters asicParameters) {
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters) && Utils.isCollectionNotEmpty(timestampDocuments)) {
            throw new IllegalInputException("Unable to sign an ASiC-S with CAdES container containing time assertion files!");
        }
    }

    private void assertTimestampPossible(List<DSSDocument> signatureDocuments, ASiCParameters asicParameters) {
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters) && Utils.isCollectionNotEmpty(signatureDocuments)) {
            throw new IllegalInputException("Unable to timestamp an ASiC-S with CAdES container containing signature files! Use extendDocument(...) method for signature extension.");
        }
    }
}

