/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.merge;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.extract.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCContainerWithCAdESAnalyzerFactory;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.extract.DefaultASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.merge.DefaultContainerMerger;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.Store;

public abstract class AbstractASiCWithCAdESContainerMerger
extends DefaultContainerMerger {
    protected ASiCWithCAdESFilenameFactory asicFilenameFactory = new DefaultASiCWithCAdESFilenameFactory();

    AbstractASiCWithCAdESContainerMerger() {
    }

    protected AbstractASiCWithCAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    protected AbstractASiCWithCAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    public void setAsicFilenameFactory(ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        Objects.requireNonNull(asicFilenameFactory, "ASiCWithCAdESFilenameFactory cannot be null!");
        this.asicFilenameFactory = asicFilenameFactory;
    }

    protected boolean isSupported(DSSDocument container) {
        return new ASiCContainerWithCAdESAnalyzerFactory().isSupported(container);
    }

    protected boolean isSupported(ASiCContent asicContent) {
        return new ASiCContainerWithCAdESAnalyzerFactory().isSupported(asicContent);
    }

    protected DefaultASiCContainerExtractor getContainerExtractor(DSSDocument container) {
        return new ASiCWithCAdESContainerExtractor(container);
    }

    protected DSSDocument mergeCmsSignatures(List<DSSDocument> signatureDocuments) {
        try {
            List<CMSSignedData> cmsSignedDataList = this.getCMSSignedDataList(signatureDocuments);
            CMSSignedData originalCMSSignedData = cmsSignedDataList.iterator().next();
            SignerInformationStore signerInformationStore = this.getSignerInformationStore(cmsSignedDataList);
            CMSSignedData mergedCmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)originalCMSSignedData, (SignerInformationStore)signerInformationStore);
            JcaCertStore certificatesStore = this.getCertificatesStore(cmsSignedDataList);
            Store<Encodable> certAttributeStore = this.getCertAttributeStore(cmsSignedDataList);
            Store<Encodable> crlStore = this.getCRLStore(cmsSignedDataList);
            mergedCmsSignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)mergedCmsSignedData, (Store)certificatesStore, certAttributeStore, crlStore);
            List<AlgorithmIdentifier> digestAlgorithms = this.getDigestAlgorithms(cmsSignedDataList);
            for (AlgorithmIdentifier algorithmIdentifier : digestAlgorithms) {
                mergedCmsSignedData = CMSUtils.addDigestAlgorithm((CMSSignedData)mergedCmsSignedData, (AlgorithmIdentifier)algorithmIdentifier);
            }
            return new CMSSignedDocument(mergedCmsSignedData, this.getSignatureDocumentName(signatureDocuments));
        }
        catch (CertificateEncodingException | CMSException e) {
            throw new DSSException(String.format("Unable to merge ASiC-S with CAdES container. Reason : %s", e.getMessage()));
        }
    }

    private List<CMSSignedData> getCMSSignedDataList(List<DSSDocument> signatureDocuments) {
        ArrayList<CMSSignedData> signedDataList = new ArrayList<CMSSignedData>();
        for (DSSDocument signatureDocument : signatureDocuments) {
            CMSDocumentAnalyzer documentValidator = new CMSDocumentAnalyzer(signatureDocument);
            signedDataList.add(documentValidator.getCmsSignedData());
        }
        return signedDataList;
    }

    private SignerInformationStore getSignerInformationStore(List<CMSSignedData> cmsSignedDataList) {
        ArrayList signerInformations = new ArrayList();
        for (CMSSignedData signedData : cmsSignedDataList) {
            signerInformations.addAll(signedData.getSignerInfos().getSigners());
        }
        return new SignerInformationStore(signerInformations);
    }

    private JcaCertStore getCertificatesStore(List<CMSSignedData> cmsSignedDataList) throws CertificateEncodingException {
        ArrayList<X509CertificateHolder> result = new ArrayList<X509CertificateHolder>();
        for (CMSSignedData signedData : cmsSignedDataList) {
            Collection certificateHolders = signedData.getCertificates().getMatches(null);
            for (X509CertificateHolder x509CertificateHolder : certificateHolders) {
                if (result.contains(x509CertificateHolder)) continue;
                result.add(x509CertificateHolder);
            }
        }
        return new JcaCertStore(result);
    }

    private Store<Encodable> getCertAttributeStore(List<CMSSignedData> cmsSignedDataList) {
        ArrayList<X509AttributeCertificateHolder> result = new ArrayList<X509AttributeCertificateHolder>();
        for (CMSSignedData signedData : cmsSignedDataList) {
            Collection attributeCertificateHolders = signedData.getAttributeCertificates().getMatches(null);
            for (X509AttributeCertificateHolder x509AttributeCertificateHolder : attributeCertificateHolders) {
                if (result.contains(x509AttributeCertificateHolder)) continue;
                result.add(x509AttributeCertificateHolder);
            }
        }
        return new CollectionStore(result);
    }

    private Store<Encodable> getCRLStore(List<CMSSignedData> cmsSignedDataList) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (CMSSignedData signedData : cmsSignedDataList) {
            Collection crlHolders = signedData.getCRLs().getMatches(null);
            for (X509CRLHolder x509CRLHolder : crlHolders) {
                if (result.contains(x509CRLHolder)) continue;
                result.add(x509CRLHolder);
            }
        }
        result.addAll(this.getOtherRevocationInfoStore(cmsSignedDataList, OCSPObjectIdentifiers.id_pkix_ocsp_basic));
        result.addAll(this.getOtherRevocationInfoStore(cmsSignedDataList, CMSObjectIdentifiers.id_ri_ocsp_response));
        return new CollectionStore(result);
    }

    private List<Encodable> getOtherRevocationInfoStore(List<CMSSignedData> cmsSignedDataList, ASN1ObjectIdentifier objectIdentifier) {
        ArrayList<Encodable> result = new ArrayList<Encodable>();
        for (CMSSignedData signedData : cmsSignedDataList) {
            Collection basicOcsps = signedData.getOtherRevocationInfo(objectIdentifier).getMatches(null);
            for (ASN1Encodable ocsp : basicOcsps) {
                OtherRevocationInfoFormat otherRevocationInfo = new OtherRevocationInfoFormat(objectIdentifier, ocsp);
                if (result.contains(otherRevocationInfo)) continue;
                result.add((Encodable)otherRevocationInfo);
            }
        }
        return result;
    }

    private List<AlgorithmIdentifier> getDigestAlgorithms(List<CMSSignedData> cmsSignedDataList) {
        ArrayList<AlgorithmIdentifier> result = new ArrayList<AlgorithmIdentifier>();
        for (CMSSignedData cmsSignedData : cmsSignedDataList) {
            result.addAll(cmsSignedData.getDigestAlgorithmIDs());
        }
        return result;
    }

    private String getSignatureDocumentName(List<DSSDocument> signatureDocuments) {
        if (Utils.isCollectionNotEmpty(signatureDocuments)) {
            return signatureDocuments.get(0).getName();
        }
        throw new IllegalInputException("At least one signature file shall be provided for merging!");
    }

    protected List<DSSDocument> getAllSignatureDocuments(ASiCContent ... asicContents) {
        ArrayList<DSSDocument> signatureDocuments = new ArrayList<DSSDocument>();
        for (ASiCContent asicContent : asicContents) {
            signatureDocuments.addAll(asicContent.getSignatureDocuments());
        }
        return signatureDocuments;
    }
}

