/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades;

import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.Objects;

public class SimpleASiCWithCAdESFilenameFactory
extends DefaultASiCWithCAdESFilenameFactory {
    private static final long serialVersionUID = 8401330459709076998L;
    private String signatureFilename;
    private String timestampFilename;
    private String evidenceRecordFilename;
    private String manifestFilename;
    private String archiveManifestFilename;
    private String evidenceRecordManifestFilename;
    private String dataPackageFilename;

    @Override
    public String getSignatureFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty((String)this.signatureFilename)) {
            return this.getValidSignatureFilename(this.signatureFilename, asicContent);
        }
        return super.getSignatureFilename(asicContent);
    }

    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    @Override
    public String getTimestampFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty((String)this.timestampFilename)) {
            return this.getValidTimestampFilename(this.timestampFilename, asicContent);
        }
        return super.getTimestampFilename(asicContent);
    }

    public void setTimestampFilename(String timestampFilename) {
        this.timestampFilename = timestampFilename;
    }

    @Override
    public String getEvidenceRecordFilename(ASiCContent asicContent, EvidenceRecordTypeEnum evidenceRecordType) {
        Objects.requireNonNull(evidenceRecordType, "EvidenceRecordType shall be defined!");
        if (Utils.isStringNotEmpty((String)this.evidenceRecordFilename)) {
            return this.getValidEvidenceRecordFilename(this.evidenceRecordFilename, asicContent, evidenceRecordType);
        }
        return super.getEvidenceRecordFilename(asicContent, evidenceRecordType);
    }

    public void setEvidenceRecordFilename(String evidenceRecordFilename) {
        this.evidenceRecordFilename = evidenceRecordFilename;
    }

    @Override
    public String getManifestFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty((String)this.manifestFilename)) {
            return this.getValidManifestFilename(this.manifestFilename, asicContent);
        }
        return super.getManifestFilename(asicContent);
    }

    public void setManifestFilename(String manifestFilename) {
        this.manifestFilename = manifestFilename;
    }

    @Override
    public String getArchiveManifestFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty((String)this.archiveManifestFilename)) {
            return this.getValidArchiveManifestFilename(this.archiveManifestFilename, asicContent);
        }
        return super.getArchiveManifestFilename(asicContent);
    }

    public void setArchiveManifestFilename(String archiveManifestFilename) {
        this.archiveManifestFilename = archiveManifestFilename;
    }

    @Override
    public String getDataPackageFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty((String)this.dataPackageFilename)) {
            return this.getValidDataPackageFilename(this.dataPackageFilename, asicContent);
        }
        return super.getDataPackageFilename(asicContent);
    }

    public void setDataPackageFilename(String dataPackageFilename) {
        this.dataPackageFilename = dataPackageFilename;
    }

    @Override
    public String getEvidenceRecordManifestFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty((String)this.evidenceRecordManifestFilename)) {
            return this.getValidEvidenceRecordManifestFilename(this.evidenceRecordManifestFilename, asicContent);
        }
        return super.getEvidenceRecordManifestFilename(asicContent);
    }

    public void setEvidenceRecordManifestFilename(String evidenceRecordManifestFilename) {
        this.evidenceRecordManifestFilename = evidenceRecordManifestFilename;
    }

    protected String getValidSignatureFilename(String signatureFilename, ASiCContent asicContent) {
        signatureFilename = this.getWithMetaInfFolder(signatureFilename);
        this.assertFilenameValid(signatureFilename, asicContent.getSignatureDocuments());
        if (ASiCUtils.isASiCSContainer((ASiCContent)asicContent) && !"META-INF/signature.p7s".equals(signatureFilename)) {
            throw new IllegalArgumentException(String.format("A signature file within ASiC-S with CAdES container shall have name '%s'!", "META-INF/signature.p7s"));
        }
        if (!signatureFilename.startsWith("META-INF/signature") || !signatureFilename.endsWith(".p7s")) {
            throw new IllegalArgumentException(String.format("A signature file within ASiC-E with CAdES container shall match the template '%s'!", "META-INF/signature*.p7s"));
        }
        return signatureFilename;
    }

    protected String getValidTimestampFilename(String timestampFilename, ASiCContent asicContent) {
        timestampFilename = this.getWithMetaInfFolder(timestampFilename);
        this.assertFilenameValid(timestampFilename, asicContent.getTimestampDocuments());
        if (ASiCUtils.isASiCSContainer((ASiCContent)asicContent) && Utils.isCollectionEmpty((Collection)asicContent.getTimestampDocuments()) && !"META-INF/timestamp.tst".equals(timestampFilename)) {
            throw new IllegalArgumentException(String.format("A timestamp file within ASiC-S with CAdES container shall have name '%s'!", "META-INF/timestamp.tst"));
        }
        if (!timestampFilename.startsWith("META-INF/timestamp") || !timestampFilename.endsWith(".tst")) {
            throw new IllegalArgumentException(String.format("A timestamp file within ASiC-E with CAdES container shall match the template '%s'!", "META-INF/timestamp*.tst"));
        }
        return timestampFilename;
    }

    protected String getValidEvidenceRecordFilename(String evidenceRecordFilename, ASiCContent asicContent, EvidenceRecordTypeEnum evidenceRecordType) {
        this.assertASiCContentIsValid(asicContent);
        evidenceRecordFilename = this.getWithMetaInfFolder(evidenceRecordFilename);
        this.assertFilenameValid(evidenceRecordFilename, asicContent.getEvidenceRecordDocuments());
        switch (evidenceRecordType) {
            case XML_EVIDENCE_RECORD: {
                if (evidenceRecordFilename.endsWith(".xml")) break;
                throw new IllegalArgumentException(String.format("An XMLERS evidence record file within ASiC container shall end with '%s' extension!", ".xml"));
            }
            case ASN1_EVIDENCE_RECORD: {
                if (evidenceRecordFilename.endsWith(".ers")) break;
                throw new IllegalArgumentException(String.format("An ERS evidence record file within ASiC container shall end with '%s' extension!", ".ers"));
            }
            default: {
                throw new UnsupportedOperationException(String.format("The Evidence Record Type '%s' is not supported!", evidenceRecordType));
            }
        }
        if (ASiCUtils.isASiCSContainer((ASiCContent)asicContent) && Utils.isCollectionEmpty((Collection)asicContent.getEvidenceRecordDocuments()) && !"META-INF/evidencerecord.ers".equals(evidenceRecordFilename) && !"META-INF/evidencerecord.xml".equals(evidenceRecordFilename)) {
            throw new IllegalArgumentException(String.format("An evidence record file within ASiC-S with CAdES container shall have name '%s' or '%s'!", "META-INF/evidencerecord.ers", "META-INF/evidencerecord.xml"));
        }
        if (!evidenceRecordFilename.startsWith("META-INF/") || !evidenceRecordFilename.contains("evidencerecord")) {
            throw new IllegalArgumentException(String.format("An evidence record file within ASiC-E with CAdES container shall match the template '%s'!", "META-INF/*evidencerecord*(.ers||.xml)"));
        }
        return evidenceRecordFilename;
    }

    protected String getValidManifestFilename(String manifestFilename, ASiCContent asicContent) {
        manifestFilename = this.getWithMetaInfFolder(manifestFilename);
        this.assertFilenameValid(manifestFilename, asicContent.getManifestDocuments());
        if (!manifestFilename.startsWith("META-INF/ASiCManifest") || !manifestFilename.endsWith(".xml")) {
            throw new IllegalArgumentException(String.format("A manifest file within ASiC with CAdES container shall match the template '%s'!", "META-INF/ASiCManifest*.xml"));
        }
        return manifestFilename;
    }

    protected String getValidArchiveManifestFilename(String archiveManifestFilename, ASiCContent asicContent) {
        archiveManifestFilename = this.getWithMetaInfFolder(archiveManifestFilename);
        this.assertFilenameValid(archiveManifestFilename, asicContent.getArchiveManifestDocuments());
        if (!archiveManifestFilename.startsWith("META-INF/ASiCArchiveManifest") || !archiveManifestFilename.endsWith(".xml")) {
            throw new IllegalArgumentException(String.format("An archive manifest file within ASiC with CAdES container shall match the template '%s'!", "META-INF/ASiCArchiveManifest*.xml"));
        }
        if ("META-INF/ASiCArchiveManifest.xml".equals(archiveManifestFilename)) {
            throw new IllegalArgumentException(String.format("An archive manifest file within ASiC with CAdES container cannot be moved to a file with name '%s'!", "META-INF/ASiCArchiveManifest.xml"));
        }
        return archiveManifestFilename;
    }
}

