/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio.tools;

import com.anf.jna.smartcardio.Smartcardio;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;

public class WaitForChange {
    private static List<String> terminalNames(List<CardTerminal> terminals) {
        ArrayList<String> r = new ArrayList<String>(terminals.size());
        for (int i = 0; i < terminals.size(); ++i) {
            r.add(terminals.get(i).getName());
        }
        return r;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider(new Smartcardio());
        TerminalFactory context = TerminalFactory.getInstance("PC/SC", null, "JNA2PCSC");
        CardTerminals terminals = context.terminals();
        List<CardTerminal> present = terminals.list(CardTerminals.State.CARD_PRESENT);
        List<CardTerminal> absent = terminals.list(CardTerminals.State.CARD_ABSENT);
        System.out.format("Initial: cards are present in %s; cards are absent from %s%n", WaitForChange.terminalNames(present), WaitForChange.terminalNames(absent));
        while (true) {
            terminals.waitForChange();
            List<CardTerminal> inserted = terminals.list(CardTerminals.State.CARD_INSERTION);
            List<CardTerminal> removed = terminals.list(CardTerminals.State.CARD_REMOVAL);
            System.out.format("Card inserted in %s; cards removed from %s%n", WaitForChange.terminalNames(inserted), WaitForChange.terminalNames(removed));
        }
    }
}

