/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio.tools;

import com.anf.jna.smartcardio.CardExceptionWrapper;
import com.anf.jna.smartcardio.JnaCard;
import com.anf.jna.smartcardio.Smartcardio;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmartCardListService {
    private static final Logger log = LogManager.getLogger(SmartCardListService.class);
    TerminalFactory factory;
    CardTerminals terminals;
    long lastGC = System.currentTimeMillis();

    public SmartCardListService() throws NoSuchAlgorithmException {
        this.load();
    }

    private void load() throws NoSuchAlgorithmException {
        this.factory = TerminalFactory.getInstance("PC/SC", null, new Smartcardio());
        this.terminals = this.factory.terminals();
    }

    public List<JnaCard> listCards(Predicate<byte[]> atrFilter, Predicate<String> nameFilter) throws CardExceptionWrapper, Exception {
        try {
            log.debug("listando smart cards");
            return this.listCards(this.terminals, atrFilter, nameFilter);
        }
        catch (CardException e) {
            String error = e.getMessage();
            if (error.contains("SCARD_E_SERVICE_STOPPED") || error.contains("SCARD_E_NO_SERVICE")) {
                this.load();
                return this.listCards(this.terminals, atrFilter, nameFilter);
            }
            throw new CardExceptionWrapper(e);
        }
    }

    public void waitForChange() {
        try {
            this.terminals.waitForChange();
        }
        catch (CardException e) {
            log.error("error en waitForChange", (Throwable)e);
            if (System.currentTimeMillis() - this.lastGC > 5000L) {
                System.gc();
                this.lastGC = System.currentTimeMillis();
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e1) {
                log.error("error en sleep", (Throwable)e);
            }
        }
    }

    private List<JnaCard> listCards(CardTerminals terminals, Predicate<byte[]> atrFilter, Predicate<String> nameFilter) throws Exception {
        ArrayList<JnaCard> cards = new ArrayList<JnaCard>();
        for (CardTerminal ct : terminals.list(CardTerminals.State.ALL)) {
            Card card;
            if (nameFilter != null && !nameFilter.test(ct.getName()) || !ct.isCardPresent() || !((card = ct.connect("*")) instanceof JnaCard)) continue;
            JnaCard jnaCard = (JnaCard)card;
            if (!atrFilter.test(card.getATR().getBytes())) continue;
            cards.add(jnaCard);
        }
        return cards;
    }
}

