/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SCardServiceHandler {
    private static final Logger log = LogManager.getLogger(SCardServiceHandler.class);

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static int start() {
        if (!SCardServiceHandler.isWindows()) {
            return 0;
        }
        try {
            log.info("ejecutando net start SCardSvr");
            Process proc = Runtime.getRuntime().exec("net start SCardSvr");
            proc.waitFor();
            int exitValue = proc.exitValue();
            log.info("start SCardSvr return " + exitValue);
            return exitValue;
        }
        catch (IOException | InterruptedException e) {
            log.error((Object)e);
            return -1;
        }
    }

    public static boolean isRunning() {
        if (!SCardServiceHandler.isWindows()) {
            return true;
        }
        try {
            String command = "sc query \"scardsvr\"";
            log.info("ejecutando " + command);
            Process proc = Runtime.getRuntime().exec(command);
            proc.waitFor();
            int exitValue = proc.exitValue();
            if (exitValue == 0) {
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = "";
                while ((line = br.readLine()) != null) {
                    if (line.contains("RUNNING")) {
                        log.info("scardsvr running");
                        return true;
                    }
                    if (!line.contains("STOPPED")) continue;
                    log.info("scardsvr stopped");
                    return false;
                }
            }
        }
        catch (IOException | InterruptedException e) {
            log.error((Object)e);
        }
        return false;
    }

    public static int stop() {
        if (!SCardServiceHandler.isWindows()) {
            return 0;
        }
        try {
            Process proc = Runtime.getRuntime().exec("net stop SCardSvr");
            proc.waitFor();
            int exitValue = proc.exitValue();
            log.info("stop SCardSvr return " + exitValue);
            return exitValue;
        }
        catch (IOException | InterruptedException e) {
            log.error((Object)e);
            return -1;
        }
    }
}

