/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class WinscardConstants {
    public static final int SCARD_S_SUCCESS = 0;
    public static final int SCARD_F_INTERNAL_ERROR = -2146435071;
    public static final int SCARD_E_CANCELLED = -2146435070;
    public static final int SCARD_E_INVALID_HANDLE = -2146435069;
    public static final int SCARD_E_INVALID_PARAMETER = -2146435068;
    public static final int SCARD_E_INVALID_TARGET = -2146435067;
    public static final int SCARD_E_NO_MEMORY = -2146435066;
    public static final int SCARD_F_WAITED_TOO_LONG = -2146435065;
    public static final int SCARD_E_INSUFFICIENT_BUFFER = -2146435064;
    public static final int SCARD_E_UNKNOWN_READER = -2146435063;
    public static final int SCARD_E_TIMEOUT = -2146435062;
    public static final int SCARD_E_SHARING_VIOLATION = -2146435061;
    public static final int SCARD_E_NO_SMARTCARD = -2146435060;
    public static final int SCARD_E_UNKNOWN_CARD = -2146435059;
    public static final int SCARD_E_CANT_DISPOSE = -2146435058;
    public static final int SCARD_E_PROTO_MISMATCH = -2146435057;
    public static final int SCARD_E_NOT_READY = -2146435056;
    public static final int SCARD_E_INVALID_VALUE = -2146435055;
    public static final int SCARD_E_SYSTEM_CANCELLED = -2146435054;
    public static final int SCARD_F_COMM_ERROR = -2146435053;
    public static final int SCARD_F_UNKNOWN_ERROR = -2146435052;
    public static final int SCARD_E_INVALID_ATR = -2146435051;
    public static final int SCARD_E_NOT_TRANSACTED = -2146435050;
    public static final int SCARD_E_READER_UNAVAILABLE = -2146435049;
    public static final int SCARD_P_SHUTDOWN = -2146435048;
    public static final int SCARD_E_PCI_TOO_SMALL = -2146435047;
    public static final int SCARD_E_READER_UNSUPPORTED = -2146435046;
    public static final int SCARD_E_DUPLICATE_READER = -2146435045;
    public static final int SCARD_E_CARD_UNSUPPORTED = -2146435044;
    public static final int SCARD_E_NO_SERVICE = -2146435043;
    public static final int SCARD_E_SERVICE_STOPPED = -2146435042;
    public static final int SCARD_E_UNEXPECTED = -2146435041;
    public static final int SCARD_E_UNSUPPORTED_FEATURE = -2146435041;
    public static final int SCARD_E_ICC_INSTALLATION = -2146435040;
    public static final int SCARD_E_ICC_CREATEORDER = -2146435039;
    public static final int SCARD_E_DIR_NOT_FOUND = -2146435037;
    public static final int SCARD_E_FILE_NOT_FOUND = -2146435036;
    public static final int SCARD_E_NO_DIR = -2146435035;
    public static final int SCARD_E_NO_FILE = -2146435034;
    public static final int SCARD_E_NO_ACCESS = -2146435033;
    public static final int SCARD_E_WRITE_TOO_MANY = -2146435032;
    public static final int SCARD_E_BAD_SEEK = -2146435031;
    public static final int SCARD_E_INVALID_CHV = -2146435030;
    public static final int SCARD_E_UNKNOWN_RES_MNG = -2146435029;
    public static final int SCARD_E_NO_SUCH_CERTIFICATE = -2146435028;
    public static final int SCARD_E_CERTIFICATE_UNAVAILABLE = -2146435027;
    public static final int SCARD_E_NO_READERS_AVAILABLE = -2146435026;
    public static final int SCARD_E_COMM_DATA_LOST = -2146435025;
    public static final int SCARD_E_NO_KEY_CONTAINER = -2146435024;
    public static final int SCARD_E_SERVER_TOO_BUSY = -2146435023;
    public static final int SCARD_W_UNSUPPORTED_CARD = -2146434971;
    public static final int SCARD_W_UNRESPONSIVE_CARD = -2146434970;
    public static final int SCARD_W_UNPOWERED_CARD = -2146434969;
    public static final int SCARD_W_RESET_CARD = -2146434968;
    public static final int SCARD_W_REMOVED_CARD = -2146434967;
    public static final int SCARD_W_SECURITY_VIOLATION = -2146434966;
    public static final int SCARD_W_WRONG_CHV = -2146434965;
    public static final int SCARD_W_CHV_BLOCKED = -2146434964;
    public static final int SCARD_W_EOF = -2146434963;
    public static final int SCARD_W_CANCELLED_BY_USER = -2146434962;
    public static final int SCARD_W_CARD_NOT_AUTHENTICATED = -2146434961;
    public static final Map<Integer, String> ERROR_TO_DESCRIPTION;
    public static final Map<Integer, String> ERROR_TO_VARIABLE_NAME;
    public static final int SCARD_STATE_UNAWARE = 0;
    public static final int SCARD_STATE_IGNORE = 1;
    public static final int SCARD_STATE_CHANGED = 2;
    public static final int SCARD_STATE_UNKNOWN = 4;
    public static final int SCARD_STATE_UNAVAILABLE = 8;
    public static final int SCARD_STATE_EMPTY = 16;
    public static final int SCARD_STATE_PRESENT = 32;
    public static final int SCARD_STATE_ATRMATCH = 64;
    public static final int SCARD_STATE_EXCLUSIVE = 128;
    public static final int SCARD_STATE_INUSE = 256;
    public static final int SCARD_STATE_MUTE = 512;
    public static final int SCARD_STATE_UNPOWERED = 1024;
    public static final int INFINITE = -1;
    public static final int MAX_ATR_SIZE = 33;
    public static final String PNP_READER_ID = "\\\\?PnP?\\Notification";

    private WinscardConstants() {
    }

    public static List<String> stateToStrings(int scardState) {
        if (0 == scardState) {
            return Arrays.asList("unaware");
        }
        ArrayList<String> r = new ArrayList<String>();
        if (0 != (scardState & 1)) {
            r.add("ignore");
        }
        if (0 != (scardState & 2)) {
            r.add("changed");
        }
        if (0 != (scardState & 4)) {
            r.add("unknown");
        }
        if (0 != (scardState & 8)) {
            r.add("unavailable");
        }
        if (0 != (scardState & 0x10)) {
            r.add("empty");
        }
        if (0 != (scardState & 0x20)) {
            r.add("present");
        }
        if (0 != (scardState & 0x40)) {
            r.add("atrmatch");
        }
        if (0 != (scardState & 0x80)) {
            r.add("exclusive");
        }
        if (0 != (scardState & 0x100)) {
            r.add("inuse");
        }
        if (0 != (scardState & 0x200)) {
            r.add("mute");
        }
        if (0 != (scardState & 0x400)) {
            r.add("unpowered");
        }
        return r;
    }

    static {
        HashMap<Integer, String> a = new HashMap<Integer, String>();
        HashMap<Integer, String> b = new HashMap<Integer, String>();
        a.put(0, "SCARD_S_SUCCESS");
        b.put(0, "error codes from http://msdn.microsoft.com/en-us/library/aa924526.aspx");
        a.put(-2146435071, "SCARD_F_INTERNAL_ERROR");
        b.put(-2146435071, "An internal consistency check failed.");
        a.put(-2146435070, "SCARD_E_CANCELLED");
        b.put(-2146435070, "The action was cancelled by an SCardCancel request.");
        a.put(-2146435069, "SCARD_E_INVALID_HANDLE");
        b.put(-2146435069, "The supplied handle was invalid.");
        a.put(-2146435068, "SCARD_E_INVALID_PARAMETER");
        b.put(-2146435068, "One or more of the supplied parameters could not be properly interpreted.");
        a.put(-2146435067, "SCARD_E_INVALID_TARGET");
        b.put(-2146435067, "Registry startup information is missing or invalid.");
        a.put(-2146435066, "SCARD_E_NO_MEMORY");
        b.put(-2146435066, "Not enough memory available to complete this command.");
        a.put(-2146435065, "SCARD_F_WAITED_TOO_LONG");
        b.put(-2146435065, "An internal consistency timer has expired.");
        a.put(-2146435064, "SCARD_E_INSUFFICIENT_BUFFER");
        b.put(-2146435064, "The data buffer to receive returned data is too small for the returned data.");
        a.put(-2146435063, "SCARD_E_UNKNOWN_READER");
        b.put(-2146435063, "The specified reader name is not recognized.");
        a.put(-2146435062, "SCARD_E_TIMEOUT");
        b.put(-2146435062, "The user-specified timeout value has expired.");
        a.put(-2146435061, "SCARD_E_SHARING_VIOLATION");
        b.put(-2146435061, "The smart card cannot be accessed because of other connections outstanding.");
        a.put(-2146435060, "SCARD_E_NO_SMARTCARD");
        b.put(-2146435060, "The operation requires a Smart Card, but no Smart Card is currently in the device.");
        a.put(-2146435059, "SCARD_E_UNKNOWN_CARD");
        b.put(-2146435059, "The specified smart card name is not recognized.");
        a.put(-2146435058, "SCARD_E_CANT_DISPOSE");
        b.put(-2146435058, "The system could not dispose of the media in the requested manner.");
        a.put(-2146435057, "SCARD_E_PROTO_MISMATCH");
        b.put(-2146435057, "The requested protocols are incompatible with the protocol currently in use with the smart card.");
        a.put(-2146435056, "SCARD_E_NOT_READY");
        b.put(-2146435056, "The reader or smart card is not ready to accept commands.");
        a.put(-2146435055, "SCARD_E_INVALID_VALUE");
        b.put(-2146435055, "One or more of the supplied parameters values could not be properly interpreted.");
        a.put(-2146435054, "SCARD_E_SYSTEM_CANCELLED");
        b.put(-2146435054, "The action was cancelled by the system, presumably to log off or shut down.");
        a.put(-2146435053, "SCARD_F_COMM_ERROR");
        b.put(-2146435053, "An internal communications error has been detected.");
        a.put(-2146435052, "SCARD_F_UNKNOWN_ERROR");
        b.put(-2146435052, "An internal error has been detected, but the source is unknown.");
        a.put(-2146435051, "SCARD_E_INVALID_ATR");
        b.put(-2146435051, "An ATR obtained from the registry is not a valid ATR string.");
        a.put(-2146435050, "SCARD_E_NOT_TRANSACTED");
        b.put(-2146435050, "An attempt was made to end a non-existent transaction.");
        a.put(-2146435049, "SCARD_E_READER_UNAVAILABLE");
        b.put(-2146435049, "The specified reader is not currently available for use.");
        a.put(-2146435048, "SCARD_P_SHUTDOWN");
        b.put(-2146435048, "The operation has been aborted to allow the server application to exit.");
        a.put(-2146435047, "SCARD_E_PCI_TOO_SMALL");
        b.put(-2146435047, "The PCI Receive buffer was too small.");
        a.put(-2146435046, "SCARD_E_READER_UNSUPPORTED");
        b.put(-2146435046, "The reader driver does not meet minimal requirements for support.");
        a.put(-2146435045, "SCARD_E_DUPLICATE_READER");
        b.put(-2146435045, "The reader driver did not produce a unique reader name.");
        a.put(-2146435044, "SCARD_E_CARD_UNSUPPORTED");
        b.put(-2146435044, "The smart card does not meet minimal requirements for support.");
        a.put(-2146435043, "SCARD_E_NO_SERVICE");
        b.put(-2146435043, "The Smart card resource manager is not running.");
        a.put(-2146435042, "SCARD_E_SERVICE_STOPPED");
        b.put(-2146435042, "The Smart card resource manager has shut down.");
        a.put(-2146435041, "SCARD_E_UNEXPECTED");
        b.put(-2146435041, "An unexpected card error has occurred.");
        a.put(-2146435041, "SCARD_E_UNSUPPORTED_FEATURE");
        b.put(-2146435041, "This smart card does not support the requested feature.");
        a.put(-2146435040, "SCARD_E_ICC_INSTALLATION");
        b.put(-2146435040, "No primary provider can be found for the smart card.");
        a.put(-2146435039, "SCARD_E_ICC_CREATEORDER");
        b.put(-2146435039, "The requested order of object creation is not supported.");
        a.put(-2146435037, "SCARD_E_DIR_NOT_FOUND");
        b.put(-2146435037, "The identified directory does not exist in the smart card.");
        a.put(-2146435036, "SCARD_E_FILE_NOT_FOUND");
        b.put(-2146435036, "The identified file does not exist in the smart card.");
        a.put(-2146435035, "SCARD_E_NO_DIR");
        b.put(-2146435035, "The supplied path does not represent a smart card directory.");
        a.put(-2146435034, "SCARD_E_NO_FILE");
        b.put(-2146435034, "The supplied path does not represent a smart card file.");
        a.put(-2146435033, "SCARD_E_NO_ACCESS");
        b.put(-2146435033, "Access is denied to this file.");
        a.put(-2146435032, "SCARD_E_WRITE_TOO_MANY");
        b.put(-2146435032, "The smart card does not have enough memory to store the information.");
        a.put(-2146435031, "SCARD_E_BAD_SEEK");
        b.put(-2146435031, "There was an error trying to set the smart card file object pointer.");
        a.put(-2146435030, "SCARD_E_INVALID_CHV");
        b.put(-2146435030, "The supplied PIN is incorrect.");
        a.put(-2146435029, "SCARD_E_UNKNOWN_RES_MNG");
        b.put(-2146435029, "An unrecognized error code was returned from a layered component.");
        a.put(-2146435028, "SCARD_E_NO_SUCH_CERTIFICATE");
        b.put(-2146435028, "The requested certificate does not exist.");
        a.put(-2146435027, "SCARD_E_CERTIFICATE_UNAVAILABLE");
        b.put(-2146435027, "The requested certificate could not be obtained.");
        a.put(-2146435026, "SCARD_E_NO_READERS_AVAILABLE");
        b.put(-2146435026, "Cannot find a smart card reader.");
        a.put(-2146435025, "SCARD_E_COMM_DATA_LOST");
        b.put(-2146435025, "A communications error with the smart card has been detected.");
        a.put(-2146435024, "SCARD_E_NO_KEY_CONTAINER");
        b.put(-2146435024, "The requested key container does not exist on the smart card.");
        a.put(-2146435023, "SCARD_E_SERVER_TOO_BUSY");
        b.put(-2146435023, "The Smart Card Resource Manager is too busy to complete this operation.");
        a.put(-2146434971, "SCARD_W_UNSUPPORTED_CARD");
        b.put(-2146434971, "The reader cannot communicate with the card, due to ATR string configuration conflicts.");
        a.put(-2146434970, "SCARD_W_UNRESPONSIVE_CARD");
        b.put(-2146434970, "The smart card is not responding to a reset.");
        a.put(-2146434969, "SCARD_W_UNPOWERED_CARD");
        b.put(-2146434969, "Power has been removed from the smart card, so that further communication is not possible.");
        a.put(-2146434968, "SCARD_W_RESET_CARD");
        b.put(-2146434968, "The smart card has been reset, so any shared state information is invalid.");
        a.put(-2146434967, "SCARD_W_REMOVED_CARD");
        b.put(-2146434967, "The smart card has been removed, so further communication is not possible.");
        a.put(-2146434966, "SCARD_W_SECURITY_VIOLATION");
        b.put(-2146434966, "Access was denied because of a security violation.");
        a.put(-2146434965, "SCARD_W_WRONG_CHV");
        b.put(-2146434965, "The card cannot be accessed because the wrong PIN was presented.");
        a.put(-2146434964, "SCARD_W_CHV_BLOCKED");
        b.put(-2146434964, "The card cannot be accessed because the maximum number of PIN entry attempts has been reached.");
        a.put(-2146434963, "SCARD_W_EOF");
        b.put(-2146434963, "The end of the smart card file has been reached.");
        a.put(-2146434962, "SCARD_W_CANCELLED_BY_USER");
        b.put(-2146434962, "The user pressed \"Cancel\" on a Smart Card Selection Dialog.");
        a.put(-2146434961, "SCARD_W_CARD_NOT_AUTHENTICATED");
        b.put(-2146434961, "No PIN was presented to the smart card.");
        ERROR_TO_VARIABLE_NAME = Collections.unmodifiableMap(a);
        ERROR_TO_DESCRIPTION = Collections.unmodifiableMap(b);
    }
}

