/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio;

import com.anf.jna.smartcardio.Dword;
import com.anf.jna.smartcardio.JnaPCSCException;
import com.anf.jna.smartcardio.JnaTerminalFactorySpi;
import com.anf.jna.smartcardio.WinscardConstants;
import java.nio.charset.Charset;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Smartcardio
extends Provider {
    private static final long serialVersionUID = 1L;
    static final int MAX_ATR_SIZE = 33;
    public static final String PROVIDER_NAME = "JNA2PCSC";
    public static final int SCARD_S_SUCCESS = 0;
    public static final int SCARD_E_NO_READERS_AVAILABLE = -2146435026;
    public static final int SCARD_E_READER_UNAVAILABLE = -2146435049;
    public static final int SCARD_E_NO_SMARTCARD = -2146435060;

    public Smartcardio() {
        super(PROVIDER_NAME, "2.0", "JNA-to-PCSC Provider");
        this.put("TerminalFactory.PC/SC", JnaTerminalFactorySpi.class.getName());
    }

    private static List<String> pcsc_multi2jstring(byte[] multiString, Charset charset) {
        ArrayList<String> r = new ArrayList<String>();
        int from = 0;
        for (int to = 0; to < multiString.length; ++to) {
            if (multiString[to] != 0) continue;
            if (from == to) {
                return r;
            }
            byte[] bytes = Arrays.copyOfRange(multiString, from, to);
            r.add(new String(bytes, charset));
            from = to + 1;
        }
        throw new IllegalArgumentException("Multistring must be end with a null-terminated empty string.");
    }

    public static List<String> pcsc_multi2jstring(byte[] multiString) {
        return Smartcardio.pcsc_multi2jstring(multiString, Charset.forName("UTF-8"));
    }

    public static void check(String message, Dword code) throws JnaPCSCException {
        Smartcardio.check(message, code.longValue());
    }

    public static void check(String message, long code) throws JnaPCSCException {
        if (code == 0L) {
            return;
        }
        int icode = (int)code;
        String codeName = WinscardConstants.ERROR_TO_VARIABLE_NAME.get(icode);
        String codeDescription = WinscardConstants.ERROR_TO_DESCRIPTION.get(icode);
        throw new JnaPCSCException(code, String.format("%s got response 0x%x (%s: %s)", message, icode, codeName, codeDescription));
    }
}

