/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio;

import com.anf.jna.smartcardio.Dword;
import com.anf.jna.smartcardio.DwordByReference;
import com.anf.jna.smartcardio.JnaCard;
import com.anf.jna.smartcardio.JnaCardNotPresentException;
import com.anf.jna.smartcardio.JnaCardTerminals;
import com.anf.jna.smartcardio.JnaPCSCException;
import com.anf.jna.smartcardio.SCardHandle;
import com.anf.jna.smartcardio.SCardHandleByReference;
import com.anf.jna.smartcardio.SCardReaderState;
import com.anf.jna.smartcardio.Smartcardio;
import com.anf.jna.smartcardio.WinscardLibInfo;
import com.sun.jna.Platform;
import java.nio.ByteBuffer;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;

public class JnaCardTerminal
extends CardTerminal {
    private final WinscardLibInfo libInfo;
    private final JnaCardTerminals cardTerminals;
    private final String name;
    public static final int SCARD_SHARE_EXCLUSIVE = 1;
    public static final int SCARD_SHARE_SHARED = 2;
    public static final int SCARD_SHARE_DIRECT = 3;
    public static final int SCARD_PROTOCOL_T0 = 1;
    public static final int SCARD_PROTOCOL_T1 = 2;
    public static final int SCARD_PROTOCOL_ANY = 3;
    public static final int SCARD_UNKNOWN = 1;
    public static final int SCARD_ABSENT = 2;
    public static final int SCARD_PRESENT = 4;
    public static final int SCARD_SWALLOWED = 8;
    public static final int SCARD_POWERED = 16;
    public static final int SCARD_NEGOTIABLE = 32;
    public static final int SCARD_SPECIFIC = 64;

    public JnaCardTerminal(WinscardLibInfo libInfo, JnaCardTerminals cardTerminals, String name) {
        this.libInfo = libInfo;
        this.cardTerminals = cardTerminals;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Card connect(String protocol) throws CardException {
        int dwPreferredProtocols;
        int dwShareMode = 2;
        if ((protocol = protocol.toUpperCase()).startsWith("EXCLUSIVE;")) {
            dwShareMode = 1;
            protocol = protocol.substring("EXCLUSIVE;".length());
        }
        if ("T=0".equals(protocol)) {
            dwPreferredProtocols = 1;
        } else if ("T=1".equals(protocol)) {
            dwPreferredProtocols = 2;
        } else if ("*".equals(protocol)) {
            dwPreferredProtocols = 3;
        } else if ("DIRECT".equalsIgnoreCase(protocol)) {
            dwPreferredProtocols = 0;
            if (Platform.isMac()) {
                dwPreferredProtocols = 3;
            }
            dwShareMode = 3;
        } else {
            throw new IllegalArgumentException("Protocol should be one of (prepended with EXCLUSIVE;) T=0, T=1, *, DIRECT. Got " + protocol);
        }
        SCardHandleByReference phCard = new SCardHandleByReference();
        DwordByReference pdwActiveProtocol = new DwordByReference();
        long err = this.libInfo.lib.SCardConnect(this.cardTerminals.scardContext, this.name, new Dword(dwShareMode), new Dword(dwPreferredProtocols), phCard, pdwActiveProtocol).longValue();
        switch ((int)err) {
            case 0: {
                SCardHandle scardHandle = phCard.getValue();
                DwordByReference readerLength = new DwordByReference();
                DwordByReference currentState = new DwordByReference();
                DwordByReference currentProtocol = new DwordByReference();
                ByteBuffer atrBuf = ByteBuffer.allocate(33);
                DwordByReference atrLength = new DwordByReference(new Dword(33L));
                Smartcardio.check("SCardStatus", this.libInfo.lib.SCardStatus(scardHandle, null, readerLength, currentState, currentProtocol, atrBuf, atrLength));
                int atrLengthInt = atrLength.getValue().intValue();
                atrBuf.limit(atrLengthInt);
                byte[] atrBytes = new byte[atrBuf.remaining()];
                atrBuf.get(atrBytes);
                ATR atr = new ATR(atrBytes);
                int currentProtocolInt = currentProtocol.getValue().intValue();
                return new JnaCard(this.libInfo, this, scardHandle, atr, currentProtocolInt);
            }
            case -2146434967: {
                throw new JnaCardNotPresentException(err, "Card not present.");
            }
        }
        Smartcardio.check("SCardConnect", err);
        throw new RuntimeException("Should not reach here.");
    }

    @Override
    public boolean isCardPresent() throws CardException {
        SCardReaderState[] rgReaderStates = new SCardReaderState[1];
        new SCardReaderState().toArray(rgReaderStates);
        rgReaderStates[0].szReader = this.name;
        SCardReaderState readerState = rgReaderStates[0];
        Smartcardio.check("SCardGetStatusChange", this.libInfo.lib.SCardGetStatusChange(this.cardTerminals.scardContext, new Dword(0L), rgReaderStates, new Dword(rgReaderStates.length)));
        return 0 != (readerState.dwEventState.intValue() & 0x20);
    }

    private boolean waitHelper(long timeoutMs, boolean cardPresent) throws JnaPCSCException {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Negative timeout " + timeoutMs);
        }
        if (timeoutMs == 0L) {
            timeoutMs = -1L;
        }
        SCardReaderState[] rgReaderStates = new SCardReaderState[1];
        new SCardReaderState().toArray(rgReaderStates);
        SCardReaderState readerState = rgReaderStates[0];
        readerState.szReader = this.name;
        Smartcardio.check("SCardGetStatusChange", this.libInfo.lib.SCardGetStatusChange(this.cardTerminals.scardContext, new Dword(0L), rgReaderStates, new Dword(rgReaderStates.length)));
        int remainingTimeout = (int)timeoutMs;
        while (cardPresent != (0 != (readerState.dwEventState.intValue() & 0x20))) {
            readerState.dwCurrentState = readerState.dwEventState;
            readerState.dwEventState = new Dword(0L);
            long startTime = System.currentTimeMillis();
            Dword err = this.libInfo.lib.SCardGetStatusChange(this.cardTerminals.scardContext, new Dword(remainingTimeout), rgReaderStates, new Dword(rgReaderStates.length));
            long endTime = System.currentTimeMillis();
            if (-2146435062 == err.intValue()) {
                return false;
            }
            Smartcardio.check("SCardGetStatusChange", err);
            if (remainingTimeout == -1) continue;
            if ((long)remainingTimeout < endTime - startTime) {
                return false;
            }
            remainingTimeout = (int)((long)remainingTimeout - (endTime - startTime));
        }
        return true;
    }

    @Override
    public boolean waitForCardAbsent(long timeoutMs) throws CardException {
        return this.waitHelper(timeoutMs, false);
    }

    @Override
    public boolean waitForCardPresent(long timeoutMs) throws CardException {
        return this.waitHelper(timeoutMs, true);
    }

    public String toString() {
        return String.format("%s{scardHandle=%s, name=%s}", new Object[]{this.getClass().getSimpleName(), this.cardTerminals.scardContext, this.name});
    }
}

