/*
 * Decompiled with CFR 0.152.
 */
package com.anf.jna.smartcardio;

import com.anf.jna.smartcardio.ATRWrapper;
import com.anf.jna.smartcardio.Dword;
import com.anf.jna.smartcardio.DwordByReference;
import com.anf.jna.smartcardio.JnaCardChannel;
import com.anf.jna.smartcardio.JnaCardException;
import com.anf.jna.smartcardio.JnaCardTerminal;
import com.anf.jna.smartcardio.SCardHandle;
import com.anf.jna.smartcardio.Smartcardio;
import com.anf.jna.smartcardio.WinscardLibInfo;
import java.nio.ByteBuffer;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class JnaCard
extends Card {
    final WinscardLibInfo libInfo;
    private final CardTerminal cardTerminal;
    final SCardHandle scardHandle;
    private final ATRWrapper atr;
    final int protocol;
    public static final int SCARD_LEAVE_CARD = 0;
    public static final int SCARD_RESET_CARD = 1;
    public static final int SCARD_UNPOWER_CARD = 2;
    public static final int SCARD_EJECT_CARD = 3;

    public JnaCard(WinscardLibInfo libInfo, JnaCardTerminal cardTerminal, SCardHandle scardHandle, ATR atr, int protocol) {
        this.libInfo = libInfo;
        this.cardTerminal = cardTerminal;
        this.scardHandle = scardHandle;
        this.atr = new ATRWrapper(atr);
        this.protocol = protocol;
        this.getProtocol();
    }

    @Override
    public void beginExclusive() throws CardException {
        Smartcardio.check("SCardBeginTransaction", this.libInfo.lib.SCardBeginTransaction(this.scardHandle));
    }

    @Override
    public void endExclusive() throws CardException {
        Smartcardio.check("SCardEndTransaction", this.libInfo.lib.SCardEndTransaction(this.scardHandle, new Dword(0L)));
    }

    @Override
    public void disconnect(boolean reset) throws CardException {
        int dwDisposition = reset ? 1 : 0;
        Smartcardio.check("SCardDisconnect", this.libInfo.lib.SCardDisconnect(this.scardHandle, new Dword(dwDisposition)));
    }

    @Override
    public ATR getATR() {
        return this.atr.getATR();
    }

    public ATRWrapper getATRWrapper() {
        return this.atr;
    }

    @Override
    public String getProtocol() {
        switch (this.protocol) {
            case 1: {
                return "T=0";
            }
            case 2: {
                return "T=1";
            }
        }
        return "DIRECT";
    }

    @Override
    public JnaCardChannel getBasicChannel() {
        return new JnaCardChannel(this, 0);
    }

    @Override
    public CardChannel openLogicalChannel() throws CardException {
        JnaCardChannel basicChannel = this.getBasicChannel();
        ResponseAPDU response = basicChannel.transmit(new CommandAPDU(0, 112, 0, 0, 1));
        int sw = response.getSW();
        if (36864 == sw) {
            byte[] body = response.getData();
            if (body.length == 1) {
                int channel = 0xFF & body[0];
                if (channel == 0 || channel > 19) {
                    throw new JnaCardException(sw, String.format("Expected manage channel response to contain channel number in 1-19; got %d", channel));
                }
                return new JnaCardChannel(this, channel);
            }
            throw new JnaCardException(sw, String.format("Expected body of length 1 in response to manage channel request; got %d", body.length));
        }
        throw new JnaCardException(sw, String.format("Error: sw=%04x in response to manage channel command.", sw));
    }

    @Override
    public byte[] transmitControlCommand(int controlCode, byte[] arg1) throws CardException {
        ByteBuffer receiveBuf = ByteBuffer.allocate(8192);
        DwordByReference lpBytesReturned = new DwordByReference();
        ByteBuffer arg1Wrapped = ByteBuffer.wrap(arg1);
        Smartcardio.check("SCardControl", this.libInfo.lib.SCardControl(this.scardHandle, new Dword(controlCode), arg1Wrapped, new Dword(arg1.length), receiveBuf, new Dword(receiveBuf.remaining()), lpBytesReturned));
        int bytesReturned = lpBytesReturned.getValue().intValue();
        receiveBuf.limit(bytesReturned);
        byte[] r = new byte[bytesReturned];
        receiveBuf.get(r);
        return r;
    }

    public String toString() {
        return String.format("%s{scardHandle=%s}", new Object[]{this.getClass().getSimpleName(), this.scardHandle});
    }
}

