/*
 * Decompiled with CFR 0.152.
 */
package com.anf.timestamp.services;

import com.anf.cert.utils.CertUtils;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class TimestampCertificates {
    private static final Logger log = LogManager.getLogger(TimestampCertificates.class);
    static JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();

    private TimestampCertificates() {
    }

    public static X509Certificate getTSSigningCert(TimeStampToken token) {
        try {
            Collection<X509CertificateHolder> signedDataCerts = TimestampCertificates.getTSCertificateList(token);
            if (!signedDataCerts.isEmpty()) {
                X509CertificateHolder signerCertHolder = signedDataCerts.iterator().next();
                return jcaX509CertificateConverter.getCertificate(signerCertHolder);
            }
            log.warn("el sello de tiempo no tiene certificados");
        }
        catch (CertificateException e) {
            log.error("Error al convertir el certificado de firma del sello de tiempo", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error inesperado al obtener el certificado de firma del sello de tiempo", (Throwable)e);
        }
        return null;
    }

    private static Collection<X509CertificateHolder> getTSCertificateList(TimeStampToken token) {
        CMSSignedData signedData;
        SignerInformationStore signerInfos;
        SignerInformation signerInfo;
        Store certStore = token.getCertificates();
        Collection signedDataCerts = certStore.getMatches((Selector)(signerInfo = (SignerInformation)(signerInfos = (signedData = token.toCMSSignedData()).getSignerInfos()).getSigners().iterator().next()).getSID());
        if (signedDataCerts.isEmpty()) {
            log.warn("No se encontr\u00f3 el certificado de firma del sello de tiempo.");
        }
        return signedDataCerts;
    }

    public static final X509Certificate[] getTSCertificates(TimeStampToken token) {
        return CertUtils.buildChain((X509Certificate[])TimestampCertificates.getTSCertificateList(token).stream().map(holder -> {
            try {
                return jcaX509CertificateConverter.getCertificate(holder);
            }
            catch (CertificateException e) {
                log.error("error al convertir el certificado del sello de tiempo", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList().toArray(new X509Certificate[0]));
    }

    public static final SignerInformation getTSSignerInfo(TimeStampToken token) {
        CMSSignedData data = token.toCMSSignedData();
        SignerInformationStore signerInfos = data.getSignerInfos();
        return (SignerInformation)signerInfos.getSigners().iterator().next();
    }
}

