/*
 * Decompiled with CFR 0.152.
 */
package com.anf.timestamp.services;

import com.anf.timestamp.services.TimestampCertificates;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.SignerInformationVerifierProvider;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class TimeStampValidator {
    private static final Logger log = LogManager.getLogger(TimeStampValidator.class);

    private TimeStampValidator() {
    }

    public static boolean validateTimeStamp(TimeStampToken token) throws TSPException, OperatorCreationException {
        final X509Certificate signerCert = TimestampCertificates.getTSSigningCert(token);
        if (signerCert == null) {
            return false;
        }
        SignerInformation signerInfo = TimestampCertificates.getTSSignerInfo(token);
        final JcaSimpleSignerInfoVerifierBuilder sigVerifBuilder = new JcaSimpleSignerInfoVerifierBuilder();
        SignerInformationVerifierProvider verifierProvider = new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                return sigVerifBuilder.setProvider("BC").build(signerCert);
            }
        };
        boolean signatureValid = false;
        try {
            token.validate(verifierProvider.get(signerInfo.getSID()));
            signatureValid = true;
        }
        catch (Exception e) {
            log.error("error validando sello de tiempo", (Throwable)e);
            signatureValid = false;
        }
        return signatureValid;
    }

    public static boolean verifyTimeStamp(TimeStampToken token, byte[] content) {
        TimeStampTokenInfo info = token.getTimeStampInfo();
        String algOID = info.getMessageImprintAlgOID().getId();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(new DefaultDigestAlgorithmIdentifierFinder().find(algOID).getAlgorithm().getId());
            byte[] md = TimeStampValidator.getDigest(messageDigest, content);
            MessageImprint imprint = info.toASN1Structure().getMessageImprint();
            byte[] imphashed = imprint.getHashedMessage();
            return Arrays.equals(md, imphashed);
        }
        catch (Exception e) {
            log.error("error verificando el sello de tiempo", (Throwable)e);
            return false;
        }
    }

    public static boolean verifyTimeStamp(TimeStampToken token, InputStream content) throws IOException {
        return TimeStampValidator.verifyTimeStamp(token, IOUtils.toByteArray((InputStream)content));
    }

    private static byte[] getDigest(MessageDigest dig, byte[] content) {
        dig.update(content);
        return dig.digest();
    }
}

