/*
 * Decompiled with CFR 0.152.
 */
package com.anf.timestamp.client.impl;

import com.anf.timestamp.client.TSAClient;
import com.anf.timestamp.client.TSAInfoBouncyCastle;
import com.anf.timestamp.exception.TSUFailureException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class TSAClientBouncyCastle
implements TSAClient {
    private static final Logger LOGGER = LogManager.getLogger(TSAClientBouncyCastle.class);
    protected String tsaURL;
    protected String tsaUsername;
    protected String tsaPassword;
    protected TSAInfoBouncyCastle tsaInfo;
    public static final int DEFAULTTOKENSIZE = 4096;
    protected int tokenSizeEstimate;
    public static final String DEFAULTHASHALGORITHM = "SHA-256";
    protected String digestAlgorithm;
    protected ASN1ObjectIdentifier digestAlgorithmOid;
    private String tsaReqPolicy = null;
    private int timeout = 30000;
    protected final DefaultDigestAlgorithmIdentifierFinder defaultDigestAlgorithmIdentifierFinder = new DefaultDigestAlgorithmIdentifierFinder();

    public TSAClientBouncyCastle(String url) {
        this(url, null, null, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientBouncyCastle(String url, String username, String password) {
        this(url, username, password, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientBouncyCastle(String url, String username, String password, int tokSzEstimate, String digestAlgorithm) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
        this.tokenSizeEstimate = tokSzEstimate;
        this.digestAlgorithm = digestAlgorithm;
        this.digestAlgorithmOid = this.defaultDigestAlgorithmIdentifierFinder.find(digestAlgorithm).getAlgorithm();
    }

    public void setTSAInfo(TSAInfoBouncyCastle tsaInfo) {
        this.tsaInfo = tsaInfo;
    }

    @Override
    public int getTokenSizeEstimate() {
        return this.tokenSizeEstimate;
    }

    public String getTSAReqPolicy() {
        return this.tsaReqPolicy;
    }

    public void setTSAReqPolicy(String tsaReqPolicy) {
        this.tsaReqPolicy = tsaReqPolicy;
    }

    @Override
    public MessageDigest getMessageDigest() throws GeneralSecurityException {
        return MessageDigest.getInstance(this.digestAlgorithm);
    }

    @Override
    public byte[] getTimeStampTokenEncoded(byte[] imprint) throws IOException, TSPException {
        return this.getTimeStampTokenEncoded(this.digestAlgorithm, imprint);
    }

    @Override
    public byte[] getTimeStampTokenEncoded(String digestAlgorithm, byte[] imprint) throws IOException, TSPException {
        int value;
        byte[] respBytes = null;
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        if (this.tsaReqPolicy != null && !this.tsaReqPolicy.isEmpty()) {
            tsqGenerator.setReqPolicy(new ASN1ObjectIdentifier(this.tsaReqPolicy));
        }
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        TimeStampRequest request = this.generateRequest(tsqGenerator, imprint, nonce, digestAlgorithm);
        byte[] requestBytes = request.getEncoded();
        respBytes = this.getTSAResponse(requestBytes);
        TimeStampResponse response = new TimeStampResponse(respBytes);
        response.validate(request);
        PKIFailureInfo failure = response.getFailInfo();
        int n = value = failure == null ? 0 : failure.intValue();
        if (value != 0) {
            throw new TSUFailureException((DERBitString)response.getFailInfo(), response.getStatusString());
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new IOException(String.format("TSA %s failed to return time stamp token: %s", this.tsaURL, response.getStatusString()));
        }
        TimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        byte[] encoded = tsToken.getEncoded();
        LOGGER.info("Timestamp generated: {}", (Object)tsTokenInfo.getGenTime());
        if (this.tsaInfo != null) {
            this.tsaInfo.inspectTimeStampTokenInfo(tsTokenInfo);
        }
        this.tokenSizeEstimate = encoded.length + 32;
        return encoded;
    }

    protected TimeStampRequest generateRequest(TimeStampRequestGenerator tsqGenerator, byte[] imprint, BigInteger nonce) {
        return this.generateRequest(tsqGenerator, imprint, nonce, this.digestAlgorithm);
    }

    protected TimeStampRequest generateRequest(TimeStampRequestGenerator tsqGenerator, byte[] imprint, BigInteger nonce, String digestAlgorithm) {
        return tsqGenerator.generate(this.defaultDigestAlgorithmIdentifierFinder.find(digestAlgorithm), imprint, nonce);
    }

    protected byte[] getTSAResponse(byte[] requestBytes) throws IOException {
        URL url = new URL(this.tsaURL);
        URLConnection tsaConnection = url.openConnection();
        tsaConnection.setDoInput(true);
        tsaConnection.setDoOutput(true);
        tsaConnection.setUseCaches(false);
        tsaConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        tsaConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        tsaConnection.setConnectTimeout(this.timeout);
        tsaConnection.setReadTimeout(this.timeout);
        if (this.tsaUsername != null && !this.tsaUsername.equals("")) {
            String userPassword = this.tsaUsername + ":" + this.tsaPassword;
            tsaConnection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(userPassword.getBytes()));
        }
        OutputStream out = tsaConnection.getOutputStream();
        out.write(requestBytes);
        out.close();
        InputStream inp = tsaConnection.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = inp.read(buffer, 0, buffer.length)) >= 0) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] respBytes = baos.toByteArray();
        String encoding = tsaConnection.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("base64")) {
            respBytes = Base64.getDecoder().decode(new String(respBytes));
        }
        return respBytes;
    }
}

