/*
 * Decompiled with CFR 0.152.
 */
package com.anf.timestamp.client.impl;

import com.anf.cert.utils.CertUtils;
import com.anf.timestamp.client.TSUClient;
import com.anf.timestamp.client.impl.TSAClientBouncyCastle;
import com.anf.timestamp.exception.TSUException;
import com.anf.timestamp.exception.TSUFailureException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.encoders.Hex;
import org.kamranzafar.otp.OTP;

public class TSAClientANF
extends TSAClientBouncyCastle
implements TSUClient {
    SecureRandom secureRandom = new SecureRandom();
    private static final Logger log = LogManager.getLogger(TSAClientANF.class);
    private int tokenStimatedSize = 10240;
    private int readTimeOut = 15000;
    private int connectTimeOut = 5000;
    private int maxRetry = 3;
    private String hashAnterior;
    private String hashActual;
    private String hashSiguiente;
    private String nrTransaccion;
    private String policyTSA = "1.3.6.1.4.1.18332.5.1";
    private static final String MAIN_KEY = "12345678";
    X509Certificate[] userCertChain;

    public TSAClientANF(String url, X509Certificate[] chain) {
        this(url, chain, null, null, 10240, "SHA-256");
    }

    public TSAClientANF(String url, String user, String password) {
        this(url, null, user, password, 10240, "SHA-256");
    }

    public TSAClientANF(String url, X509Certificate[] chain, String user, String password) {
        this(url, chain, user, password, 10240, "SHA-256");
    }

    public TSAClientANF(String url, X509Certificate[] chain, String user, String password, int tokenStimatedSize, String digestAlgorithm) {
        super(url, user, password, tokenStimatedSize, digestAlgorithm);
        this.userCertChain = chain;
    }

    public TSAClientANF(TimeStampToken token) {
        super(null);
        try {
            AttributeTable unsignedAttributes = token.getUnsignedAttributes();
            if (unsignedAttributes != null) {
                ASN1EncodableVector vec = unsignedAttributes.toASN1EncodableVector();
                this.hashAnterior = this.getValueOfASN1Encodable(vec, 3);
                this.hashActual = this.getValueOfASN1Encodable(vec, 2);
                this.hashSiguiente = this.getValueOfASN1Encodable(vec, 1);
                this.nrTransaccion = this.getValueOfASN1Encodable(vec, 0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public boolean setReadTimeOut(int readTimeOut) {
        if (readTimeOut >= 1000 && readTimeOut <= 1000000) {
            this.readTimeOut = readTimeOut;
            return true;
        }
        return false;
    }

    public boolean setConnectTimeOut(int connectTimeOut) {
        if (connectTimeOut >= 1000 && connectTimeOut <= 1000000) {
            this.connectTimeOut = connectTimeOut;
            return true;
        }
        return false;
    }

    @Override
    public int getTokenSizeEstimate() {
        return this.tokenStimatedSize;
    }

    @Override
    public String getHashAnterior() {
        return this.hashAnterior;
    }

    @Override
    public String getHashActual() {
        return this.hashActual;
    }

    @Override
    public String getHashSiguiente() {
        return this.hashSiguiente;
    }

    @Override
    public String getNrTransaccion() {
        return this.nrTransaccion;
    }

    public void setPolicyTSA(String policyTSA) {
        this.policyTSA = policyTSA;
    }

    @Override
    public TimeStampToken getTimeStampToken(byte[] imprint) throws TSPException {
        return this.getTimeStampToken(this.digestAlgorithm, imprint);
    }

    @Override
    public TimeStampToken getTimeStampToken(String digestAlgorithm, byte[] imprint) throws TSPException {
        try {
            TimeStampRequest request = this.generateRequest(digestAlgorithm, imprint);
            TimeStampResponse response = this.getResponse(request);
            TimeStampToken tsToken = response.getTimeStampToken();
            if (tsToken == null) {
                TSUFailureException failure = new TSUFailureException((DERBitString)response.getFailInfo(), response.getStatusString());
                log.error((Object)failure);
                throw failure;
            }
            AttributeTable att = tsToken.getUnsignedAttributes();
            if (att != null) {
                ASN1EncodableVector vec = att.toASN1EncodableVector();
                this.hashAnterior = this.getValueOfASN1Encodable(vec, 3);
                this.hashActual = this.getValueOfASN1Encodable(vec, 2);
                this.hashSiguiente = this.getValueOfASN1Encodable(vec, 1);
                this.nrTransaccion = this.getValueOfASN1Encodable(vec, 0);
            }
            response.validate(request);
            log.info("timestamp ok from {}", (Object)this.tsaURL);
            return tsToken;
        }
        catch (TSUException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TSUException(ex);
        }
    }

    @Override
    public byte[] getTimeStampTokenEncoded(byte[] imprint) throws TSPException, IOException {
        return this.getTimeStampToken(imprint).getEncoded();
    }

    @Override
    public byte[] getTimeStampTokenEncoded(String digestAlgorithm, byte[] imprint) throws TSPException, IOException {
        return this.getTimeStampToken(digestAlgorithm, imprint).getEncoded();
    }

    public TimeStampResponse getResponse(TimeStampRequest request) throws IOException, TSUException, TSPException {
        byte[] requestBytes = request.getEncoded();
        byte[] respBytes = this.getTSAResponse(requestBytes);
        if (respBytes == null) {
            throw new TSUException();
        }
        return new TimeStampResponse(respBytes);
    }

    public TimeStampRequest generateRequest(byte[] imprint) {
        return this.generateRequest(this.digestAlgorithm, imprint);
    }

    public TimeStampRequest generateRequest(String digestAlgorithm, byte[] imprint) {
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        tsqGenerator.setReqPolicy(new ASN1ObjectIdentifier(this.policyTSA));
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        if (log.isInfoEnabled()) {
            log.info("timestamp request imprint: {} nonce: {} policy: {}", (Object)new String(Hex.encode((byte[])imprint)), (Object)nonce, (Object)this.policyTSA);
        }
        return tsqGenerator.generate(this.defaultDigestAlgorithmIdentifierFinder.find(digestAlgorithm), imprint, nonce);
    }

    private String getValueOfASN1Encodable(ASN1EncodableVector vec, int index) {
        if (vec.size() > index) {
            ASN1Encodable enc = vec.get(index);
            Attribute at = (Attribute)enc;
            DEROctetString oc = (DEROctetString)at.getAttrValues().getObjectAt(0);
            byte[] b = oc.getOctets();
            return new String(b);
        }
        return null;
    }

    @Override
    protected byte[] getTSAResponse(byte[] requestBytes) throws IOException {
        TreeMap<String, String> authHeaders = new TreeMap<String, String>();
        if (this.tsaUsername != null && this.tsaPassword != null) {
            authHeaders.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.tsaUsername + ":" + this.tsaPassword).getBytes()));
        }
        this.fillCertAuthHeaders(authHeaders);
        for (int i = 0; i < this.maxRetry; ++i) {
            try {
                return this.getTSAResponse(requestBytes, authHeaders);
            }
            catch (IOException e) {
                log.error("error al obtener respuesta del TSU: {}", (Object)this.tsaURL, (Object)e);
                if (i != this.maxRetry - 1) continue;
                throw new TSUException("max retries reached");
            }
        }
        throw new TSUException("max retries reached");
    }

    private byte[] getTSAResponse(byte[] requestBytes, Map<String, String> authHeaders) throws IOException {
        URL url = new URL(this.tsaURL);
        HttpURLConnection tsaConnection = (HttpURLConnection)url.openConnection();
        tsaConnection.setRequestMethod("POST");
        tsaConnection.setDoInput(true);
        tsaConnection.setDoOutput(true);
        tsaConnection.setUseCaches(false);
        tsaConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        for (Map.Entry<String, String> e : authHeaders.entrySet()) {
            tsaConnection.setRequestProperty(e.getKey(), e.getValue());
        }
        tsaConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        tsaConnection.setConnectTimeout(this.connectTimeOut);
        tsaConnection.setReadTimeout(this.readTimeOut);
        double time = 0.0;
        log.info("conectando con {}", (Object)this.tsaURL);
        OutputStream out = tsaConnection.getOutputStream();
        out.write(requestBytes);
        out.close();
        log.info("solicitud enviada a {}", (Object)this.tsaURL);
        double t1 = System.nanoTime();
        log.info("codigo de respuesta obtenido de {} {}", (Object)this.tsaURL, (Object)tsaConnection.getResponseCode());
        InputStream inp = tsaConnection.getInputStream();
        log.info("Tiempo respuesta del TSU (ms): {}", (Object)(time += ((double)System.nanoTime() - t1) / 1000000.0));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = inp.read(buffer, 0, buffer.length)) >= 0) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] respBytes = baos.toByteArray();
        if (respBytes == null || respBytes.length == 0) {
            throw new TSUException("empty response");
        }
        String encoding = tsaConnection.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("base64")) {
            respBytes = Base64.getDecoder().decode(respBytes);
        }
        if (tsaConnection.getContentType().equals("plain/text")) {
            throw new TSUException(new String(respBytes));
        }
        if (!tsaConnection.getContentType().equals("application/timestamp-reply")) {
            throw new TSUException("invalid content type: " + tsaConnection.getContentType());
        }
        return respBytes;
    }

    private void fillCertAuthHeaders(Map<String, String> authHeaders) {
        if (this.userCertChain != null && this.userCertChain.length == 1) {
            this.userCertChain = CertUtils.buildChain((X509Certificate[])this.userCertChain);
        }
        if (this.userCertChain != null && this.userCertChain.length > 1) {
            int finalCert = CertUtils.getFinalCert((X509Certificate[])this.userCertChain);
            X509Certificate userCert = this.userCertChain[finalCert];
            X509Certificate issuerCertificate = CertUtils.getIssuerCertificate((X509Certificate[])this.userCertChain, (X509Certificate)userCert);
            if (userCert != null && issuerCertificate != null) {
                try {
                    BigInteger instant = new BigInteger("" + System.nanoTime());
                    String otp = OTP.generate((String)MAIN_KEY, (String)instant.toString(), (int)32, (String)"totp");
                    SecretKeySpec secret = new SecretKeySpec(otp.getBytes(), "AES");
                    byte[] userCertEnc = this.encryptDataAES(userCert.getSerialNumber().toString().getBytes(), secret);
                    byte[] issuerCertEnc = this.encryptDataAES(issuerCertificate.getSerialNumber().toString().getBytes(), secret);
                    String authUser = new String(Base64.getEncoder().encode(userCertEnc));
                    String authParam = new String(Base64.getEncoder().encode(instant.toString().getBytes()));
                    String authIssuer = new String(Base64.getEncoder().encode(issuerCertEnc));
                    authHeaders.put("authorization-param", authParam);
                    authHeaders.put("authorization-user", authUser);
                    authHeaders.put("authorization-issuer", authIssuer);
                    if (this.tsaPassword != null) {
                        byte[] keyEnc = this.encryptDataAES(this.tsaPassword.getBytes(), secret);
                        String authKey = new String(Base64.getEncoder().encode(keyEnc));
                        authHeaders.put("authorization-key", authKey);
                    }
                    authHeaders.forEach((k, v) -> log.info("header {}={}", k, v));
                }
                catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    log.error("error al crear parametros de certificado", (Throwable)e);
                }
            }
        }
    }

    public byte[] encryptDataAES(byte[] data, SecretKey skeySpec) throws NoSuchAlgorithmException, NoSuchPaddingException, IOException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] iv = new byte[16];
        this.secureRandom.nextBytes(iv);
        IvParameterSpec algParam = new IvParameterSpec(iv);
        Cipher rsa = Cipher.getInstance("AES/OFB/NoPadding");
        rsa.init(1, (Key)skeySpec, algParam);
        byte[] updateBuffer = TSAClientANF.updateBuffer(data, rsa, 10);
        byte[] ciphertext = rsa.doFinal();
        byte[] ciphered = new byte[16 + updateBuffer.length + ciphertext.length];
        System.arraycopy(iv, 0, ciphered, 0, 16);
        System.arraycopy(updateBuffer, 0, ciphered, 16, updateBuffer.length);
        System.arraycopy(ciphertext, 0, ciphered, 16 + updateBuffer.length, ciphertext.length);
        return ciphered;
    }

    private static byte[] updateBuffer(byte[] data, Cipher rsa, int bufferSize) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < data.length; i += bufferSize) {
            byte[] buf = new byte[Math.min(bufferSize, data.length - i)];
            System.arraycopy(data, i, buf, 0, buf.length);
            byte[] update = rsa.update(buf);
            if (update == null) continue;
            out.write(update);
        }
        return out.toByteArray();
    }
}

