/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.definition;

import eu.europa.esig.dss.asic.xades.definition.ManifestAttribute;
import eu.europa.esig.dss.asic.xades.definition.ManifestElement;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.common.definition.AbstractPath;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;

public class ManifestPath
extends AbstractPath {
    private static final long serialVersionUID = 1661986382868079585L;
    public static final String FILE_ENTRY_PATH = ManifestPath.fromCurrentPosition((DSSElement[])new DSSElement[]{ManifestElement.MANIFEST, ManifestElement.FILE_ENTRY});

    public static String getFullPathAttribute(DSSNamespace manifestNamespace) {
        return ManifestPath.addPrefixIfNeeded(ManifestAttribute.FULL_PATH.getAttributeName(), manifestNamespace);
    }

    public static String getMediaTypeAttribute(DSSNamespace manifestNamespace) {
        return ManifestPath.addPrefixIfNeeded(ManifestAttribute.MEDIA_TYPE.getAttributeName(), manifestNamespace);
    }

    private static String addPrefixIfNeeded(String attributeName, DSSNamespace manifestNamespace) {
        if (Utils.isStringEmpty((String)manifestNamespace.getPrefix())) {
            return attributeName;
        }
        return manifestNamespace.getPrefix() + ':' + attributeName;
    }
}

