/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.verifier.key.impl;

import com.anf.oauth.client.exception.OauthClientException;
import com.anf.oauth.verifier.key.KeyDownloader;
import com.anf.oauth.verifier.key.KeyIdProvider;
import com.anf.oauth.verifier.key.impl.PublicKeyCacheHandler;
import com.auth0.jwk.Jwk;
import com.auth0.jwk.UrlJwkProvider;
import java.security.PublicKey;

public class WellKnownKeyDownloader
implements KeyDownloader,
KeyIdProvider {
    private String url;
    private PublicKeyCacheHandler cacheHandler;

    public WellKnownKeyDownloader(String url) {
        this.url = url;
        this.cacheHandler = new PublicKeyCacheHandler(this::getPublicKey);
    }

    @Override
    public PublicKey downloadKey(String keyId) {
        return this.cacheHandler.getPublicKeyCached(keyId);
    }

    @Override
    public PublicKey getPublicKey(PublicKey oldKey, String keyId) {
        try {
            UrlJwkProvider provider = new UrlJwkProvider(this.url);
            Jwk jwk = provider.get(keyId);
            if (jwk != null) {
                return jwk.getPublicKey();
            }
            throw new Exception("ERR_KEY_ID_NOT_FOUND:" + keyId);
        }
        catch (Throwable e) {
            if (oldKey == null) {
                throw new OauthClientException("ERR_GET_PUBLIC_KEY:" + e.getMessage(), e);
            }
            return oldKey;
        }
    }
}

