/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.verifier.key.impl;

import com.anf.oauth.client.PublicKeyClient;
import com.anf.oauth.client.exception.OauthClientException;
import com.anf.oauth.json.CredentialRequest;
import com.anf.oauth.verifier.key.KeyDownloader;
import com.anf.oauth.verifier.key.KeyIdProvider;
import com.anf.oauth.verifier.key.impl.PublicKeyCacheHandler;
import java.security.PublicKey;

public class RestApiKeyDownloader
implements KeyDownloader,
KeyIdProvider {
    private String clientId;
    private String clientSecret;
    private PublicKeyClient client;
    private PublicKeyCacheHandler cacheHandler;

    public RestApiKeyDownloader(PublicKeyClient client, String clientId, String clientSecret) {
        this.client = client;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.cacheHandler = new PublicKeyCacheHandler(this::getPublicKey);
    }

    @Override
    public PublicKey downloadKey(String keyId) {
        return this.cacheHandler.getPublicKeyCached(keyId);
    }

    @Override
    public PublicKey getPublicKey(PublicKey oldKey, String keyId) {
        CredentialRequest request = new CredentialRequest("client_credentials", this.clientId, this.clientSecret, "");
        try {
            return this.client.getPublicKey(request);
        }
        catch (Throwable e) {
            if (oldKey == null) {
                throw new OauthClientException("ERR_GET_PUBLIC_KEY:" + e.getMessage(), e);
            }
            return oldKey;
        }
    }
}

