/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.verifier.key.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class PublicKeyUtils {
    public static PublicKey getPublicKey(InputStream in) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, PGPException {
        try (PemReader pemReader = new PemReader((Reader)new InputStreamReader(in));){
            PublicKey key;
            PemObject obj = pemReader.readPemObject();
            if (obj.getType().equals("PUBLIC KEY")) {
                PublicKey key2;
                byte[] pemContent = obj.getContent();
                pemReader.close();
                X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(pemContent);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey publicKey = key2 = keyFactory.generatePublic(encodedKeySpec);
                return publicKey;
            }
            PGPPublicKey encKey = PublicKeyUtils.readPublicKey(in).get(0);
            PublicKey publicKey = key = PublicKeyUtils.convertPGPtoRSAPublicKey(encKey);
            return publicKey;
        }
    }

    public static PublicKey convertPGPtoRSAPublicKey(PGPPublicKey encKey) throws PGPException {
        return new JcaPGPKeyConverter().setProvider("BC").getPublicKey(encKey);
    }

    public static List<PGPPublicKey> readPublicKey(InputStream in) throws IOException, PGPException {
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>();
        in = PGPUtil.getDecoderStream((InputStream)in);
        JcaKeyFingerprintCalculator fingerPrintCalculator = new JcaKeyFingerprintCalculator();
        PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(in, (KeyFingerPrintCalculator)fingerPrintCalculator);
        Iterator rIt = pgpPub.getKeyRings();
        while (rIt.hasNext()) {
            PGPPublicKeyRing kRing = (PGPPublicKeyRing)rIt.next();
            Iterator kIt = kRing.getPublicKeys();
            while (kIt.hasNext()) {
                PGPPublicKey k = (PGPPublicKey)kIt.next();
                if (!k.isEncryptionKey()) continue;
                keys.add(k);
            }
        }
        if (!keys.isEmpty()) {
            return keys;
        }
        throw new IllegalArgumentException("Can't find encryption key in key ring.");
    }

    public static PublicKey getPublicKey(File file) throws PGPException, NoSuchProviderException, FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        FileInputStream in = new FileInputStream(file);
        return PublicKeyUtils.getPublicKey(in);
    }
}

