/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.verifier.key.impl;

import com.anf.oauth.verifier.key.KeyIdProvider;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.Date;

public class PublicKeyCacheHandler {
    private PublicKey publicKeyCached = null;
    private Date lastUpdate = null;
    private KeyIdProvider updateFunction;

    public PublicKeyCacheHandler(KeyIdProvider updateFunction) {
        this.updateFunction = updateFunction;
    }

    public PublicKey getPublicKeyCached(String keyId) {
        boolean update = false;
        if (this.publicKeyCached != null) {
            if (this.lastUpdate == null) {
                update = true;
            } else {
                Calendar cal = Calendar.getInstance();
                cal.add(6, -1);
                update = cal.getTime().after(this.lastUpdate);
            }
        } else {
            update = true;
        }
        if (update && this.updateFunction != null) {
            this.publicKeyCached = this.updateFunction.getPublicKey(this.publicKeyCached, keyId);
            this.lastUpdate = this.publicKeyCached != null ? new Date() : null;
        }
        return this.publicKeyCached;
    }
}

