/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.verifier.impl;

import com.anf.oauth.client.impl.PublicKeyClientRestApiImpl;
import com.anf.oauth.json.TokenResponse;
import com.anf.oauth.verifier.JWTVerifier;
import com.anf.oauth.verifier.key.KeyProvider;
import com.anf.oauth.verifier.key.impl.CachedMapKeyProvider;
import com.anf.oauth.verifier.key.impl.RestApiKeyDownloader;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;

public class JWTAccessTokenVerifier
implements JWTVerifier {
    private KeyProvider keyProvider;

    public JWTAccessTokenVerifier(String url, int timeout, String clientId, String clientSecret) {
        PublicKeyClientRestApiImpl client = new PublicKeyClientRestApiImpl(url, timeout);
        this.keyProvider = new CachedMapKeyProvider(new RestApiKeyDownloader(client, clientId, clientSecret));
    }

    public JWTAccessTokenVerifier() {
        this.keyProvider = new CachedMapKeyProvider();
    }

    @Override
    public synchronized DecodedJWT verify(TokenResponse jwt) throws Throwable {
        DecodedJWT token = JWT.decode((String)jwt.getAccess_token());
        PublicKey key = this.keyProvider.getKey(token.getKeyId(), token.getIssuer());
        if (key != null) {
            token = this.verifyToken(jwt, key);
        } else {
            throw new Exception("ERR_NULL_OAUTH_PUBLIC_KEY");
        }
        return token;
    }

    private DecodedJWT verifyToken(TokenResponse jwt, PublicKey key) {
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)key), null);
        com.auth0.jwt.JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
        DecodedJWT jwtDecoded = verifier.verify(jwt.getAccess_token());
        algorithm.verify(jwtDecoded);
        return jwtDecoded;
    }
}

