/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.json;

import com.anf.oauth.json.CalendarDeserializer;
import com.anf.oauth.json.InterfaceDeserializer;
import com.anf.oauth.json.MultiDateDeserializer;
import com.anf.oauth.json.exception.JsonException;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class JSONFactory {
    private static ObjectMapper mapper = new ObjectMapper();

    private JSONFactory() {
    }

    public static <T> T buildObject(String content, Class<T> clazz) {
        return JSONFactory.buildObject(content, null, clazz, reader -> reader);
    }

    public static <T> T buildObject(byte[] content, Class<T> clazz) {
        return JSONFactory.buildObject(content, null, clazz, reader -> reader);
    }

    public static <T> T buildObject(String content, String alias, Class<T> clazz) {
        return JSONFactory.buildObject(content, alias, clazz, reader -> reader);
    }

    public static <T> T buildObject(byte[] content, String alias, Class<T> clazz) {
        return JSONFactory.buildObject(content, alias, clazz, reader -> reader);
    }

    public static <T> T buildObject(String content, String alias, Class<T> clazz, UnaryOperator<ObjectReader> func) {
        try {
            if (func == null) {
                func = reader -> reader;
            }
            return (T)((ObjectReader)func.apply(mapper.reader().withRootName(alias))).readValue(content, clazz);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static <T> T buildObject(byte[] content, String alias, Class<T> clazz, UnaryOperator<ObjectReader> func) {
        try {
            if (func == null) {
                func = reader -> reader;
            }
            return (T)((ObjectReader)func.apply(mapper.reader().withRootName(alias))).readValue(content, clazz);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static <T> String buildJSON(T obj) {
        return JSONFactory.buildJSON(obj, null, writer -> writer);
    }

    public static <T> String buildJSON(T obj, String alias) {
        return JSONFactory.buildJSON(obj, alias, writer -> writer);
    }

    public static <T> String buildJSON(T obj, String alias, UnaryOperator<ObjectWriter> func) {
        try {
            if (func == null) {
                func = writer -> writer;
            }
            return ((ObjectWriter)func.apply(mapper.writer().withRootName(alias))).writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e);
        }
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static void setDateFormat(DateFormat dateFormat) {
        mapper.setDateFormat(dateFormat);
    }

    public static void configureJsonMapper(Consumer<ObjectMapper> config) {
        config.accept(mapper);
    }

    public static <I, C extends I> void deserializeInterface(Class<I> interfaceClass, Class<C> implClass) {
        JSONFactory.deserializeInterface(mapper, interfaceClass, implClass);
    }

    public static <I, C extends I> void deserializeInterface(ObjectMapper mapper, Class<I> interfaceClass, Class<C> implClass) {
        SimpleModule module = new SimpleModule(interfaceClass.getSimpleName() + "-" + implClass.getSimpleName());
        module.addDeserializer(interfaceClass, new InterfaceDeserializer<I, C>(interfaceClass, implClass));
        mapper.registerModule((Module)module);
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z"));
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        SimpleModule dateModule = new SimpleModule("date-format");
        dateModule.addDeserializer(Date.class, (JsonDeserializer)new MultiDateDeserializer());
        mapper.registerModule((Module)dateModule);
        SimpleModule calendarModule = new SimpleModule("calendar");
        calendarModule.addDeserializer(Calendar.class, (JsonDeserializer)new CalendarDeserializer());
        mapper.registerModule((Module)calendarModule);
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

