/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.client.impl;

import com.anf.oauth.client.AbstractClient;
import com.anf.oauth.client.OauthClient;
import com.anf.oauth.client.exception.OauthClientException;
import com.anf.oauth.json.CredentialRequest;
import com.anf.oauth.json.JSONFactory;
import com.anf.oauth.json.TokenResponse;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.io.IOUtils;

public class OauthClientStandardImpl
extends AbstractClient
implements OauthClient {
    public OauthClientStandardImpl(String url, long timeout) {
        super(url, timeout);
    }

    @Override
    public TokenResponse requestAccessToken(CredentialRequest credentialRequest) throws Throwable {
        TokenResponse token = new TokenResponse();
        if (this.url.contains("cognito") && !this.url.endsWith("/oauth2/token")) {
            this.url = this.url + "/oauth2/token";
        }
        URL urlConn = new URL(this.url);
        HttpURLConnection httpConn = (HttpURLConnection)urlConn.openConnection();
        httpConn.setConnectTimeout((int)this.timeout);
        httpConn.setReadTimeout((int)this.timeout);
        httpConn.setDoInput(true);
        httpConn.setDoOutput(true);
        httpConn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        httpConn.setRequestMethod("POST");
        httpConn.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString((credentialRequest.getClient_id() + ":" + credentialRequest.getClient_secret()).getBytes()));
        String formFields = String.format("grant_type=%s&scope=%s", credentialRequest.getGrant_type(), credentialRequest.getScope());
        byte[] postData = formFields.getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        httpConn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        try (DataOutputStream wr = new DataOutputStream(httpConn.getOutputStream());){
            wr.write(postData);
        }
        if (httpConn.getResponseCode() != 200) {
            throw new OauthClientException("Failed : HTTP error code : " + httpConn.getResponseCode() + ", response message: " + httpConn.getResponseMessage());
        }
        byte[] content = IOUtils.toByteArray((InputStream)httpConn.getInputStream());
        httpConn.disconnect();
        token = JSONFactory.buildObject(content, TokenResponse.class);
        return token;
    }
}

