/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.client.impl;

import com.anf.oauth.client.AbstractClient;
import com.anf.oauth.client.OauthClient;
import com.anf.oauth.json.CredentialRequest;
import com.anf.oauth.json.JSONFactory;
import com.anf.oauth.json.TokenResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class OauthClientRestApiImpl
extends AbstractClient
implements OauthClient {
    public OauthClientRestApiImpl(String url, long timeout) {
        super(url, timeout);
    }

    @Override
    public TokenResponse requestAccessToken(CredentialRequest credentialRequest) throws Throwable {
        TokenResponse token = new TokenResponse();
        URL urlConn = new URL(this.url + "oauth/token");
        HttpURLConnection httpConn = (HttpURLConnection)urlConn.openConnection();
        httpConn.setConnectTimeout((int)this.timeout);
        httpConn.setReadTimeout((int)this.timeout);
        httpConn.setDoInput(true);
        httpConn.setDoOutput(true);
        httpConn.setRequestProperty("Content-type", "application/json");
        httpConn.setRequestMethod("POST");
        String json = JSONFactory.buildJSON(credentialRequest);
        OutputStream os = httpConn.getOutputStream();
        os.write(json.getBytes());
        os.flush();
        byte[] content = IOUtils.toByteArray((InputStream)httpConn.getInputStream());
        httpConn.disconnect();
        token = JSONFactory.buildObject(content, TokenResponse.class);
        return token;
    }
}

